/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class StarbuncleModel
extends AnimatedGeoModel<Starbuncle> {
    private static final ResourceLocation WILD_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_wild_orange.png");
    private static final ResourceLocation TAMED_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_orange.png");

    public void setLivingAnimations(Starbuncle entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        if (entity.partyCarby) {
            return;
        }
        IBone head = this.getAnimationProcessor().getBone("head");
        if (customPredicate == null) {
            return;
        }
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
        head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
    }

    public ResourceLocation getModelLocation(Starbuncle carbuncle) {
        return new ResourceLocation("ars_nouveau", "geo/carbuncle.geo.json");
    }

    public ResourceLocation getTextureLocation(Starbuncle carbuncle) {
        return carbuncle.isTamed() ? TAMED_TEXTURE : WILD_TEXTURE;
    }

    public ResourceLocation getAnimationFileLocation(Starbuncle carbuncle) {
        return new ResourceLocation("ars_nouveau", "animations/starbuncle_animations.json");
    }
}

