/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker.recipe.manager.base;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.block.CTBlockIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.recipe.IOrechidRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.integration.crafttweaker.CTPlugin;

@Document(value="mods/Botania/recipe/manager/base/IOrechidManagerBase")
@ZenRegister
@ZenCodeType.Name(value="mods.botania.recipe.manager.base.IOrechidManagerBase")
public interface IOrechidManagerBase<T extends IOrechidRecipe>
extends IRecipeManager<T>,
IRecipeHandler<T> {
    @ZenCodeType.Method
    default public void registerOreWeight(String name, CTBlockIngredient output, Block input, int weight) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = CraftTweakerConstants.rl((String)name);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, this.makeRecipe(resourceLocation, input, CTPlugin.blockIngredientToStateIngredient(output), weight)));
    }

    public T makeRecipe(ResourceLocation var1, Block var2, StateIngredient var3, int var4);

    @ZenCodeType.Method
    default public void remove(BlockState output) {
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, recipe -> recipe.getOutput().test(output)));
    }

    default public void remove(IIngredient output) {
        throw new UnsupportedOperationException("Orechid does not output IItemStacks, use remove(BlockState)!");
    }

    default public String dumpToCommandString(IRecipeManager manager, T recipe) {
        StringJoiner s = new StringJoiner(", ", manager.getCommandString() + ".registerOreWeight(", ");");
        s.add(StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()));
        s.add(CTPlugin.ingredientToCommandString(recipe.getOutput()));
        s.add(ExpandBlock.getCommandString((Block)recipe.getInput()));
        s.add(String.valueOf(recipe.getWeight()));
        return s.toString();
    }

    default public Optional<Function<ResourceLocation, T>> replaceIngredients(IRecipeManager manager, T recipe, List<IReplacementRule> rules) {
        return Optional.empty();
    }
}

