/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl.mana;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaDiscountArmor;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.xplat.IXplatAbstractions;

public class ManaItemHandlerImpl
implements ManaItemHandler {
    @Override
    public List<ItemStack> getManaItems(Player player) {
        if (player == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>();
        for (ItemStack stackInSlot : Iterables.concat((Iterable)player.m_150109_().f_35974_, (Iterable)player.m_150109_().f_35976_)) {
            if (stackInSlot.m_41619_() || IXplatAbstractions.INSTANCE.findManaItem(stackInSlot) == null) continue;
            toReturn.add(stackInSlot);
        }
        IXplatAbstractions.INSTANCE.fireManaItemEvent(player, toReturn);
        return toReturn;
    }

    @Override
    public List<ItemStack> getManaAccesories(Player player) {
        if (player == null) {
            return Collections.emptyList();
        }
        Container acc = BotaniaAPI.instance().getAccessoriesInventory(player);
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>(acc.m_6643_());
        for (int slot = 0; slot < acc.m_6643_(); ++slot) {
            ItemStack stackInSlot = acc.m_8020_(slot);
            if (stackInSlot.m_41619_() || IXplatAbstractions.INSTANCE.findManaItem(stackInSlot) == null) continue;
            toReturn.add(stackInSlot);
        }
        return toReturn;
    }

    @Override
    public int requestMana(ItemStack stack, Player player, int manaToGet, boolean remove) {
        if (stack.m_41619_()) {
            return 0;
        }
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        int manaReceived = 0;
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IManaItem requestor;
            IManaItem manaItem;
            if (stackInSlot == stack || !(manaItem = IXplatAbstractions.INSTANCE.findManaItem(stackInSlot)).canExportManaToItem(stack) || manaItem.getMana() <= 0 || (requestor = IXplatAbstractions.INSTANCE.findManaItem(stack)) != null && !requestor.canReceiveManaFromItem(stackInSlot)) continue;
            int mana = Math.min(manaToGet - manaReceived, manaItem.getMana());
            if (remove) {
                manaItem.addMana(-mana);
            }
            if ((manaReceived += mana) < manaToGet) continue;
            break;
        }
        return manaReceived;
    }

    @Override
    public boolean requestManaExact(ItemStack stack, Player player, int manaToGet, boolean remove) {
        if (stack.m_41619_()) {
            return false;
        }
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        int manaReceived = 0;
        Object2IntOpenHashMap manaToRemove = new Object2IntOpenHashMap();
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItem;
            IManaItem manaItemSlot;
            if (stackInSlot == stack || !(manaItemSlot = IXplatAbstractions.INSTANCE.findManaItem(stackInSlot)).canExportManaToItem(stack) || (manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack)) != null && !manaItem.canReceiveManaFromItem(stackInSlot)) continue;
            int mana = Math.min(manaToGet - manaReceived, manaItemSlot.getMana());
            if (remove) {
                manaToRemove.put((Object)manaItemSlot, mana);
            }
            if ((manaReceived += mana) < manaToGet) continue;
            break;
        }
        if (manaReceived == manaToGet) {
            for (Object2IntMap.Entry e : manaToRemove.object2IntEntrySet()) {
                ((IManaItem)e.getKey()).addMana(-e.getIntValue());
            }
            return true;
        }
        return false;
    }

    @Override
    public int dispatchMana(ItemStack stack, Player player, int manaToSend, boolean add) {
        if (stack.m_41619_()) {
            return 0;
        }
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItem;
            IManaItem manaItemSlot;
            if (stackInSlot == stack || !(manaItemSlot = IXplatAbstractions.INSTANCE.findManaItem(stackInSlot)).canReceiveManaFromItem(stack) || (manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack)) != null && !manaItem.canExportManaToItem(stackInSlot)) continue;
            int received = manaItemSlot.getMana() + manaToSend <= manaItemSlot.getMaxMana() ? manaToSend : manaToSend - (manaItemSlot.getMana() + manaToSend - manaItemSlot.getMaxMana());
            if (add) {
                manaItemSlot.addMana(manaToSend);
            }
            return received;
        }
        return 0;
    }

    @Override
    public boolean dispatchManaExact(ItemStack stack, Player player, int manaToSend, boolean add) {
        if (stack.m_41619_()) {
            return false;
        }
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItem;
            IManaItem manaItemSlot;
            if (stackInSlot == stack || (manaItemSlot = IXplatAbstractions.INSTANCE.findManaItem(stackInSlot)).getMana() + manaToSend > manaItemSlot.getMaxMana() || !manaItemSlot.canReceiveManaFromItem(stack) || (manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack)) != null && !manaItem.canExportManaToItem(stackInSlot)) continue;
            if (add) {
                manaItemSlot.addMana(manaToSend);
            }
            return true;
        }
        return false;
    }

    private int discountManaForTool(ItemStack stack, Player player, int inCost) {
        float multiplier = Math.max(0.0f, 1.0f - this.getFullDiscountForTools(player, stack));
        return (int)((float)inCost * multiplier);
    }

    @Override
    public int requestManaForTool(ItemStack stack, Player player, int manaToGet, boolean remove) {
        int cost = this.discountManaForTool(stack, player, manaToGet);
        return this.requestMana(stack, player, cost, remove);
    }

    @Override
    public boolean requestManaExactForTool(ItemStack stack, Player player, int manaToGet, boolean remove) {
        int cost = this.discountManaForTool(stack, player, manaToGet);
        return this.requestManaExact(stack, player, cost, remove);
    }

    @Override
    public int getInvocationCountForTool(ItemStack stack, Player player, int manaToGet) {
        if (stack.m_41619_()) {
            return 0;
        }
        int cost = this.discountManaForTool(stack, player, manaToGet);
        int invocations = 0;
        List<ItemStack> items = this.getManaItems(player);
        List<ItemStack> acc = this.getManaAccesories(player);
        for (ItemStack stackInSlot : Iterables.concat(items, acc)) {
            IManaItem manaItem;
            if (stackInSlot == stack) continue;
            IManaItem manaItemSlot = IXplatAbstractions.INSTANCE.findManaItem(stackInSlot);
            int availableMana = manaItemSlot.getMana();
            if (!manaItemSlot.canExportManaToItem(stack) || availableMana <= cost || (manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack)) != null && !manaItem.canReceiveManaFromItem(stackInSlot)) continue;
            invocations += availableMana / cost;
        }
        return invocations;
    }

    @Override
    public float getFullDiscountForTools(Player player, ItemStack tool) {
        float discount = 0.0f;
        for (int i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            Item item;
            ItemStack armor = (ItemStack)player.m_150109_().f_35975_.get(i);
            if (armor.m_41619_() || !((item = armor.m_41720_()) instanceof IManaDiscountArmor)) continue;
            IManaDiscountArmor discountArmor = (IManaDiscountArmor)item;
            discount += discountArmor.getDiscount(armor, i, player, tool);
        }
        int unbreaking = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)tool);
        discount += (float)unbreaking * 0.05f;
        discount = IXplatAbstractions.INSTANCE.fireManaDiscountEvent(player, discount, tool);
        return discount;
    }

    @Override
    public boolean hasProficiency(Player player, ItemStack manaItem) {
        boolean proficient = false;
        for (EquipmentSlot e : EquipmentSlot.values()) {
            IManaProficiencyArmor armor;
            Item item;
            ItemStack stack;
            if (e.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = player.m_6844_(e)).m_41619_() || !((item = stack.m_41720_()) instanceof IManaProficiencyArmor) || !(armor = (IManaProficiencyArmor)item).shouldGiveProficiency(stack, e, player, manaItem)) continue;
            proficient = true;
            break;
        }
        return IXplatAbstractions.INSTANCE.fireManaProficiencyEvent(player, manaItem, proficient);
    }
}

