/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.common.item.ItemLaputaShard;
import vazkii.botania.common.item.ModItems;

public class LaputaShardUpgradeRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<LaputaShardUpgradeRecipe> SERIALIZER = new SimpleRecipeSerializer(LaputaShardUpgradeRecipe::new);

    public LaputaShardUpgradeRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level worldIn) {
        boolean foundShard = false;
        boolean foundSpirit = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(ModItems.laputaShard) && !foundShard && ItemLaputaShard.getShardLevel(stack) < 19) {
                foundShard = true;
                continue;
            }
            if (stack.m_150930_(ModItems.lifeEssence) && !foundSpirit) {
                foundSpirit = true;
                continue;
            }
            return false;
        }
        return foundShard && foundSpirit;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)ModItems.laputaShard);
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.laputaShard}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.lifeEssence})});
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!stack.m_150930_(ModItems.laputaShard)) continue;
            ItemStack result = stack.m_41777_();
            result.m_41784_().m_128405_("level", ItemLaputaShard.getShardLevel(stack) + 1);
            return result;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

