/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileTeruTeruBozu;
import vazkii.botania.common.helper.EntityHelper;

public class BlockTeruTeruBozu
extends BlockModWaterloggable
implements EntityBlock {
    private static final VoxelShape SHAPE = BlockTeruTeruBozu.m_49796_((double)4.0, (double)0.16, (double)4.0, (double)12.0, (double)15.84, (double)12.0);

    public BlockTeruTeruBozu(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity e) {
        ItemEntity item;
        ItemStack stack;
        if (!world.f_46443_ && e instanceof ItemEntity && (this.isSunflower(stack = (item = (ItemEntity)e).m_32055_()) && this.removeRain(world) || this.isBlueOrchid(stack) && this.startRain(world))) {
            EntityHelper.shrinkItem(item);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && (this.isSunflower(stack) && this.removeRain(world) || this.isBlueOrchid(stack) && this.startRain(world))) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean isSunflower(ItemStack stack) {
        return stack.m_150930_(Blocks.f_50355_.m_5456_());
    }

    private boolean isBlueOrchid(ItemStack stack) {
        return stack.m_150930_(Blocks.f_50113_.m_5456_());
    }

    private boolean removeRain(Level world) {
        if (world.m_46471_()) {
            world.m_6106_().m_5565_(false);
            TileTeruTeruBozu.resetRainTime(world);
            return true;
        }
        return false;
    }

    private boolean startRain(Level world) {
        if (!world.m_46471_()) {
            if (world.f_46441_.nextInt(10) == 0) {
                world.m_6106_().m_5565_(true);
                TileTeruTeruBozu.resetRainTime(world);
            }
            return true;
        }
        return false;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return world.m_46471_() ? 15 : 0;
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileTeruTeruBozu(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.f_46443_) {
            return BlockTeruTeruBozu.createTickerHelper(type, ModTiles.TERU_TERU_BOZU, TileTeruTeruBozu::serverTick);
        }
        return null;
    }
}

