/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractGuiNode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;

public abstract class TextBoxNode
extends AbstractGuiNode {
    private static final int BORDER_COLOR = -6250336;
    private static final int BACKGROUND_COLOR = -16777216;
    private static final int SUGGESTION_COLOR = -6250336;
    private static final int ENABLED_COLOR = 0xE0E0E0;
    private static final int DISABLED_COLOR = 0x707070;
    protected String currentText = "";
    protected int characterLimit = -1;
    protected boolean focused = false;
    protected boolean enabled = true;

    public TextBoxNode(String initialText) {
        this.currentText = initialText;
    }

    public String getText() {
        return this.currentText;
    }

    public void setText(String text) {
        this.currentText = text;
    }

    public boolean isEditing() {
        return this.enabled && this.focused;
    }

    public void setCharacterLimit(int limit) {
        this.characterLimit = limit;
    }

    @Override
    public void drawBack(PoseStack stack, Point mouse, float partialFrame) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getFrame().width();
        int height = this.getFrame().height();
        GuiComponent.m_93172_((PoseStack)stack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-6250336);
        GuiComponent.m_93172_((PoseStack)stack, (int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-16777216);
        Font fontRenderer = this.getRoot().getFontRenderer();
        String suggestion = this.getSuggestionString();
        Objects.requireNonNull(fontRenderer);
        int lineHeight = 9;
        int leftPad = 4;
        int textX = x + leftPad;
        int textY = y + height / 2 - lineHeight / 2;
        if (this.currentText.isEmpty() && !suggestion.isEmpty()) {
            fontRenderer.m_92883_(stack, suggestion, (float)textX, (float)textY, -6250336);
        }
        if (!this.currentText.isEmpty()) {
            Object s = this.currentText;
            if (this.enabled && this.focused && System.currentTimeMillis() % 1000L > 500L) {
                s = (String)s + "_";
            }
            fontRenderer.m_92750_(stack, (String)s, (float)textX, (float)textY, this.enabled ? 0xE0E0E0 : 0x707070);
        }
    }

    @Override
    public boolean mouseClicked(Point p, int glfwMouseButton, boolean consumed) {
        if (this.enabled && !consumed && this.isFirstHit(p)) {
            this.setFocused(true);
            if (glfwMouseButton == 1) {
                this.currentText = "";
            }
            return true;
        }
        this.setFocused(false);
        return false;
    }

    @Override
    public boolean onKeyPressed(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        if (!this.focused || !this.enabled) {
            return false;
        }
        boolean changed = false;
        if (Screen.m_96630_((int)glfwKeyCode)) {
            String clipboard = Minecraft.m_91087_().f_91068_.m_90876_();
            changed = this.appendText(clipboard);
        } else {
            switch (glfwKeyCode) {
                case 259: {
                    changed = this.backspaceText();
                    break;
                }
                case 256: {
                    this.setFocused(false);
                    break;
                }
                case 257: {
                    this.setFocused(false);
                    this.onReturnPressed();
                }
            }
        }
        if (changed) {
            this.onTextChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean onCharTyped(char ch, int glfwFlags, boolean consumed) {
        if (!this.focused || !this.enabled) {
            return false;
        }
        if (this.appendChar(ch)) {
            this.onTextChanged();
            return true;
        }
        return false;
    }

    private void setFocused(boolean focused) {
        this.focused = focused;
    }

    private boolean appendText(String text) {
        StringBuilder builder = new StringBuilder(this.currentText);
        char[] chars = text.toCharArray();
        int i = 0;
        while (builder.length() < this.getCharacterLimit() && i < chars.length) {
            char next;
            if (!this.isCharAllowed(next = chars[i++])) continue;
            builder.append(next);
        }
        String newText = builder.toString();
        if (!newText.equals(this.currentText)) {
            this.currentText = newText;
            return true;
        }
        return false;
    }

    private boolean appendChar(char c) {
        if (this.currentText.length() < this.getCharacterLimit() && this.isCharAllowed(c)) {
            this.currentText = this.currentText + c;
            return true;
        }
        return false;
    }

    private boolean backspaceText() {
        if (this.currentText.length() > 0) {
            this.currentText = this.currentText.substring(0, this.currentText.length() - 1);
            return true;
        }
        return false;
    }

    private boolean isCharAllowed(char c) {
        return true;
    }

    private int getCharacterLimit() {
        if (this.characterLimit == -1) {
            return this.getFrame().width() / 6;
        }
        return this.characterLimit;
    }

    protected abstract String getSuggestionString();

    protected abstract void onTextChanged();

    protected abstract void onReturnPressed();
}

