/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.lib;

import codechicken.lib.vec.Vertex5;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class ModelLib {
    public static void exportVertsToJson(String filePath, Map<String, Vertex5[]> vertGroups) {
        try (PrintWriter writer = new PrintWriter(filePath);){
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            jsonWriter.setIndent("    ");
            jsonWriter.beginObject();
            for (Map.Entry<String, Vertex5[]> entry : vertGroups.entrySet()) {
                jsonWriter.name(entry.getKey());
                jsonWriter.beginArray();
                for (int i = 0; i < entry.getValue().length; ++i) {
                    Vertex5 vertex = entry.getValue()[i];
                    jsonWriter.beginObject();
                    jsonWriter.name("x").value(vertex.vec.x);
                    jsonWriter.name("y").value(vertex.vec.y);
                    jsonWriter.name("z").value(vertex.vec.z);
                    jsonWriter.name("u").value(vertex.uv.u);
                    jsonWriter.name("v").value(vertex.uv.v);
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            jsonWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Vertex5[]> importVertsFromJson(ResourceManager resourceManager, ResourceLocation resource) {
        try (Resource res = resourceManager.m_142591_(resource);){
            Map<String, Vertex5[]> map;
            block14: {
                InputStream stream = res.m_6679_();
                try {
                    map = ModelLib.importVertsFromJson(new InputStreamReader(stream));
                    if (stream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Vertex5[]> importVertsFromJson(String filePath) {
        Map<String, Vertex5[]> map;
        FileReader reader = new FileReader(filePath);
        try {
            map = ModelLib.importVertsFromJson(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return map;
    }

    public static Map<String, Vertex5[]> importVertsFromJson(Reader reader) {
        try {
            HashMap<String, Vertex5[]> vertMap = new HashMap<String, Vertex5[]>();
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String name = jsonReader.nextName();
                LinkedList<Vertex5> verts = new LinkedList<Vertex5>();
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    Vertex5 vertex = new Vertex5();
                    jsonReader.beginObject();
                    block18: while (jsonReader.hasNext()) {
                        String key;
                        switch (key = jsonReader.nextName()) {
                            case "x": {
                                vertex.vec.x = jsonReader.nextDouble();
                                continue block18;
                            }
                            case "y": {
                                vertex.vec.y = jsonReader.nextDouble();
                                continue block18;
                            }
                            case "z": {
                                vertex.vec.z = jsonReader.nextDouble();
                                continue block18;
                            }
                            case "u": {
                                vertex.uv.u = jsonReader.nextDouble();
                                continue block18;
                            }
                            case "v": {
                                vertex.uv.v = jsonReader.nextDouble();
                                continue block18;
                            }
                        }
                        throw new RuntimeException("Invalid key: " + key);
                    }
                    jsonReader.endObject();
                    verts.add(vertex);
                }
                jsonReader.endArray();
                vertMap.put(name, verts.toArray(new Vertex5[0]));
            }
            jsonReader.endObject();
            return vertMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

