/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.part;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.BlockMultipart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.PartMap;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.part.IConnectablePart;
import mrtjp.projectred.core.part.IOrientableFacePart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;

public interface IConnectableFacePart
extends MultiPart,
IConnectablePart,
IOrientableFacePart {
    default public BlockPos posOfCorner(int r) {
        return this.pos().m_142300_(Direction.values()[this.absoluteDir(r)]).m_142300_(Direction.values()[this.getSide()]);
    }

    default public BlockPos posOfStraight(int r) {
        return this.pos().m_142300_(Direction.values()[this.absoluteDir(r)]);
    }

    default public int rotFromCorner(int r) {
        return Rotation.rotationTo((int)(this.absoluteDir(r) ^ 1), (int)(this.getSide() ^ 1));
    }

    default public int rotFromStraight(int r) {
        return (r + 2) % 4;
    }

    default public int rotFromInternal(int r) {
        return Rotation.rotationTo((int)this.absoluteDir(r), (int)this.getSide());
    }

    @Nullable
    default public IConnectable getCorner(int r) {
        int absDir = this.absoluteDir(r);
        BlockPos pos = this.pos().m_142300_(Direction.values()[absDir]).m_142300_(Direction.values()[this.getSide()]);
        MultiPart part = BlockMultipart.getPart((BlockGetter)this.level(), (BlockPos)pos, (int)(absDir ^ 1));
        return part instanceof IConnectable ? (IConnectable)part : null;
    }

    @Nullable
    default public IConnectable getStraight(int r) {
        BlockPos pos = this.pos().m_142300_(Direction.values()[this.absoluteDir(r)]);
        MultiPart part = BlockMultipart.getPart((BlockGetter)this.level(), (BlockPos)pos, (int)this.getSide());
        return part instanceof IConnectable ? (IConnectable)part : null;
    }

    @Nullable
    default public IConnectable getInternal(int r) {
        MultiPart part = this.tile().getSlottedPart(this.absoluteDir(r));
        return part instanceof IConnectable ? (IConnectable)part : null;
    }

    @Nullable
    default public IConnectable getCenter() {
        MultiPart part = this.tile().getSlottedPart(6);
        return part instanceof IConnectable ? (IConnectable)part : null;
    }

    public boolean canConnectPart(IConnectable var1, int var2);

    default public boolean maskOpen(int r) {
        return (this.getConnMap() & 4096 << r) != 0;
    }

    default public boolean maskConnects(int r) {
        return (this.getConnMap() & 273 << r) != 0;
    }

    default public boolean maskConnectsCorner(int r) {
        return (this.getConnMap() & 1 << r) != 0;
    }

    default public boolean maskConnectsStraight(int r) {
        return (this.getConnMap() & 16 << r) != 0;
    }

    default public boolean maskConnectsInside(int r) {
        return (this.getConnMap() & 256 << r) != 0;
    }

    default public boolean maskConnectsCenter() {
        return (this.getConnMap() & 0x10000) != 0;
    }

    @Override
    default public boolean connectCorner(IConnectable part, int r, int edgeRot) {
        if (this.canConnectPart(part, r) && this.maskOpen(r)) {
            int connMap = this.getConnMap();
            connMap |= 1 << r;
            if (this.setRenderFlag(part)) {
                connMap |= 0x100000 << r;
            }
            if (connMap != this.getConnMap()) {
                this.setConnMap(connMap);
                this.onMaskChanged();
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean connectStraight(IConnectable part, int r, int edgeRot) {
        if (this.canConnectPart(part, r) && this.maskOpen(r)) {
            int connMap = this.getConnMap();
            if ((connMap |= 16 << r) != this.getConnMap()) {
                this.setConnMap(connMap);
                this.onMaskChanged();
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean connectInternal(IConnectable part, int r) {
        if (this.canConnectPart(part, r)) {
            int connMap = this.getConnMap();
            if ((connMap |= 256 << r) != this.getConnMap()) {
                this.setConnMap(connMap);
                this.onMaskChanged();
            }
            return true;
        }
        return false;
    }

    public boolean setRenderFlag(IConnectable var1);

    default public boolean outsideCornerEdgeOpen(int r) {
        int absDir = this.absoluteDir(r);
        BlockPos pos = this.pos().m_142300_(Direction.values()[absDir]);
        if (this.level().m_46859_(pos)) {
            return true;
        }
        int side1 = absDir ^ 1;
        int side2 = this.getSide();
        TileMultipart t = BlockMultipart.getTile((BlockGetter)this.level(), (BlockPos)pos);
        if (t == null) {
            return false;
        }
        return t.getSlottedPart(side1) == null && t.getSlottedPart(side2) == null && t.getSlottedPart(PartMap.edgeBetween((int)side1, (int)side2)) == null;
    }

    default public boolean insideCornerEdgeOpen(int r) {
        return this.tile().getSlottedPart(PartMap.edgeBetween((int)this.absoluteDir(r), (int)this.getSide())) == null;
    }

    public boolean discoverOpen(int var1);

    default public int discoverCorner(int r) {
        if (!this.outsideCornerEdgeOpen(r)) {
            return 0;
        }
        IConnectable c = this.getCorner(r);
        if (c != null) {
            if ((c.canConnectCorner(this.rotFromCorner(r)) || this.canConnectCorner(r)) && this.canConnectPart(c, r) && c.connectCorner(this, this.rotFromCorner(r), -1)) {
                return this.setRenderFlag(c) ? 2 : 1;
            }
            return 0;
        }
        return this.discoverCornerOverride(this.absoluteDir(r)) ? 2 : 0;
    }

    default public boolean discoverStraight(int r) {
        IConnectable c = this.getStraight(r);
        if (c != null) {
            return this.canConnectPart(c, r) && c.connectStraight(this, this.rotFromStraight(r), -1);
        }
        return this.discoverStraightOverride(this.absoluteDir(r));
    }

    default public boolean discoverInternal(int r) {
        if (!this.insideCornerEdgeOpen(r)) {
            return false;
        }
        IConnectable c = this.getInternal(r);
        if (c != null) {
            return this.canConnectPart(c, r) && c.connectInternal(this, this.rotFromInternal(r));
        }
        return this.discoverInternalOverride(r);
    }

    default public boolean discoverCenter() {
        IConnectable c = this.getCenter();
        if (c != null) {
            return this.canConnectPart(c, -1) && c.connectInternal(this, -1);
        }
        return false;
    }

    default public boolean shouldDiscoverCenter() {
        return true;
    }

    default public boolean discoverCornerOverride(int absDir) {
        return false;
    }

    default public boolean discoverStraightOverride(int absDir) {
        return false;
    }

    default public boolean discoverInternalOverride(int r) {
        return false;
    }

    @Override
    default public boolean updateOpenConns() {
        int connMap = this.getConnMap() & 0xFFFF0FFF;
        for (int r = 0; r < 4; ++r) {
            if (!this.discoverOpen(r)) continue;
            connMap |= 4096 << r;
        }
        if (connMap != this.getConnMap()) {
            this.setConnMap(connMap);
            return true;
        }
        return false;
    }

    @Override
    default public boolean updateExternalConns() {
        int connMap = this.getConnMap() & 0xFF0FFF00;
        for (int r = 0; r < 4; ++r) {
            if (!this.maskOpen(r)) continue;
            if (this.discoverStraight(r)) {
                connMap |= 16 << r;
                continue;
            }
            int cornerMode = this.discoverCorner(r);
            if (cornerMode == 0) continue;
            connMap |= 1 << r;
            if (cornerMode != 2) continue;
            connMap |= 0x100000 << r;
        }
        if (connMap != this.getConnMap()) {
            int diff = connMap ^ this.getConnMap();
            this.setConnMap(connMap);
            for (int r = 0; r < 4; ++r) {
                if ((diff & 1 << r) == 0) continue;
                this.notifyCorner(r);
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean updateInternalConns() {
        int connMap = this.getConnMap() & 0xFFFEF0FF;
        for (int r = 0; r < 4; ++r) {
            if (!this.discoverInternal(r)) continue;
            connMap |= 256 << r;
        }
        if (this.shouldDiscoverCenter() && this.discoverCenter()) {
            connMap |= 0x10000;
        }
        if (connMap != this.getConnMap()) {
            this.setConnMap(connMap);
            return true;
        }
        return false;
    }

    @Override
    default public void notifyAllExternals() {
        this.notifyExternals(15);
    }

    default public void notifyExternals(int mask) {
        for (int r = 0; r < 4; ++r) {
            if ((mask & 1 << r) == 0) continue;
            if (this.maskConnectsCorner(r)) {
                this.notifyCorner(r);
                continue;
            }
            if (!this.maskConnectsStraight(r)) continue;
            this.notifyStraight(r);
        }
    }

    default public void notifyCorner(int r) {
        BlockPos pos = this.posOfCorner(r);
        this.level().m_46586_(pos, this.tile().m_58900_().m_60734_(), pos);
    }

    default public void notifyStraight(int r) {
        BlockPos pos = this.posOfStraight(r);
        this.level().m_46586_(pos, this.tile().m_58900_().m_60734_(), pos);
    }
}

