/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FaceLookup {
    public final Level world;
    public final BlockPos pos;
    public final int side;
    public final int r;
    public final BlockState state;
    public final Block block;
    @Nullable
    public final BlockEntity tile;
    @Nullable
    public final MultiPart part;
    public final BlockPos otherPos;
    public final int otherSide;
    public final int otherRotation;

    public FaceLookup(Level world, BlockPos pos, int side, int r, BlockState state, @Nullable BlockEntity tile, @Nullable MultiPart part, BlockPos otherPos, int otherSide, int otherRotation) {
        this.world = world;
        this.pos = pos;
        this.side = side;
        this.r = r;
        this.state = state;
        this.block = state.m_60734_();
        this.tile = tile;
        this.part = part;
        this.otherPos = otherPos;
        this.otherSide = otherSide;
        this.otherRotation = otherRotation;
    }

    public static FaceLookup lookupCorner(Level world, BlockPos pos, int side, int r) {
        int absDir = Rotation.rotateSide((int)side, (int)r);
        int otherSide = absDir ^ 1;
        int otherRotation = Rotation.rotationTo((int)(absDir ^ 1), (int)(side ^ 1));
        BlockPos pos2 = pos.m_142300_(Direction.values()[absDir]).m_142300_(Direction.values()[side]);
        BlockState state = world.m_8055_(pos2);
        BlockEntity tile = world.m_7702_(pos2);
        MultiPart part = null;
        if (tile instanceof TileMultipart) {
            part = ((TileMultipart)tile).getSlottedPart(otherSide);
        }
        return new FaceLookup(world, pos, side, r, state, tile, part, pos2, otherSide, otherRotation);
    }

    public static FaceLookup lookupStraight(Level world, BlockPos pos, int side, int r) {
        int otherSide = side;
        int otherRotation = (r + 2) % 4;
        BlockPos pos2 = pos.m_142300_(Direction.values()[Rotation.rotateSide((int)side, (int)r)]);
        BlockState state = world.m_8055_(pos2);
        BlockEntity tile = world.m_7702_(pos2);
        MultiPart part = null;
        if (tile instanceof TileMultipart) {
            part = ((TileMultipart)tile).getSlottedPart(otherSide);
        }
        return new FaceLookup(world, pos, side, r, state, tile, part, pos2, otherSide, otherRotation);
    }

    public static FaceLookup lookupInsideFace(Level world, BlockPos pos, int side, int r) {
        int absDir;
        int otherSide = absDir = Rotation.rotateSide((int)side, (int)r);
        int otherRotation = Rotation.rotationTo((int)absDir, (int)side);
        BlockState state = world.m_8055_(pos);
        BlockEntity tile = world.m_7702_(pos);
        MultiPart part = null;
        if (tile instanceof TileMultipart) {
            part = ((TileMultipart)tile).getSlottedPart(otherSide);
        }
        return new FaceLookup(world, pos, side, r, state, tile, part, pos, otherSide, otherRotation);
    }

    public static FaceLookup lookupInsideCenter(Level world, BlockPos pos, int side) {
        int otherSide = side;
        int otherRotation = -1;
        BlockState state = world.m_8055_(pos);
        BlockEntity tile = world.m_7702_(pos);
        MultiPart part = null;
        if (tile instanceof TileMultipart) {
            part = ((TileMultipart)tile).getSlottedPart(6);
        }
        return new FaceLookup(world, pos, side, -1, state, tile, part, pos, otherRotation, otherSide);
    }
}

