/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.packet.PacketCustomChannelBuilder;
import java.util.Objects;
import mrtjp.projectred.core.tile.IPacketReceiverTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CoreNetwork {
    public static final ResourceLocation NET_CHANNEL = new ResourceLocation("projectred_core", "network");
    public static final int NET_TILE_PACKET_TO_CLIENT = 1;
    public static final int NET_TILE_PACKET_TO_SERVER = 3;

    public static void init() {
        PacketCustomChannelBuilder.named((ResourceLocation)NET_CHANNEL).assignClientHandler(() -> ClientHandler::new).assignServerHandler(() -> ServerHandler::new).build();
    }

    public static PacketCustom createTileClientPacket(IPacketReceiverTile tile, byte key) {
        PacketCustom packet = new PacketCustom(NET_CHANNEL, 1);
        packet.writePos(tile.getBlockPosition());
        packet.writeByte((int)key);
        return packet;
    }

    public static PacketCustom createTileServerPacket(IPacketReceiverTile tile, byte key) {
        PacketCustom packet = new PacketCustom(NET_CHANNEL, 3);
        packet.writePos(tile.getBlockPosition());
        packet.writeByte((int)key);
        return packet;
    }

    private static class ServerHandler
    implements ICustomPacketHandler.IServerPacketHandler {
        private ServerHandler() {
        }

        public void handlePacket(PacketCustom packet, ServerPlayer sender, ServerGamePacketListenerImpl handler) {
            switch (packet.getType()) {
                case 3: {
                    this.handleTilePacket((Level)sender.m_183503_(), (MCDataInput)packet, sender);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid key received from client: " + packet.getType());
                }
            }
        }

        private void handleTilePacket(Level world, MCDataInput data, ServerPlayer sender) {
            BlockEntity tile = world.m_7702_(data.readPos());
            short key = data.readUByte();
            if (tile instanceof IPacketReceiverTile) {
                ((IPacketReceiverTile)tile).receiveUpdateFromClient(key, data, sender);
            }
        }
    }

    private static class ClientHandler
    implements ICustomPacketHandler.IClientPacketHandler {
        private ClientHandler() {
        }

        public void handlePacket(PacketCustom packet, Minecraft mc, ClientPacketListener handler) {
            switch (packet.getType()) {
                case 1: {
                    this.handleTilePacket((Level)Objects.requireNonNull(mc.f_91073_), (MCDataInput)packet);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid key received from server: " + packet.getType());
                }
            }
        }

        private void handleTilePacket(Level world, MCDataInput data) {
            BlockEntity tile = world.m_7702_(data.readPos());
            short key = data.readUByte();
            if (tile instanceof IPacketReceiverTile) {
                ((IPacketReceiverTile)tile).receiveUpdateFromServer(key, data);
            }
        }
    }
}

