/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.IBundledTileInteraction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BundledSignalsLib {
    public static final int[] bundledCableBaseRotationMap = new int[]{0, 3, 3, 0, 0, 3};
    private static final List<IBundledTileInteraction> interactions = new LinkedList<IBundledTileInteraction>();

    public static void registerBundledTileInteraction(IBundledTileInteraction interaction) {
        interactions.add(interaction);
    }

    @Nullable
    public static byte[] getBundledInput(Level world, BlockPos pos, Direction facing) {
        int side = facing.ordinal();
        BlockEntity tile = world.m_7702_(pos.m_142300_(facing));
        if (tile instanceof IBundledTile) {
            return ((IBundledTile)tile).getBundledSignal(side ^ 1);
        }
        if (tile instanceof TileMultipart) {
            TileMultipart tmp = (TileMultipart)tile;
            byte[] signal = null;
            for (int r = 0; r < 4; ++r) {
                int pside = Rotation.rotateSide((int)side, (int)r);
                MultiPart part = tmp.getSlottedPart(pside);
                if (!(part instanceof IBundledEmitter)) continue;
                int pr = Rotation.rotationTo((int)pside, (int)(side ^ 1));
                signal = BundledSignalsLib.raiseSignal(signal, ((IBundledEmitter)part).getBundledSignal(pr));
            }
            MultiPart part = tmp.getSlottedPart(6);
            if (part instanceof IBundledEmitter) {
                signal = BundledSignalsLib.raiseSignal(signal, ((IBundledEmitter)part).getBundledSignal(side ^ 1));
            }
            return signal;
        }
        return null;
    }

    public static boolean canConnectBundledViaInteraction(Level world, BlockPos pos, Direction side) {
        for (IBundledTileInteraction interaction : interactions) {
            if (!interaction.isValidInteractionFor(world, pos, side)) continue;
            return interaction.canConnectBundled(world, pos, side);
        }
        return false;
    }

    public static boolean isValidInteractionFor(Level world, BlockPos pos, Direction side) {
        for (IBundledTileInteraction interaction : interactions) {
            if (!interaction.isValidInteractionFor(world, pos, side)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static byte[] getBundledSignalViaInteraction(Level world, BlockPos pos, Direction side) {
        for (IBundledTileInteraction interaction : interactions) {
            if (!interaction.isValidInteractionFor(world, pos, side)) continue;
            return interaction.getBundledSignal(world, pos, side);
        }
        return null;
    }

    public static boolean signalsEqual(@Nullable byte[] signal1, @Nullable byte[] signal2) {
        if (signal1 == null) {
            return BundledSignalsLib.isSignalZero(signal2);
        }
        if (signal2 == null) {
            return BundledSignalsLib.isSignalZero(signal1);
        }
        if (signal1.length != signal2.length) {
            return false;
        }
        for (int i = 0; i < signal1.length; ++i) {
            if (signal1[i] == signal2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSignalZero(@Nullable byte[] signal) {
        if (signal == null) {
            return true;
        }
        for (byte b : signal) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isSignalZero(@Nullable byte[] signal, int mask) {
        if (signal == null) {
            return true;
        }
        for (int i = 0; i < signal.length; ++i) {
            if ((mask & 1 << i) == 0 || signal[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean dropSignalsLessThan(byte[] signal, byte[] threshold) {
        boolean dropped = false;
        for (int i = 0; i < 16; ++i) {
            if ((threshold[i] & 0xFF) >= (signal[i] & 0xFF)) continue;
            signal[i] = 0;
            dropped = true;
        }
        return dropped;
    }

    public static void applyChangeMask(byte[] source, byte[] dest, int mask) {
        for (int i = 0; i < 16; ++i) {
            if ((mask & 1 << i) != 0) continue;
            dest[i] = source[i];
        }
    }

    public static byte[] raiseSignal(@Nullable byte[] signal, @Nullable byte[] source) {
        if (signal == null) {
            signal = new byte[16];
        }
        if (source == null) {
            return signal;
        }
        for (int i = 0; i < 16; ++i) {
            if ((signal[i] & 0xFF) >= (source[i] & 0xFF)) continue;
            signal[i] = source[i];
        }
        return signal;
    }

    @Nullable
    public static byte[] copySignal(@Nullable byte[] signal) {
        return signal == null ? null : (byte[])signal.clone();
    }

    public static void saveSignal(CompoundTag tag, String key, @Nullable byte[] signal) {
        if (signal != null) {
            tag.m_128382_(key, signal);
        }
    }

    @Nullable
    public static byte[] loadSignal(CompoundTag tag, String key) {
        if (tag.m_128441_(key)) {
            return (byte[])tag.m_128463_(key).clone();
        }
        return null;
    }

    public static int packDigital(@Nullable byte[] signal) {
        if (signal == null) {
            return 0;
        }
        int packed = 0;
        for (int i = 0; i < 16; ++i) {
            if (signal[i] == 0) continue;
            packed |= 1 << i;
        }
        return packed;
    }

    @Nullable
    public static byte[] unpackDigital(@Nullable byte[] signal, int packed) {
        if (packed == 0) {
            if (signal != null) {
                Arrays.fill(signal, (byte)0);
            }
            return signal;
        }
        if (signal == null) {
            signal = new byte[16];
        }
        for (int i = 0; i < 16; ++i) {
            signal[i] = (packed & 1 << i) != 0 ? -1 : 0;
        }
        return signal;
    }

    public static int mostSignificantBit(int mask) {
        int idx = 0;
        int m2 = mask >>> 1;
        while (m2 != 0) {
            m2 >>>= 1;
            ++idx;
        }
        return idx;
    }

    public static String signalToString(byte[] signal) {
        if (BundledSignalsLib.isSignalZero(signal)) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            sb.append("[").append(signal[i] & 0xFF).append("]");
        }
        return sb.toString();
    }
}

