/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.loot;

import com.google.common.base.Predicates;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.server.ServerLifecycleHooks;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.compat.GameStagesCompat;
import shadows.apotheosis.adventure.loot.AffixLootEntry;
import shadows.apotheosis.adventure.loot.AffixLootManager;
import shadows.apotheosis.adventure.loot.LootController;
import shadows.apotheosis.adventure.loot.LootRarity;

public class AffixLootPoolEntry
extends LootPoolSingletonContainer {
    public static final Serializer SERIALIZER = new Serializer();
    public static final LootPoolEntryType TYPE = new LootPoolEntryType((net.minecraft.world.level.storage.loot.Serializer)SERIALIZER);
    private static Set<AffixLootPoolEntry> awaitingLoad = Collections.newSetFromMap(new WeakHashMap());
    @Nullable
    private final LootRarity rarity;
    private final List<ResourceLocation> entries;
    private List<AffixLootEntry> resolvedEntries = Collections.emptyList();

    public AffixLootPoolEntry(@Nullable LootRarity rarity, List<ResourceLocation> entries, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.rarity = rarity;
        this.entries = entries;
        if (!this.entries.isEmpty()) {
            awaitingLoad.add(this);
        }
    }

    protected void m_6948_(Consumer<ItemStack> list, LootContext ctx) {
        ItemStack stack;
        Player player = AffixLootPoolEntry.getPlayer(ctx);
        if (player == null) {
            return;
        }
        if (this.resolvedEntries.isEmpty()) {
            stack = LootController.createRandomLootItem(ctx.m_78933_(), this.rarity, player, (ServerLevelAccessor)ctx.m_78952_());
        } else {
            AffixLootEntry entry = (AffixLootEntry)((WeightedEntry.Wrapper)WeightedRandom.m_146317_((Random)ctx.m_78933_(), this.resolvedEntries.stream().filter(a -> GameStagesCompat.hasStage(player, a.stages)).map(e -> e.wrap(ctx.m_78945_())).toList()).get()).m_146310_();
            stack = LootController.createLootItem(entry.getStack().m_41777_(), this.rarity == null ? LootRarity.random(ctx.m_78933_(), ctx.m_78945_(), entry) : this.rarity, ctx.m_78933_());
        }
        list.accept(stack);
    }

    public LootPoolEntryType m_6751_() {
        return TYPE;
    }

    private void resolve() {
        this.resolvedEntries = this.entries.stream().map(id -> this.printErrorOnNull((Object)((AffixLootEntry)AffixLootManager.INSTANCE.getValue((ResourceLocation)id)), (ResourceLocation)id)).filter((Predicate<AffixLootEntry>)Predicates.notNull()).toList();
    }

    private <T> T printErrorOnNull(T t, ResourceLocation id) {
        if (t == null) {
            AdventureModule.LOGGER.error("An AffixLootPoolEntry failed to resolve the Affix Entry {}!", (Object)id);
        }
        return t;
    }

    @Nullable
    public static Player getPlayer(LootContext ctx) {
        Object object = ctx.m_78953_(LootContextParams.f_81458_);
        if (object instanceof Player) {
            Player p = (Player)object;
            return p;
        }
        object = ctx.m_78953_(LootContextParams.f_81455_);
        if (object instanceof Player) {
            Player p = (Player)object;
            return p;
        }
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_().stream().findFirst().orElse(null);
        }
        return null;
    }

    static {
        AffixLootManager.registerCallback(() -> awaitingLoad.forEach(AffixLootPoolEntry::resolve));
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<AffixLootPoolEntry> {
        protected AffixLootPoolEntry deserialize(JsonObject obj, JsonDeserializationContext context, int weight, int quality, LootItemCondition[] lootConditions, LootItemFunction[] lootFunctions) {
            LootRarity rarity = LootRarity.byId(GsonHelper.m_13851_((JsonObject)obj, (String)"rarity", (String)""));
            List entries = (List)context.deserialize((JsonElement)GsonHelper.m_13832_((JsonObject)obj, (String)"entries", (JsonArray)new JsonArray()), new TypeToken<List<String>>(){}.getType());
            return new AffixLootPoolEntry(rarity, entries.stream().map(ResourceLocation::new).toList(), weight, quality, lootConditions, lootFunctions);
        }

        public void serializeCustom(JsonObject object, AffixLootPoolEntry e, JsonSerializationContext ctx) {
            if (e.rarity != null) {
                object.addProperty("rarity", e.rarity.id());
            }
            object.add("entries", ctx.serialize(e.entries));
            super.m_7219_(object, (LootPoolSingletonContainer)e, ctx);
        }
    }
}

