/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;

public class RetreatingAffix
extends Affix {
    protected LootRarity minRarity;

    public RetreatingAffix(LootRarity minRarity) {
        super(AffixType.EFFECT);
        this.minRarity = minRarity;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.SHIELD && rarity.isAtLeast(this.minRarity);
    }

    @Override
    public float onShieldBlock(ItemStack stack, LootRarity rarity, float level, LivingEntity entity, DamageSource source, float amount) {
        Entity tSource = source.m_7639_();
        if (tSource != null && tSource.m_20280_((Entity)entity) <= 9.0) {
            Vec3 look = entity.m_20154_();
            entity.m_20256_(new Vec3(1.0 * -look.f_82479_, 0.25, 1.0 * -look.f_82481_));
            entity.f_19864_ = true;
            entity.m_6853_(false);
        }
        return super.onShieldBlock(stack, rarity, level, entity, source, amount);
    }

    public static Affix read(JsonObject obj) {
        return new RetreatingAffix((LootRarity)GSON.fromJson(obj.get("min_rarity"), LootRarity.class));
    }

    public JsonObject write() {
        return new JsonObject();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.minRarity.id());
    }

    public static Affix read(FriendlyByteBuf buf) {
        return new RetreatingAffix(LootRarity.byId(buf.m_130277_()));
    }
}

