/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;

public class MagicalArrowAffix
extends Affix {
    protected LootRarity minRarity;

    public MagicalArrowAffix(LootRarity minRarity) {
        super(AffixType.EFFECT);
        this.minRarity = minRarity;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack).isRanged() && rarity.isAtLeast(this.minRarity);
    }

    public void onHurt(LivingHurtEvent e) {
        AbstractArrow arrow;
        CompoundTag nbt;
        Entity entity = e.getSource().m_7640_();
        if (entity instanceof AbstractArrow && (nbt = (arrow = (AbstractArrow)entity).getPersistentData().m_128469_("apoth.affixes")).m_128441_(this.getId().toString())) {
            e.getSource().m_19389_();
        }
    }

    public static Affix read(JsonObject obj) {
        return new MagicalArrowAffix((LootRarity)GSON.fromJson(obj.get("min_rarity"), LootRarity.class));
    }

    public JsonObject write() {
        return new JsonObject();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.minRarity.id());
    }

    public static Affix read(FriendlyByteBuf buf) {
        return new MagicalArrowAffix(LootRarity.byId(buf.m_130277_()));
    }
}

