/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixInstance;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class DamageReductionAffix
extends Affix {
    protected final DamageType type;
    protected final Map<LootRarity, StepFunction> values;
    protected final Set<EquipmentSlot> armorTypes;

    public DamageReductionAffix(DamageType type, Map<LootRarity, StepFunction> levelFuncs, Set<EquipmentSlot> armorTypes) {
        super(AffixType.EFFECT);
        this.type = type;
        this.values = levelFuncs;
        this.armorTypes = armorTypes;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.ARMOR && this.values.containsKey(rarity) && (this.armorTypes.isEmpty() || this.armorTypes.contains(((ArmorItem)stack.m_41720_()).m_40402_()));
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)new TranslatableComponent("affix.apotheosis:damage_reduction.desc", new Object[]{new TranslatableComponent("misc.apotheosis." + this.type.id), DamageReductionAffix.fmt(100.0f * this.getTrueLevel(rarity, level))}).m_130940_(ChatFormatting.YELLOW));
    }

    public static void onHurt(LivingHurtEvent e) {
        DamageSource src = e.getSource();
        if (src.m_19378_() || src.m_19379_()) {
            return;
        }
        LivingEntity ent = e.getEntityLiving();
        float amount = e.getAmount();
        for (ItemStack s : ent.m_6168_()) {
            Map<Affix, AffixInstance> affixes = AffixHelper.getAffixes(s);
            for (AffixInstance inst : affixes.values()) {
                Affix affix = inst.affix();
                if (!(affix instanceof DamageReductionAffix)) continue;
                DamageReductionAffix dmg = (DamageReductionAffix)affix;
                if (!dmg.type.test(src)) continue;
                amount *= 1.0f - dmg.getTrueLevel(inst.rarity(), inst.level());
            }
        }
        e.setAmount(amount);
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public static DamageReductionAffix read(JsonObject obj) {
        DamageType type = DamageType.valueOf(GsonHelper.m_13906_((JsonObject)obj, (String)"damage_type"));
        Map<LootRarity, StepFunction> values = AffixHelper.readValues(GsonHelper.m_13930_((JsonObject)obj, (String)"values"));
        Set armorTypes = (Set)GSON.fromJson((JsonElement)GsonHelper.m_13832_((JsonObject)obj, (String)"armor_types", (JsonArray)new JsonArray()), new TypeToken<Set<EquipmentSlot>>(){}.getType());
        return new DamageReductionAffix(type, values, armorTypes);
    }

    public JsonObject write() {
        return new JsonObject();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
        buf.m_178355_(this.values, (b, key) -> b.m_130070_(key.id()), (b, func) -> func.write(b));
        buf.writeByte(this.armorTypes.size());
        this.armorTypes.forEach(c -> buf.m_130068_((Enum)c));
    }

    public static DamageReductionAffix read(FriendlyByteBuf buf) {
        DamageType type = (DamageType)buf.m_130066_(DamageType.class);
        Map values = buf.m_178368_(b -> LootRarity.byId(b.m_130277_()), b -> StepFunction.read((FriendlyByteBuf)b));
        HashSet<EquipmentSlot> armorTypes = new HashSet<EquipmentSlot>();
        int size = buf.readByte();
        for (int i = 0; i < size; ++i) {
            armorTypes.add((EquipmentSlot)buf.m_130066_(EquipmentSlot.class));
        }
        return new DamageReductionAffix(type, values, armorTypes);
    }

    public static enum DamageType implements Predicate<DamageSource>
    {
        PHYSICAL("physical", d -> !d.m_19387_() && !d.m_19384_() && !d.m_19372_() && !d.m_146707_()),
        MAGIC("magic", DamageSource::m_19387_),
        FIRE("fire", DamageSource::m_19384_),
        FALL("fall", DamageSource::m_146707_),
        EXPLOSION("explosion", DamageSource::m_19372_);

        private final String id;
        private final Predicate<DamageSource> predicate;

        private DamageType(String id, Predicate<DamageSource> predicate) {
            this.id = id;
            this.predicate = predicate;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public boolean test(DamageSource t) {
            return this.predicate.test(t);
        }
    }
}

