/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.items.StakeItem;
import javax.annotation.Nonnull;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class StakeCondition
implements LootItemCondition {
    private final LootContext.EntityTarget target;

    public static LootItemCondition.Builder builder(LootContext.EntityTarget target) {
        return () -> new StakeCondition(target);
    }

    public StakeCondition(LootContext.EntityTarget targetIn) {
        this.target = targetIn;
    }

    @Nonnull
    public LootItemConditionType m_7940_() {
        return ModLoot.with_stake;
    }

    public boolean test(LootContext context) {
        Entity player = (Entity)context.m_78953_(this.target.m_79003_());
        if (player instanceof Player) {
            ItemStack active = ((Player)player).m_21205_();
            return !active.m_41619_() && active.m_41720_() instanceof StakeItem;
        }
        return false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<StakeCondition> {
        @Nonnull
        public StakeCondition deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
            return new StakeCondition((LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class));
        }

        public void serialize(JsonObject json, StakeCondition value, JsonSerializationContext context) {
            json.add("entity", context.serialize((Object)value.target));
        }
    }
}

