/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.items.RefinementItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class RefinementSetFunction
extends LootItemConditionalFunction {
    @Nullable
    public final IFaction<?> faction;

    public static LootItemConditionalFunction.Builder<?> builder(IFaction<?> faction) {
        return RefinementSetFunction.m_80683_(conditions -> new RefinementSetFunction((LootItemCondition[])conditions, faction));
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return RefinementSetFunction.m_80683_(conditions -> new RefinementSetFunction((LootItemCondition[])conditions, null));
    }

    public RefinementSetFunction(@Nonnull LootItemCondition[] conditionsIn, @Nullable IFaction<?> faction) {
        super(conditionsIn);
        this.faction = faction;
    }

    @Nonnull
    public LootItemFunctionType m_7162_() {
        return ModLoot.add_refinement_set;
    }

    @Nonnull
    protected ItemStack m_7372_(@Nonnull ItemStack stack, @Nonnull LootContext context) {
        IRefinementSet set;
        if (stack.m_41720_() instanceof IRefinementItem && (set = RefinementItem.getRandomRefinementForItem(this.faction, (IRefinementItem)stack.m_41720_())) != null) {
            ((IRefinementItem)stack.m_41720_()).applyRefinementSet(stack, set);
        }
        return stack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RefinementSetFunction> {
        @Nonnull
        public RefinementSetFunction deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context, @Nonnull LootItemCondition[] conditionsIn) {
            IFaction<?> faction = null;
            if (json.has("faction")) {
                String string = json.get("faction").getAsString();
                faction = VampirismAPI.factionRegistry().getFactionByID(new ResourceLocation(json.get("faction").getAsString()));
                if (faction == null) {
                    throw new IllegalStateException("Faction " + string + " does not exist");
                }
            }
            return new RefinementSetFunction(conditionsIn, faction);
        }

        public void serialize(@Nonnull JsonObject json, @Nonnull RefinementSetFunction function, @Nonnull JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)function, context);
            if (function.faction != null) {
                json.addProperty("faction", function.faction.getID().toString());
            }
        }
    }
}

