/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.core.ModLoot;
import javax.annotation.Nonnull;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class AdjustableLevelCondition
implements LootItemCondition {
    private final int levelTest;
    private final LootContext.EntityTarget target;

    public static LootItemCondition.Builder builder(int level, LootContext.EntityTarget target) {
        return () -> new AdjustableLevelCondition(level, target);
    }

    public AdjustableLevelCondition(int level, LootContext.EntityTarget targetIn) {
        this.levelTest = level;
        this.target = targetIn;
    }

    @Nonnull
    public LootItemConditionType m_7940_() {
        return ModLoot.adjustable_level;
    }

    public boolean test(LootContext lootContext) {
        Entity e = (Entity)lootContext.m_78953_(this.target.m_79003_());
        if (e instanceof IAdjustableLevel) {
            int l = ((IAdjustableLevel)e).getEntityLevel();
            if (this.levelTest != -1) {
                return this.levelTest == l;
            }
        }
        return false;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<AdjustableLevelCondition> {
        @Nonnull
        public AdjustableLevelCondition deserialize(JsonObject json, @Nonnull JsonDeserializationContext context) {
            return new AdjustableLevelCondition(json.has("level") ? GsonHelper.m_13927_((JsonObject)json, (String)"level") : -1, (LootContext.EntityTarget)GsonHelper.m_13836_((JsonObject)json, (String)"entity", (JsonDeserializationContext)context, LootContext.EntityTarget.class));
        }

        public void serialize(JsonObject json, AdjustableLevelCondition lootFunction, JsonSerializationContext context) {
            json.add("level", context.serialize((Object)lootFunction.levelTest));
            json.add("entity", context.serialize((Object)lootFunction.target));
        }
    }
}

