/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.core.ModLoot;
import de.teamlapen.vampirism.entity.hunter.AdvancedHunterEntity;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.util.VampireBookManager;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AddBookNbt
extends LootItemConditionalFunction {
    public static LootItemConditionalFunction.Builder<?> builder() {
        return AddBookNbt.m_80683_(AddBookNbt::new);
    }

    public AddBookNbt(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    public LootItemFunctionType m_7162_() {
        return ModLoot.add_book_nbt;
    }

    @Nonnull
    public ItemStack m_7372_(@Nonnull ItemStack itemStack, LootContext lootContext) {
        Entity victim = (Entity)lootContext.m_78953_(LootContextParams.f_81455_);
        Optional<Object> id = Optional.empty();
        if (victim instanceof AdvancedHunterEntity) {
            id = ((AdvancedHunterEntity)victim).getBookLootId();
        } else if (victim instanceof AdvancedVampireEntity) {
            id = ((AdvancedVampireEntity)victim).getBookLootId();
        }
        CompoundTag data = id.flatMap(str -> VampireBookManager.getInstance().getBookData((String)str)).orElseGet(() -> VampireBookManager.getInstance().getRandomBookData(lootContext.m_78933_()));
        itemStack.m_41751_(data);
        return itemStack;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<AddBookNbt> {
        @Nonnull
        public AddBookNbt deserialize(@Nonnull JsonObject jsonObject, @Nonnull JsonDeserializationContext jsonDeserializationContext, @Nonnull LootItemCondition[] iLootConditions) {
            return new AddBookNbt(iLootConditions);
        }
    }
}

