/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.biome;

import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.world.gen.VampirismFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class VampirismBiomes {
    public static Biome createVampireForest() {
        MobSpawnSettings.Builder mobSpawnBuilder = new MobSpawnSettings.Builder();
        mobSpawnBuilder.m_48368_(0.25f);
        mobSpawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ModEntities.vampire, 35, 1, 3));
        mobSpawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ModEntities.vampire_baron, ((Integer)VampirismConfig.COMMON.baronSpawnChance.get()).intValue(), 1, 1));
        mobSpawnBuilder.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(ModEntities.blinding_bat, 60, 2, 4));
        mobSpawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.dummy_creature, 80, 3, 6));
        BiomeSpecialEffects.Builder biomeSpecialEffectsBuilder = new BiomeSpecialEffects.Builder().m_48034_(0x7D0000).m_48037_(0x7D0000).m_48019_(8205621).m_48040_(8205621).m_48043_(0x1E1F1F).m_48045_(2892082).m_48027_(AmbientMoodSettings.f_47387_);
        return VampirismBiomes.prepareVampireForestBuilder(mobSpawnBuilder, biomeSpecialEffectsBuilder).m_47592_();
    }

    public static Biome.BiomeBuilder prepareVampireForestBuilder(MobSpawnSettings.Builder spawnBuilder, BiomeSpecialEffects.Builder ambienceBuilder) {
        BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder();
        VampirismBiomes.addDefaultCarversWithoutLakes(builder);
        VampirismBiomes.addModdedWaterLake(builder);
        VampirismBiomes.addVampireFlower(builder);
        builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)VampirismFeatures.forest_grass_placed.getHolder().orElseThrow());
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)builder);
        VampirismBiomes.addVampireTrees(builder);
        VampirismBiomes.addWaterSprings(builder);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.FOREST).m_47609_(0.3f).m_47611_(0.0f).m_47603_(ambienceBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(builder.m_47831_());
    }

    public static void addVampireFlower(BiomeGenerationSettings.Builder builder) {
        builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)VampirismFeatures.vampire_flower_placed.getHolder().orElseThrow());
    }

    public static void addWaterSprings(BiomeGenerationSettings.Builder builder) {
        builder.m_204201_(GenerationStep.Decoration.FLUID_SPRINGS, MiscOverworldPlacements.f_195276_);
    }

    public static void addModdedWaterLake(BiomeGenerationSettings.Builder builder) {
        builder.m_204201_(GenerationStep.Decoration.LAKES, (Holder)VampirismFeatures.water_lake_placed.getHolder().orElseThrow());
    }

    public static void addVampireTrees(BiomeGenerationSettings.Builder builder) {
        builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)VampirismFeatures.vampire_trees_placed.getHolder().orElseThrow());
    }

    public static void addDefaultCarversWithoutLakes(BiomeGenerationSettings.Builder builder) {
        builder.m_204198_(GenerationStep.Carving.AIR, Carvers.f_126848_);
        builder.m_204198_(GenerationStep.Carving.AIR, Carvers.f_194741_);
        builder.m_204198_(GenerationStep.Carving.AIR, Carvers.f_126849_);
    }

    public static void onBiomeLoadingEventAdditions(BiomeLoadingEvent event) {
        Biome.BiomeCategory cat;
        List monsterList = event.getSpawns().getSpawner(MobCategory.MONSTER);
        if (monsterList != null && monsterList.stream().anyMatch(spawners -> spawners.f_48404_ == EntityType.f_20501_)) {
            int advancedHunterChance;
            event.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ModEntities.vampire, ((Integer)VampirismConfig.COMMON.vampireSpawnChance.get()).intValue(), 1, 3));
            event.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ModEntities.advanced_vampire, ((Integer)VampirismConfig.COMMON.advancedVampireSpawnChance.get()).intValue(), 1, 1));
            int hunterChance = (Integer)VampirismConfig.COMMON.hunterSpawnChance.get();
            if (hunterChance > 0) {
                event.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ModEntities.hunter, hunterChance, 1, 3));
            }
            if ((advancedHunterChance = ((Integer)VampirismConfig.COMMON.advancedHunterSpawnChance.get()).intValue()) > 0) {
                event.getSpawns().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(ModEntities.advanced_hunter, advancedHunterChance, 1, 1));
            }
        }
        if ((cat = event.getCategory()) != Biome.BiomeCategory.NETHER && cat != Biome.BiomeCategory.THEEND && cat != Biome.BiomeCategory.OCEAN && cat != Biome.BiomeCategory.NONE) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, (Holder)VampirismFeatures.vampire_dungeon_placed.getHolder().orElseThrow());
        }
    }
}

