/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.biome;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.mixin.MultiNoiseBiomeSourcePresetAccessor;
import de.teamlapen.vampirism.modcompat.terrablender.TerraBlenderCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OverworldModifications {
    private static final Logger LOGGER = LogManager.getLogger();

    private static boolean intersects(Climate.ParameterPoint a, Climate.ParameterPoint b) {
        return OverworldModifications.intersects(a.f_186863_(), b.f_186863_()) && OverworldModifications.intersects(a.f_186864_(), b.f_186864_()) && OverworldModifications.intersects(a.f_186865_(), b.f_186865_()) && OverworldModifications.intersects(a.f_186866_(), b.f_186866_()) && OverworldModifications.intersects(a.f_186867_(), b.f_186867_()) && OverworldModifications.intersects(a.f_186868_(), b.f_186868_());
    }

    private static boolean intersects(Climate.Parameter a, Climate.Parameter b) {
        return a.f_186814_() > b.f_186813_() && a.f_186813_() < b.f_186814_() || a.f_186814_() == a.f_186813_() && b.f_186814_() == b.f_186813_() && a.f_186814_() == b.f_186814_();
    }

    public static void addBiomesToOverworldUnsafe() {
        if (TerraBlenderCompat.areBiomesAddedViaTerraBlender()) {
            LOGGER.info("Vampirism Biomes are added via TerraBlender. Not adding them to overworld preset.");
            return;
        }
        if (!((Boolean)VampirismConfig.COMMON.addVampireForestToOverworld.get()).booleanValue()) {
            return;
        }
        Function<Registry<Biome>, Climate.ParameterList<Holder<Biome>>> originalParameterSourceFunction = ((MultiNoiseBiomeSourcePresetAccessor)MultiNoiseBiomeSource.Preset.f_187087_).getPresetSupplier_vampirism();
        Function<Registry<Biome>, Climate.ParameterList<Holder<Biome>>> wrapperParameterSourceFunction = registry -> {
            Climate.ParameterList vanillaList = (Climate.ParameterList)originalParameterSourceFunction.apply((Registry<Biome>)registry);
            ArrayList<Pair> biomes = new ArrayList<Pair>(vanillaList.m_186850_());
            Object[] forestPoints = new Climate.ParameterPoint[]{Climate.m_186798_((Climate.Parameter)Climate.Parameter.m_186822_((float)-0.4f, (float)-0.19f), (Climate.Parameter)Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), (Climate.Parameter)Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f), (Climate.Parameter)Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)Climate.Parameter.m_186822_((float)-0.56666666f, (float)-0.05f), (float)0.0f), Climate.m_186798_((Climate.Parameter)Climate.Parameter.m_186822_((float)-0.4f, (float)-0.19f), (Climate.Parameter)Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), (Climate.Parameter)Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f), (Climate.Parameter)Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)Climate.Parameter.m_186822_((float)0.05f, (float)0.4f), (float)0.0f)};
            int oldCount = biomes.size();
            int removed = 0;
            Iterator it = biomes.iterator();
            while (it.hasNext()) {
                Pair pair = (Pair)it.next();
                removed += ((Holder)pair.getSecond()).m_203543_().map(arg_0 -> OverworldModifications.lambda$addBiomesToOverworldUnsafe$1((Climate.ParameterPoint[])forestPoints, pair, it, arg_0)).orElse(0).intValue();
            }
            LOGGER.debug("Removed a total of {} points from {}", (Object)removed, (Object)oldCount);
            LOGGER.info("Adding biome {} to ParameterPoints {} in Preset.OVERWORLD", (Object)ModBiomes.VAMPIRE_FOREST.m_135782_(), (Object)Arrays.toString(forestPoints));
            for (Object forestPoint : forestPoints) {
                biomes.add(Pair.of((Object)forestPoint, (Object)registry.m_206081_(ModBiomes.VAMPIRE_FOREST)));
            }
            return new Climate.ParameterList(biomes);
        };
        ((MultiNoiseBiomeSourcePresetAccessor)MultiNoiseBiomeSource.Preset.f_187087_).setPresetSupplier_vampirism(wrapperParameterSourceFunction);
    }

    public static SurfaceRules.RuleSource buildOverworldSurfaceRules() {
        CustomBlockRuleSource cursed_earth = new CustomBlockRuleSource(new ResourceLocation("vampirism", "cursed_earth"));
        CustomBlockRuleSource grass = new CustomBlockRuleSource(new ResourceLocation("vampirism", "cursed_grass_block"));
        SurfaceRules.ConditionSource inVampireBiome = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{ModBiomes.VAMPIRE_FOREST});
        SurfaceRules.RuleSource vampireForestTopLayer = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)inVampireBiome, (SurfaceRules.RuleSource)grass);
        SurfaceRules.RuleSource vampireForestBaseLayer = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)inVampireBiome, (SurfaceRules.RuleSource)cursed_earth);
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{vampireForestTopLayer}))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{vampireForestBaseLayer})))}))});
    }

    private static /* synthetic */ Integer lambda$addBiomesToOverworldUnsafe$1(Climate.ParameterPoint[] forestPoints, Pair pair, Iterator it, ResourceKey biomeId) {
        if ("minecraft".equals(biomeId.m_135782_().m_135827_()) && Arrays.stream(forestPoints).anyMatch(p -> OverworldModifications.intersects(p, (Climate.ParameterPoint)pair.getFirst()))) {
            it.remove();
            LOGGER.debug("Removing biome {} from parameter point {} in overworld preset", (Object)biomeId, pair.getFirst());
            return 1;
        }
        return 0;
    }

    record CustomBlockRuleSource(ResourceLocation block_id) implements SurfaceRules.RuleSource
    {
        static final Codec<CustomBlockRuleSource> CODEC = ResourceLocation.f_135803_.xmap(CustomBlockRuleSource::new, CustomBlockRuleSource::block_id).fieldOf("block_id").codec();

        public SurfaceRules.SurfaceRule apply(SurfaceRules.Context p_189523_) {
            return (p_189774_, p_189775_, p_189776_) -> ((Block)Registry.f_122824_.m_7745_(this.block_id)).m_49966_();
        }

        public Codec<? extends SurfaceRules.RuleSource> m_183290_() {
            return CODEC;
        }

        static {
            Registry.m_122965_((Registry)Registry.f_194574_, (ResourceLocation)new ResourceLocation("vampirism", "block_id"), CODEC);
        }
    }
}

