/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.common.io.ByteStreams;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModItems;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampireBookManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final VampireBookManager ourInstance = new VampireBookManager();
    private final Map<String, CompoundTag> booksById = new HashMap<String, CompoundTag>();
    private CompoundTag[] bookTags = null;

    public static VampireBookManager getInstance() {
        return ourInstance;
    }

    private VampireBookManager() {
    }

    public Optional<CompoundTag> getBookData(String id) {
        CompoundTag nbt = this.booksById.get(id);
        return Optional.ofNullable(nbt);
    }

    public ItemStack getRandomBook(Random rnd) {
        ItemStack book = new ItemStack((ItemLike)ModItems.vampire_book, 1);
        book.m_41751_(this.getRandomBookData(rnd));
        return book;
    }

    @Nonnull
    public CompoundTag getRandomBookData(Random rnd) {
        return this.bookTags == null || this.bookTags.length == 0 ? new CompoundTag() : this.bookTags[rnd.nextInt(this.bookTags.length)];
    }

    public void init() {
        InputStream inputStream = null;
        try {
            inputStream = VampirismMod.class.getResourceAsStream("/vampireBooks.txt");
            if (inputStream == null) {
                throw new IOException("Could not find 'vampireBooks.txt' in resources");
            }
            String data = new String(ByteStreams.toByteArray((InputStream)inputStream));
            this.parseBooks(data);
        }
        catch (CommandSyntaxException e) {
            LOGGER.warn("----------------------------------------");
            LOGGER.error("Failed to convert vampire books to NBT", (Throwable)e);
            LOGGER.warn("----------------------------------------");
        }
        catch (IOException e) {
            LOGGER.error("Failed to read vampire books from resources", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to close InputStream", (Throwable)e);
                }
            }
        }
    }

    private void parseBooks(String data) throws CommandSyntaxException {
        String[] lines;
        ArrayList<CompoundTag> books = new ArrayList<CompoundTag>();
        for (String line : lines = data.split("\n")) {
            int pos;
            String id = null;
            if (line.startsWith("id") && (pos = line.indexOf(58)) != -1) {
                id = line.substring(2, pos);
                line = line.substring(pos + 1);
            }
            CompoundTag nbt = TagParser.m_129359_((String)line);
            books.add(nbt);
            if (id == null) continue;
            this.booksById.put(id, nbt);
        }
        this.bookTags = books.toArray(new CompoundTag[0]);
    }
}

