/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire.actions;

import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public class RageVampireAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    @Override
    public boolean activate(IVampirePlayer vampire) {
        int duration = this.getDuration(vampire);
        this.addEffectInstance(vampire, new MobEffectInstance(MobEffects.f_19596_, duration, 2, false, false));
        this.addEffectInstance(vampire, new MobEffectInstance(MobEffects.f_19600_, duration, 0, false, false));
        this.addEffectInstance(vampire, new MobEffectInstance(MobEffects.f_19598_, duration, 0, false, false));
        return true;
    }

    @Override
    public boolean canBeUsedBy(IVampirePlayer vampire) {
        return !vampire.getActionHandler().isActionActive(VampireActions.bat);
    }

    @Override
    public int getCooldown(IVampirePlayer player) {
        return (Integer)VampirismConfig.BALANCE.vaRageCooldown.get() * 20;
    }

    @Override
    public int getDuration(IVampirePlayer player) {
        return 20 * ((Integer)VampirismConfig.BALANCE.vaRageMinDuration.get() + (Integer)VampirismConfig.BALANCE.vaRageDurationIncrease.get() * player.getLevel());
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaRageEnabled.get();
    }

    @Override
    public void onActivatedClient(IVampirePlayer vampire) {
    }

    @Override
    public void onDeactivated(IVampirePlayer vampire) {
        this.removePotionEffect(vampire, MobEffects.f_19596_);
        this.removePotionEffect(vampire, MobEffects.f_19600_);
        this.removePotionEffect(vampire, MobEffects.f_19598_);
    }

    @Override
    public void onReActivated(IVampirePlayer vampire) {
    }

    @Override
    public boolean onUpdate(IVampirePlayer vampire) {
        return false;
    }
}

