/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire.actions;

import de.teamlapen.vampirism.advancements.VampireActionTrigger;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class BatVampireAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    public static final float BAT_EYE_HEIGHT = 0.51000005f;
    public static final EntityDimensions BAT_SIZE = EntityDimensions.m_20398_((float)0.8f, (float)0.6f);
    private static final float PLAYER_WIDTH = 0.6f;
    private static final float PLAYER_HEIGHT = 1.8f;
    private final UUID armorModifierUUID = UUID.fromString("4392fccb-4bfd-4290-b2e6-5cc91439053c");
    private final UUID armorToughnessModifierUUID = UUID.fromString("6d3df16d-85e4-4b99-b2fc-301818697a6d");

    @Override
    public boolean activate(IVampirePlayer vampire) {
        Player player = vampire.getRepresentingPlayer();
        this.setModifier(player, true);
        this.updatePlayer((VampirePlayer)vampire, true);
        if (player instanceof ServerPlayer) {
            ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayer)player, VampireActionTrigger.Action.BAT);
        }
        return true;
    }

    @Override
    public boolean canBeUsedBy(IVampirePlayer vampire) {
        return !vampire.isGettingSundamage((LevelAccessor)vampire.getRepresentingEntity().f_19853_) && !((Object)((Object)ModItems.umbrella)).equals(vampire.getRepresentingEntity().m_21205_().m_41720_()) && vampire.isGettingGarlicDamage((LevelAccessor)vampire.getRepresentingEntity().f_19853_) == EnumStrength.NONE && !vampire.getActionHandler().isActionActive(VampireActions.vampire_rage) && !vampire.getRepresentingPlayer().m_20069_() && ((Boolean)VampirismConfig.SERVER.batModeInEnd.get() != false || vampire.getRepresentingPlayer().m_20193_().m_46472_() != Level.f_46430_) && vampire.getRepresentingEntity().m_20202_() == null;
    }

    @Override
    public int getCooldown(IVampirePlayer player) {
        return (Integer)VampirismConfig.BALANCE.vaBatCooldown.get() * 20 + 1;
    }

    @Override
    public int getDuration(IVampirePlayer player) {
        return Mth.m_14045_((int)((Integer)VampirismConfig.BALANCE.vaBatDuration.get()), (int)10, (int)0x6666665) * 20;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaBatEnabled.get();
    }

    @Override
    public void onActivatedClient(IVampirePlayer vampire) {
        if (!((VampirePlayer)vampire).getSpecialAttributes().bat) {
            this.updatePlayer((VampirePlayer)vampire, true);
        }
    }

    @Override
    public void onDeactivated(IVampirePlayer vampire) {
        Player player = vampire.getRepresentingPlayer();
        this.setModifier(player, false);
        if (!player.m_20096_()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 20, 100, false, false));
        }
        this.updatePlayer((VampirePlayer)vampire, false);
    }

    @Override
    public void onReActivated(IVampirePlayer vampire) {
        this.setModifier(vampire.getRepresentingPlayer(), true);
        if (!((VampirePlayer)vampire).getSpecialAttributes().bat) {
            this.updatePlayer((VampirePlayer)vampire, true);
        }
    }

    @Override
    public boolean onUpdate(IVampirePlayer vampire) {
        if (vampire.isGettingSundamage((LevelAccessor)vampire.getRepresentingEntity().f_19853_) && !vampire.isRemote()) {
            vampire.getRepresentingPlayer().m_6352_((Component)new TranslatableComponent("text.vampirism.cant_fly_day"), Util.f_137441_);
            return true;
        }
        if (((Object)((Object)ModItems.umbrella)).equals(vampire.getRepresentingEntity().m_21205_().m_41720_()) && !vampire.isRemote()) {
            vampire.getRepresentingPlayer().m_6352_((Component)new TranslatableComponent("text.vampirism.cant_fly_umbrella"), Util.f_137441_);
            return true;
        }
        if (vampire.isGettingGarlicDamage((LevelAccessor)vampire.getRepresentingEntity().f_19853_) != EnumStrength.NONE && !vampire.isRemote()) {
            vampire.getRepresentingEntity().m_6352_((Component)new TranslatableComponent("text.vampirism.cant_fly_garlic"), Util.f_137441_);
            return true;
        }
        if (!((Boolean)VampirismConfig.SERVER.batModeInEnd.get()).booleanValue() && vampire.getRepresentingPlayer().m_20193_().m_46472_() == Level.f_46430_) {
            vampire.getRepresentingPlayer().m_6352_((Component)new TranslatableComponent("text.vampirism.cant_fly_end"), Util.f_137441_);
            return true;
        }
        float exhaustion = ((Double)VampirismConfig.BALANCE.vaBatExhaustion.get()).floatValue();
        if (exhaustion > 0.0f) {
            vampire.addExhaustion(exhaustion);
        }
        return vampire.getRepresentingPlayer().m_20069_();
    }

    private void setFlightSpeed(Player player, float speed) {
        player.m_150110_().f_35939_ = speed;
    }

    private void setModifier(Player player, boolean enabled) {
        if (enabled) {
            AttributeInstance armorToughnessAttributeInst;
            AttributeInstance armorAttributeInst = player.m_21051_(Attributes.f_22284_);
            if (armorAttributeInst.m_22111_(this.armorModifierUUID) == null) {
                armorAttributeInst.m_22125_(new AttributeModifier(this.armorModifierUUID, "Bat Armor Disabled", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if ((armorToughnessAttributeInst = player.m_21051_(Attributes.f_22285_)).m_22111_(this.armorToughnessModifierUUID) == null) {
                armorToughnessAttributeInst.m_22125_(new AttributeModifier(this.armorToughnessModifierUUID, "Bat Armor Disabled", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            player.m_150110_().f_35936_ = true;
            player.m_150110_().f_35935_ = true;
            this.setFlightSpeed(player, ((Double)VampirismConfig.BALANCE.vaBatFlightSpeed.get()).floatValue());
        } else {
            AttributeInstance armorToughnessAttributeInst;
            AttributeModifier m2;
            AttributeInstance armorAttributeInst = player.m_21051_(Attributes.f_22284_);
            AttributeModifier m = armorAttributeInst.m_22111_(this.armorModifierUUID);
            if (m != null) {
                armorAttributeInst.m_22130_(m);
            }
            if ((m2 = (armorToughnessAttributeInst = player.m_21051_(Attributes.f_22285_)).m_22111_(this.armorToughnessModifierUUID)) != null) {
                armorToughnessAttributeInst.m_22130_(m2);
            }
            if (!player.m_150110_().f_35937_) {
                player.m_150110_().f_35936_ = false;
            }
            player.m_150110_().f_35935_ = false;
            this.setFlightSpeed(player, 0.05f);
        }
        player.m_6885_();
    }

    private void updatePlayer(VampirePlayer vampire, boolean bat) {
        Player player = vampire.getRepresentingPlayer();
        vampire.getSpecialAttributes().bat = bat;
        player.setForcedPose((Pose)(bat ? Pose.STANDING : null));
        player.m_6210_();
        if (bat) {
            player.m_6034_(player.m_20185_(), player.m_20186_() + (double)(1.8f - BatVampireAction.BAT_SIZE.f_20378_), player.m_20189_());
        }
    }
}

