/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.advancements.VampireActionTrigger;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IBloodStats;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampireVision;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.effects.VampireNightVisionEffectInstance;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.items.VampirismHunterArmor;
import de.teamlapen.vampirism.mixin.ArmorItemAccessor;
import de.teamlapen.vampirism.modcompat.PlayerReviveHelper;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.particle.FlyingBloodEntityParticleData;
import de.teamlapen.vampirism.player.FactionBasePlayer;
import de.teamlapen.vampirism.player.IVampirismPlayer;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.player.actions.ActionHandler;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.player.vampire.BloodStats;
import de.teamlapen.vampirism.player.vampire.VampirePlayerSpecialAttributes;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.util.DBNODamageSource;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampirePlayer
extends FactionBasePlayer<IVampirePlayer>
implements IVampirePlayer {
    public static final UUID NATURAL_ARMOR_UUID = UUID.fromString("17dcf6d2-30ac-4730-b16a-528353d0abe5");
    private static final Logger LOGGER = LogManager.getLogger(VampirePlayer.class);
    private static final int FEED_TIMER = 20;
    private static final String KEY_EYE = "eye_type";
    private static final String KEY_FANGS = "fang_type";
    private static final String KEY_GLOWING_EYES = "glowing_eyes";
    private static final String KEY_SPAWN_BITE_PARTICLE = "bite_particle";
    private static final String KEY_VISION = "vision";
    private static final String KEY_FEED_VICTIM_ID = "feed_victim";
    private static final String KEY_WING_COUNTER = "wing";
    private static final String KEY_DBNO_TIMER = "dbno";
    private static final String KEY_DBNO_MSG = "dbno_msg";
    private static final String KEY_WAS_DBNO = "wasDBNO";
    public static final Capability<IVampirePlayer> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IVampirePlayer>(){});
    private final BloodStats bloodStats;
    private final ActionHandler<IVampirePlayer> actionHandler;
    private final SkillHandler<IVampirePlayer> skillHandler;
    private final List<IVampireVision> unlockedVisions = new ArrayList<IVampireVision>();
    private boolean sundamage_cache = false;
    private EnumStrength garlic_cache = EnumStrength.NONE;
    private int ticksInSun = 0;
    private boolean wasDead = false;
    private IVampireVision activatedVision = null;
    private int wing_counter = 0;
    private int feed_victim = -1;
    private IVampirePlayer.BITE_TYPE feed_victim_bite_type;
    private int feedBiteTickCounter = 0;
    private boolean forceNaturalArmorUpdate;
    private int dbnoTimer = -1;
    private boolean wasDBNO = false;
    @Nullable
    private Component dbnoMessage;

    @Deprecated
    public static VampirePlayer get(@Nonnull Player player) {
        return (VampirePlayer)player.getCapability(CAP).orElseThrow(() -> new IllegalStateException("Cannot get Vampire player capability from player " + player));
    }

    public static LazyOptional<VampirePlayer> getOpt(@Nonnull Player player) {
        LazyOptional opt = player.getCapability(CAP).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Vampire player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public static ICapabilityProvider createNewCapability(final Player player) {
        return new ICapabilitySerializable<CompoundTag>(){
            final VampirePlayer inst;
            final LazyOptional<IVampirePlayer> opt;
            {
                this.inst = new VampirePlayer(player);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.inst.loadData(nbt);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                this.inst.saveData(tag);
                return tag;
            }
        };
    }

    public static double getNaturalArmorValue(int lvl) {
        return lvl > 0 ? (double)((Integer)VampirismConfig.BALANCE.vpNaturalArmorBaseValue.get()).intValue() + (double)lvl / 14.0 * (double)((Integer)VampirismConfig.BALANCE.vpNaturalArmorIncrease.get()).intValue() : 0.0;
    }

    public static double getNaturalArmorToughnessValue(int lvl) {
        return (double)lvl / 14.0 * (double)((Integer)VampirismConfig.BALANCE.vpNaturalArmorToughnessIncrease.get()).intValue();
    }

    public VampirePlayer(Player player) {
        super(player);
        this.bloodStats = new BloodStats(player);
        this.actionHandler = new ActionHandler<VampirePlayer>(this);
        this.skillHandler = new SkillHandler<IVampirePlayer>(this, VReference.VAMPIRE_FACTION);
    }

    @Override
    public void activateVision(@Nullable IVampireVision vision) {
        if (vision != null && !this.isRemote() && VampirismAPI.vampireVisionRegistry().getIdOfVision(vision) == -1) {
            throw new IllegalArgumentException("You have to register the vision first: " + vision);
        }
        if (!Objects.equals(this.activatedVision, vision)) {
            if (this.activatedVision != null) {
                this.activatedVision.onDeactivated(this);
            }
            this.activatedVision = vision;
            if (vision != null) {
                vision.onActivated(this);
            }
            if (!this.isRemote() && this.player.isAddedToWorld()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_(KEY_VISION, this.activatedVision == null ? -1 : VampirismAPI.vampireVisionRegistry().getIdOfVision(this.activatedVision));
                this.sync(nbt, false);
            }
        }
    }

    @Override
    public void addExhaustion(float exhaustion) {
        if (!this.player.m_150110_().f_35934_ && this.getLevel() > 0 && !this.isRemote()) {
            this.bloodStats.addExhaustion(exhaustion);
        }
    }

    public void biteBlock(BlockPos pos) {
        if (this.player.m_5833_()) {
            LOGGER.warn("Player can't bite in spectator mode");
            return;
        }
        double dist = this.player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() + 1.0;
        if (this.player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) > dist * dist) {
            LOGGER.warn("Block sent by client is not in reach" + pos);
        } else {
            this.biteBlock(pos, this.player.f_19853_.m_8055_(pos), this.player.f_19853_.m_7702_(pos));
        }
    }

    public void biteEntity(int entityId) {
        block9: {
            block10: {
                if (this.getLevel() == 0) {
                    LOGGER.warn("Player can't bite. Isn't a vampire");
                    return;
                }
                Entity e = this.player.m_20193_().m_6815_(entityId);
                if (this.player.m_5833_()) {
                    LOGGER.warn("Player can't bite in spectator mode");
                    return;
                }
                if (this.getActionHandler().isActionActive(VampireActions.bat)) {
                    LOGGER.warn("Cannot bite in bat mode");
                    return;
                }
                if (!(e instanceof LivingEntity)) break block9;
                if (!((double)e.m_20270_((Entity)this.player) <= this.player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() + 1.0)) break block10;
                this.feed_victim_bite_type = this.determineBiteType((LivingEntity)e);
                switch (this.feed_victim_bite_type) {
                    case HUNTER_CREATURE: {
                        this.player.m_7292_(new MobEffectInstance(ModEffects.poison, 60));
                        if (this.player instanceof ServerPlayer) {
                            ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayer)this.player, VampireActionTrigger.Action.POISONOUS_BITE);
                            break;
                        }
                        break block9;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        if (this.feed_victim == -1) {
                            this.feedBiteTickCounter = 0;
                        }
                        this.feed_victim = e.m_142049_();
                        ((LivingEntity)e).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 7, false, false));
                        this.player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 25, 4, false, false));
                        CompoundTag nbt = new CompoundTag();
                        nbt.m_128405_(KEY_FEED_VICTIM_ID, this.feed_victim);
                        this.sync(nbt, true);
                        break;
                    }
                }
                break block9;
            }
            LOGGER.warn("Entity sent by client is not in reach " + entityId);
        }
    }

    @Override
    public float calculateFireDamage(float amount) {
        float protectionMod = 1.0f;
        MobEffectInstance protection = this.player.m_21124_(ModEffects.fire_protection);
        if (protection != null) {
            int amplifier = protection.m_19564_();
            protectionMod = amplifier >= 5 ? 0.0f : 1.0f / (2.0f + (float)amplifier);
        }
        return amount * protectionMod * (float)LevelAttributeModifier.calculateModifierValue(this.getLevel(), this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpFireVulnerabilityMod.get(), 0.5);
    }

    @Override
    public boolean canBeBitten(IVampire biter) {
        return !this.player.m_5833_() && !this.player.m_7500_();
    }

    @Override
    public boolean canLeaveFaction() {
        return true;
    }

    @Override
    @Nonnull
    public IVampirePlayer.BITE_TYPE determineBiteType(LivingEntity entity) {
        if (this.player instanceof ServerPlayer && !((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.player), Permissions.FEED, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue()) {
            return IVampirePlayer.BITE_TYPE.NONE;
        }
        if (entity instanceof IBiteableEntity && ((IBiteableEntity)entity).canBeBitten(this)) {
            return IVampirePlayer.BITE_TYPE.SUCK_BLOOD;
        }
        if (entity instanceof PathfinderMob && entity.m_6084_()) {
            LazyOptional<IExtendedCreatureVampirism> opt = ExtendedCreature.getSafe((Entity)entity);
            if (opt.map(creature -> creature.canBeBitten(this)).orElse(false).booleanValue()) {
                if (opt.map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse(false).booleanValue()) {
                    return IVampirePlayer.BITE_TYPE.HUNTER_CREATURE;
                }
                return IVampirePlayer.BITE_TYPE.SUCK_BLOOD_CREATURE;
            }
        } else if (entity instanceof Player) {
            if (((Player)entity).m_150110_().f_35937_ || !Permissions.isPvpEnabled(this.player)) {
                return IVampirePlayer.BITE_TYPE.NONE;
            }
            if (!UtilLib.canReallySee(entity, (LivingEntity)this.player, false) && VampirePlayer.getOpt((Player)entity).map(v -> v.canBeBitten(this)).orElse(false).booleanValue() && (!(this.player instanceof ServerPlayer) || ((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.player), Permissions.FEED_PLAYER, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue())) {
                if (!(entity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof VampirismHunterArmor)) {
                    return IVampirePlayer.BITE_TYPE.SUCK_BLOOD_PLAYER;
                }
            } else {
                return IVampirePlayer.BITE_TYPE.NONE;
            }
        }
        return IVampirePlayer.BITE_TYPE.NONE;
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        int left = this.bloodStats.addBlood(amt, saturationMod);
        if (useRemaining && left > 0) {
            this.handleSpareBlood(left);
        }
    }

    public void endFeeding(boolean sync) {
        if (this.feed_victim != -1 || this.feed_victim_bite_type != null) {
            this.feed_victim = -1;
            this.feed_victim_bite_type = null;
            if (this.player.m_21023_(MobEffects.f_19597_)) {
                this.player.m_21195_(MobEffects.f_19597_);
            }
        }
        if (sync) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_(KEY_FEED_VICTIM_ID, this.feed_victim);
            this.sync(nbt, true);
        }
    }

    @Override
    @Nonnull
    public IActionHandler<IVampirePlayer> getActionHandler() {
        return this.actionHandler;
    }

    @Override
    @Nullable
    public IVampireVision getActiveVision() {
        return this.activatedVision;
    }

    @Override
    public int getBloodLevel() {
        return this.bloodStats.getBloodLevel();
    }

    @Override
    public float getBloodLevelRelative() {
        if (this.getLevel() == 0) {
            return (float)this.player.m_36324_().m_38702_() / 20.0f;
        }
        return (float)this.bloodStats.getBloodLevel() / (float)this.bloodStats.getMaxBlood();
    }

    @Override
    public float getBloodSaturation() {
        return ((Double)VampirismConfig.BALANCE.vpPlayerBloodSaturation.get()).floatValue();
    }

    @Override
    @Nonnull
    public IBloodStats getBloodStats() {
        return this.bloodStats;
    }

    @Override
    public ResourceLocation getCapKey() {
        return REFERENCE.VAMPIRE_PLAYER_KEY;
    }

    public int getDbnoDuration() {
        int duration = (Integer)VampirismConfig.BALANCE.vpDbnoDuration.get() * 20;
        if (this.skillHandler.isSkillEnabled(VampireSkills.dbno_duration)) {
            duration = Math.max(1, (int)((double)duration * (Double)VampirismConfig.BALANCE.vsDbnoReduction.get()));
        }
        return duration;
    }

    public int getDbnoTimer() {
        return this.dbnoTimer;
    }

    @Override
    @Nullable
    public IFaction<?> getDisguisedAs() {
        return this.isDisguised() ? this.getSpecialAttributes().disguisedAs : this.getFaction();
    }

    public int getEyeType() {
        return this.getSpecialAttributes().eyeType;
    }

    public int getFangType() {
        return this.getSpecialAttributes().fangType;
    }

    public float getFeedProgress() {
        return (float)this.feedBiteTickCounter / 20.0f;
    }

    public boolean getGlowingEyes() {
        return this.getSpecialAttributes().glowingEyes;
    }

    public void setGlowingEyes(boolean value) {
        if (value != this.getSpecialAttributes().glowingEyes) {
            this.getSpecialAttributes().glowingEyes = value;
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128379_(KEY_GLOWING_EYES, value);
                this.sync(nbt, true);
            }
        }
    }

    @Override
    public int getLevel() {
        return ((IVampirismPlayer)this.player).getVampAtts().vampireLevel;
    }

    @Override
    public int getMaxLevel() {
        return 14;
    }

    @Override
    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate(this.getFaction(), ignoreDisguise);
    }

    @Override
    @Nonnull
    public ISkillHandler<IVampirePlayer> getSkillHandler() {
        return this.skillHandler;
    }

    @Nonnull
    public VampirePlayerSpecialAttributes getSpecialAttributes() {
        return ((IVampirismPlayer)this.player).getVampAtts().getVampSpecial();
    }

    @Override
    public int getTicksInSun() {
        return this.ticksInSun;
    }

    public int getWingCounter() {
        return this.wing_counter;
    }

    @Override
    public boolean isAdvancedBiter() {
        return this.getSpecialAttributes().advanced_biter;
    }

    @Override
    public boolean isAutoFillEnabled() {
        return false;
    }

    @Override
    public boolean isDBNO() {
        return this.dbnoTimer >= 0;
    }

    @Override
    public boolean isDisguised() {
        return this.getSpecialAttributes().disguised;
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forcerefresh) {
        if (forcerefresh) {
            this.garlic_cache = Helper.getGarlicStrength((Entity)this.player, iWorld);
        }
        return this.garlic_cache;
    }

    @Override
    public boolean isGettingSundamage(LevelAccessor iWorld, boolean forcerefresh) {
        if (forcerefresh) {
            this.sundamage_cache = Helper.gettingSundamge((LivingEntity)this.player, iWorld, this.player.f_19853_.m_46473_()) && !((Object)((Object)ModItems.umbrella)).equals(this.player.m_21205_().m_41720_());
        }
        return this.sundamage_cache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return false;
    }

    @Override
    public void loadData(CompoundTag nbt) {
        super.loadData(nbt);
        this.bloodStats.readNBT(nbt);
        VampirePlayerSpecialAttributes a = this.getSpecialAttributes();
        a.eyeType = nbt.m_128451_(KEY_EYE);
        a.fangType = nbt.m_128451_(KEY_FANGS);
        a.glowingEyes = nbt.m_128471_(KEY_GLOWING_EYES);
        this.actionHandler.loadFromNbt(nbt);
        this.skillHandler.loadFromNbt(nbt);
        if (nbt.m_128471_(KEY_WAS_DBNO)) {
            this.wasDBNO = true;
        }
        IVampireVision vision = null;
        if (nbt.m_128441_(KEY_VISION)) {
            vision = VampirismAPI.vampireVisionRegistry().getVisionOfId(nbt.m_128451_(KEY_VISION));
        }
        this.activatedVision = vision;
    }

    @Override
    public int onBite(IVampire biter) {
        float perc;
        float f = perc = biter instanceof IVampirePlayer ? 0.2f : 0.08f;
        if (this.getLevel() == 0) {
            int amt = this.player.m_36324_().m_38702_();
            int sucked = (int)Math.ceil((float)amt * perc);
            this.player.m_36324_().m_38705_(amt - sucked);
            this.player.m_36399_(1000.0f);
            if (!this.player.m_21023_(ModEffects.sanguinare) && Helper.canTurnPlayer(biter, this.player) && Helper.canBecomeVampire(this.player) && !this.player.m_7500_()) {
                SanguinareEffect.addRandom((LivingEntity)this.player, true);
            }
            return sucked;
        }
        int amt = this.getBloodStats().getBloodLevel();
        int sucked = (int)Math.ceil((float)amt * perc);
        this.bloodStats.removeBlood(sucked, true);
        this.sync(this.bloodStats.writeUpdate(new CompoundTag()), true);
        return sucked;
    }

    @Override
    public void onChangedDimension(ResourceKey<Level> from, ResourceKey<Level> to) {
    }

    @Override
    public boolean onDeadlyHit(DamageSource source) {
        if (this.getLevel() > 0 && !this.player.m_21023_(ModEffects.neonatal) && !Helper.canKillVampires(source)) {
            int timePreviouslySpentInPlayerRevive = PlayerReviveHelper.getPreviousDownTime(this.player);
            int dbnoTime = Math.max(1, this.getDbnoDuration() - timePreviouslySpentInPlayerRevive);
            this.setDBNOTimer(dbnoTime);
            this.player.m_21153_(0.5f);
            this.player.setForcedPose(Pose.SLEEPING);
            this.resetNearbyTargetingMobs();
            boolean flag = this.player.f_19853_.m_46469_().m_46207_(GameRules.f_46142_);
            if (flag) {
                this.dbnoMessage = this.player.m_21231_().m_19293_();
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_(KEY_DBNO_TIMER, this.dbnoTimer);
            if (this.dbnoMessage != null) {
                nbt.m_128359_(KEY_DBNO_MSG, Component.Serializer.m_130703_((Component)this.dbnoMessage));
            }
            HelperLib.sync(this, nbt, (Entity)this.player, true);
            return true;
        }
        return false;
    }

    @Override
    public void onDeath(DamageSource src) {
        super.onDeath(src);
        if (this.actionHandler.isActionActive(VampireActions.bat) && src.m_7640_() instanceof Projectile && this.player instanceof ServerPlayer) {
            ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayer)this.player, VampireActionTrigger.Action.SNIPED_IN_BAT);
        }
        this.actionHandler.deactivateAllActions();
        this.wasDead = true;
        this.setDBNOTimer(-1);
        this.dbnoMessage = null;
    }

    @Override
    public boolean onEntityAttacked(DamageSource src, float amt) {
        if (this.getLevel() > 0) {
            if (this.isDBNO() && !Helper.canKillVampires(src)) {
                if (src.m_7639_() != null && src.m_7639_() instanceof Mob && ((Mob)src.m_7639_()).m_5448_() == this.player) {
                    ((Mob)src.m_7639_()).m_6710_(null);
                }
                return true;
            }
            if (DamageSource.f_19307_.equals(src)) {
                this.player.m_6469_(VReference.VAMPIRE_ON_FIRE, this.calculateFireDamage(amt));
                return true;
            }
            if (DamageSource.f_19305_.equals(src) || DamageSource.f_19308_.equals(src)) {
                this.player.m_6469_(VReference.VAMPIRE_IN_FIRE, this.calculateFireDamage(amt));
                return true;
            }
        }
        this.endFeeding(true);
        if (this.getSpecialAttributes().half_invulnerable) {
            double d = amt;
            double d2 = this.getRepresentingEntity().m_21233_();
            double d3 = this.skillHandler.isRefinementEquipped(ModRefinements.half_invulnerable) ? (Double)VampirismConfig.BALANCE.vrHalfInvulnerableThresholdMod.get() : 1.0;
            if (d >= d2 * d3 * (Double)VampirismConfig.BALANCE.vaHalfInvulnerableThreshold.get() && amt < 999.0f) {
                if (this.useBlood((Integer)VampirismConfig.BALANCE.vaHalfInvulnerableBloodCost.get(), false)) {
                    return true;
                }
                this.actionHandler.toggleAction(VampireActions.half_invulnerable);
            }
        }
        return false;
    }

    @Override
    public void onEntityKilled(LivingEntity victim, DamageSource src) {
        if (this.getSkillHandler().isRefinementEquipped(ModRefinements.rage_fury)) {
            int bonus = (Integer)VampirismConfig.BALANCE.vrRageFuryDurationBonus.get() * 20;
            if (victim instanceof Player) {
                bonus *= 2;
            }
            this.getActionHandler().extendActionTimer(VampireActions.vampire_rage, bonus);
        }
    }

    @Override
    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
            this.ticksInSun = 0;
            if (this.wasDead) {
                this.player.m_7292_(new MobEffectInstance(ModEffects.sunscreen, 400, 4, false, false));
                this.player.m_7292_(new MobEffectInstance(ModEffects.armor_regeneration, (Integer)VampirismConfig.BALANCE.vpNaturalArmorRegenDuration.get() * 20, 0, false, false));
                this.requestNaturalArmorUpdate();
                this.player.m_21153_(this.player.m_21233_());
                this.bloodStats.setBloodLevel(this.bloodStats.getMaxBlood());
            }
        }
    }

    @Override
    public void onLevelChanged(int newLevel, int oldLevel) {
        this.applyEntityAttributes();
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard(this.player, ScoreboardUtil.VAMPIRE_LEVEL_CRITERIA, newLevel);
            this.applyLevelModifiersA(newLevel);
            this.applyLevelModifiersB(newLevel, false);
            if (this.player.m_21223_() > this.player.m_21233_()) {
                this.player.m_21153_(this.player.m_21233_());
            }
            this.updateNaturalArmor(newLevel);
            if (newLevel > 13) {
                this.bloodStats.setMaxBlood(40);
            } else if (newLevel > 9) {
                this.bloodStats.setMaxBlood(34);
            } else if (newLevel > 6) {
                this.bloodStats.setMaxBlood(30);
            } else if (newLevel > 3) {
                this.bloodStats.setMaxBlood(26);
            } else {
                this.bloodStats.setMaxBlood(20);
            }
            if (newLevel > 0) {
                if (oldLevel == 0) {
                    this.skillHandler.enableRootSkill();
                }
            } else {
                this.actionHandler.resetTimers();
                this.skillHandler.disableAllSkills();
                this.skillHandler.resetRefinements();
            }
        } else if (oldLevel == 0) {
            if (this.player.m_21023_(MobEffects.f_19611_)) {
                this.player.m_21195_(MobEffects.f_19611_);
            }
        } else if (newLevel == 0) {
            if (this.player.m_21124_(MobEffects.f_19611_) instanceof VampireNightVisionEffectInstance) {
                this.player.m_21195_(MobEffects.f_19611_);
            }
            this.actionHandler.resetTimers();
            this.skillHandler.resetRefinements();
        }
    }

    @Override
    public void onPlayerLoggedIn() {
        if (this.getLevel() > 0 && !this.player.f_19853_.f_46443_) {
            this.player.m_7292_(new MobEffectInstance(ModEffects.sunscreen, 200, 4, true, false));
        }
    }

    @Override
    public void onPlayerLoggedOut() {
        this.endFeeding(false);
        if (this.isDBNO()) {
            this.setDBNOTimer(-1);
            this.player.m_6469_(DamageSource.f_19318_, 10000.0f);
        }
    }

    public void onSanguinareFinished() {
        if (Helper.canBecomeVampire(this.player) && !this.isRemote() && this.player.m_6084_()) {
            FactionPlayerHandler.getOpt(this.player).ifPresent(handler -> {
                handler.joinFaction((IPlayableFaction<?>)this.getFaction());
                this.player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300));
                this.player.m_7292_(new MobEffectInstance(MobEffects.f_19618_, 300));
            });
        }
    }

    @Override
    public void onUpdate() {
        Level world = this.player.m_20193_();
        world.m_46473_().m_6180_("vampirism_vampirePlayer");
        if (this.wasDBNO) {
            this.wasDBNO = false;
            this.player.m_6469_(DamageSource.f_19318_, 100000.0f);
            return;
        }
        if (this.dbnoTimer >= 0) {
            if (this.dbnoTimer > 0) {
                this.setDBNOTimer(this.dbnoTimer - 1);
                if (this.dbnoTimer == 0) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128405_(KEY_DBNO_TIMER, 0);
                    HelperLib.sync(this, nbt, (Entity)this.player, false);
                }
            }
            this.player.m_20301_(300);
            this.player.m_20334_(0.0, Math.min(0.0, this.player.m_20184_().m_7098_()), 0.0);
            this.player.m_21219_();
            return;
        }
        super.onUpdate();
        int level = this.getLevel();
        if (level > 0) {
            if (this.player.f_19797_ % 8 == 0) {
                this.isGettingSundamage((LevelAccessor)world, true);
            }
            if (this.player.f_19797_ % 40 == 0) {
                this.isGettingGarlicDamage((LevelAccessor)world, true);
            }
        } else {
            this.sundamage_cache = false;
            this.garlic_cache = EnumStrength.NONE;
        }
        if (this.activatedVision != null) {
            this.activatedVision.tick(this);
        }
        if (!this.isRemote()) {
            if (level > 0) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundTag syncPacket = new CompoundTag();
                if (this.isGettingSundamage((LevelAccessor)world)) {
                    this.handleSunDamage(false);
                } else if (this.ticksInSun > 0) {
                    --this.ticksInSun;
                }
                if (this.isGettingGarlicDamage((LevelAccessor)world) != EnumStrength.NONE) {
                    DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((LevelAccessor)world), this.player.f_19797_);
                }
                if (this.player.m_6084_()) {
                    this.player.m_20301_(300);
                    if (this.player.f_19797_ % 16 == 4 && !this.getSpecialAttributes().waterResistance && !this.player.m_150110_().f_35937_) {
                        if (this.player.m_20069_()) {
                            this.player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 80, (int)((float)this.getLevel() / (float)this.getMaxLevel() * 3.0f)));
                        } else if (this.player.m_20070_()) {
                            this.player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 80, 0));
                        }
                    }
                }
                if (this.player.f_19797_ % 9 == 3 && ((Boolean)VampirismConfig.BALANCE.vpFireResistanceReplace.get()).booleanValue() && this.player.m_21023_(MobEffects.f_19607_)) {
                    MobEffectInstance fireResistance = this.player.m_21124_(MobEffects.f_19607_);
                    this.player.m_7292_(new MobEffectInstance(ModEffects.fire_protection, fireResistance.m_19557_(), fireResistance.m_19564_()));
                    this.player.m_21195_(MobEffects.f_19607_);
                }
                if (this.player.f_19797_ % 9 == 3 && this.player.m_21023_(MobEffects.f_19612_)) {
                    MobEffectInstance hunterEffect = this.player.m_21124_(MobEffects.f_19612_);
                    this.player.m_7292_(new MobEffectInstance(ModEffects.thirst, hunterEffect.m_19557_(), hunterEffect.m_19564_()));
                    this.player.m_21195_(MobEffects.f_19612_);
                }
                if (this.player.f_19797_ % 64 == 0 && this.player instanceof ServerPlayer) {
                    ((ServerPlayer)this.player).m_8951_().m_6085_(this.player, Stats.f_12988_.m_12902_((Object)Stats.f_12992_), 1);
                }
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    this.actionHandler.writeUpdateForClient(syncPacket);
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    this.skillHandler.writeUpdateForClient(syncPacket);
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
                if (this.feed_victim != -1 && this.feedBiteTickCounter++ >= 20) {
                    this.updateFeeding();
                    this.feedBiteTickCounter = 0;
                }
                if (this.forceNaturalArmorUpdate || this.player.f_19797_ % 128 == 0) {
                    this.updateNaturalArmor(this.getLevel());
                    this.forceNaturalArmorUpdate = false;
                }
            } else {
                this.ticksInSun = 0;
            }
        } else {
            if (level > 0) {
                VampirismMod.proxy.handleSleepClient(this.player);
                this.actionHandler.updateActions();
                if (this.isGettingSundamage((LevelAccessor)world)) {
                    this.handleSunDamage(true);
                } else if (this.ticksInSun > 0) {
                    --this.ticksInSun;
                }
            } else {
                this.ticksInSun = 0;
            }
            if (this.feed_victim != -1 && this.feedBiteTickCounter++ % 5 == 0) {
                Entity e = VampirismMod.proxy.getMouseOverEntity();
                if (e == null || e.m_142049_() != this.feed_victim) {
                    VampirismMod.dispatcher.sendToServer(new InputEventPacket("esb", ""));
                    this.feedBiteTickCounter = 0;
                    this.feed_victim = -1;
                    return;
                }
                if (this.feedBiteTickCounter >= 20) {
                    this.feedBiteTickCounter = 0;
                }
            }
        }
        if (this.feed_victim == -1) {
            this.feedBiteTickCounter = 0;
        }
        if (this.wing_counter > 0) {
            --this.wing_counter;
        }
        world.m_46473_().m_7238_();
    }

    @Override
    public void onUpdatePlayer(TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.END && this.getLevel() > 0 && !this.isDBNO()) {
            this.player.f_19853_.m_46473_().m_6180_("vampirism_bloodupdate");
            if (!this.player.f_19853_.f_46443_ && this.bloodStats.onUpdate()) {
                this.sync(this.bloodStats.writeUpdate(new CompoundTag()), false);
            }
            this.player.f_19853_.m_46473_().m_7238_();
        }
    }

    public void requestNaturalArmorUpdate() {
        this.forceNaturalArmorUpdate = true;
    }

    @Override
    public void saveData(CompoundTag nbt) {
        super.saveData(nbt);
        this.bloodStats.writeNBT(nbt);
        nbt.m_128405_(KEY_EYE, this.getEyeType());
        nbt.m_128405_(KEY_FANGS, this.getFangType());
        nbt.m_128379_(KEY_GLOWING_EYES, this.getGlowingEyes());
        this.actionHandler.saveToNbt(nbt);
        this.skillHandler.saveToNbt(nbt);
        if (this.activatedVision != null) {
            nbt.m_128405_(KEY_VISION, VampirismAPI.vampireVisionRegistry().getIdOfVision(this.activatedVision));
        }
        if (this.isDBNO()) {
            nbt.m_128379_(KEY_WAS_DBNO, true);
        }
    }

    public boolean setEyeType(int eyeType) {
        if (eyeType >= 16 || eyeType < 0) {
            return false;
        }
        if (eyeType != this.getEyeType()) {
            this.getSpecialAttributes().eyeType = eyeType;
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_(KEY_EYE, eyeType);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public boolean setFangType(int fangType) {
        if (fangType >= 7 || fangType < 0) {
            return false;
        }
        if (fangType != this.getFangType()) {
            this.getSpecialAttributes().fangType = fangType;
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_(KEY_FANGS, fangType);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public void setSkinData(int ... data) {
        if (data.length > 0) {
            this.setFangType(data[0]);
            if (data.length > 1) {
                this.setEyeType(data[1]);
                if (data.length > 2) {
                    this.setGlowingEyes(data[2] > 0);
                }
            }
        }
    }

    public void switchVision() {
        int id = -1;
        if (this.activatedVision != null) {
            id = this.unlockedVisions.indexOf(this.activatedVision);
        }
        if (++id > this.unlockedVisions.size() - 1) {
            id = -1;
        }
        this.activateVision(id == -1 ? null : this.unlockedVisions.get(id));
    }

    public void triggerWings() {
        this.wing_counter = 1200;
        this.sync(true);
    }

    public void tryResurrect() {
        if (this.getDbnoTimer() == 0) {
            this.setDBNOTimer(-1);
            this.dbnoMessage = null;
            this.player.m_21153_(Math.max(0.5f, (float)(this.bloodStats.getBloodLevel() - 1)));
            this.bloodStats.removeBlood(this.bloodStats.getBloodLevel() - 1, true);
            this.player.setForcedPose(null);
            this.player.m_6210_();
            this.sync(true);
            int duration = (Integer)VampirismConfig.BALANCE.vpNeonatalDuration.get() * 20;
            if (this.skillHandler.isSkillEnabled(VampireSkills.neonatal_decrease)) {
                duration = Math.max(1, (int)((double)duration * (Double)VampirismConfig.BALANCE.vsNeonatalReduction.get()));
            }
            this.player.m_7292_(new MobEffectInstance(ModEffects.neonatal, duration));
        } else if (this.isRemote()) {
            this.setDBNOTimer(-1);
        } else {
            this.sync(false);
        }
    }

    public void giveUpDBNO() {
        if (this.isDBNO()) {
            this.setDBNOTimer(-1);
            Component msg = this.dbnoMessage;
            this.dbnoMessage = null;
            this.player.setForcedPose(null);
            this.player.m_6210_();
            this.sync(true);
            this.player.m_6469_((DamageSource)new DBNODamageSource(msg), 10000.0f);
        }
    }

    @Override
    public void unUnlockVision(@Nonnull IVampireVision vision) {
        if (vision.equals(this.activatedVision)) {
            this.activateVision(null);
        }
        this.unlockedVisions.remove(vision);
    }

    @Override
    public void unlockVision(@Nonnull IVampireVision vision) {
        if (VampirismAPI.vampireVisionRegistry().getIdOfVision(vision) == -1) {
            throw new IllegalArgumentException("You have to register the vision first: " + vision);
        }
        this.unlockedVisions.add(vision);
    }

    public void updateNaturalArmor(int lvl) {
        AttributeInstance armorAtt = this.player.m_21051_(Attributes.f_22284_);
        AttributeInstance toughnessAtt = this.player.m_21051_(Attributes.f_22285_);
        if (armorAtt != null && toughnessAtt != null) {
            if (lvl == 0) {
                armorAtt.m_22120_(NATURAL_ARMOR_UUID);
                toughnessAtt.m_22120_(NATURAL_ARMOR_UUID);
            } else {
                AttributeModifier modArmor = armorAtt.m_22111_(NATURAL_ARMOR_UUID);
                AttributeModifier modToughness = toughnessAtt.m_22111_(NATURAL_ARMOR_UUID);
                double naturalArmor = VampirePlayer.getNaturalArmorValue(lvl);
                MobEffectInstance armorRegen = this.player.m_21124_(ModEffects.armor_regeneration);
                double armorRegenerationMod = armorRegen == null ? 0.0 : (double)armorRegen.m_19557_() / ((double)((Integer)VampirismConfig.BALANCE.vpNaturalArmorRegenDuration.get()).intValue() * 20.0);
                double naturalToughness = VampirePlayer.getNaturalArmorToughnessValue(lvl);
                List<UUID> armorItemModifiers = Arrays.asList(ArmorItemAccessor.getModifierUUID_vampirism());
                double baseArmor = armorAtt.m_22104_(AttributeModifier.Operation.ADDITION).stream().filter(m -> armorItemModifiers.contains(m.m_22209_())).map(AttributeModifier::m_22218_).mapToDouble(Double::doubleValue).sum();
                double baseToughness = toughnessAtt.m_22104_(AttributeModifier.Operation.ADDITION).stream().filter(m -> armorItemModifiers.contains(m.m_22209_())).map(AttributeModifier::m_22218_).mapToDouble(Double::doubleValue).sum();
                double targetArmor = Math.max(0.0, (naturalArmor *= 1.0 - 0.75 * armorRegenerationMod) - baseArmor);
                double targetToughness = Math.max(0.0, naturalToughness - baseToughness);
                if (modArmor != null && targetArmor != modArmor.m_22218_()) {
                    armorAtt.m_22130_(modArmor);
                    modArmor = null;
                }
                if (targetArmor != 0.0 && modArmor == null) {
                    armorAtt.m_22118_(new AttributeModifier(NATURAL_ARMOR_UUID, "Natural Vampire Armor", targetArmor, AttributeModifier.Operation.ADDITION));
                }
                if (modToughness != null && targetToughness != modToughness.m_22218_()) {
                    toughnessAtt.m_22130_(modToughness);
                    modToughness = null;
                }
                if (targetToughness != 0.0 && modToughness == null) {
                    toughnessAtt.m_22118_(new AttributeModifier(NATURAL_ARMOR_UUID, "Natural Vampire Armor Toughness", targetToughness, AttributeModifier.Operation.ADDITION));
                }
                this.applyLevelModifiersB(lvl, (Boolean)VampirismConfig.BALANCE.vpArmorPenalty.get() != false && baseArmor > 7.0);
            }
        }
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        return this.bloodStats.removeBlood(amt, allowPartial);
    }

    @Override
    public boolean wantsBlood() {
        return this.getLevel() > 0 && this.bloodStats.needsBlood();
    }

    @Override
    protected FactionBasePlayer<IVampirePlayer> copyFromPlayer(Player old) {
        VampirePlayer oldVampire = VampirePlayer.get(old);
        CompoundTag nbt = new CompoundTag();
        oldVampire.saveData(nbt);
        this.loadData(nbt);
        this.wasDead = oldVampire.wasDead;
        return oldVampire;
    }

    @Override
    protected void loadUpdate(CompoundTag nbt) {
        super.loadUpdate(nbt);
        if (nbt.m_128441_(KEY_EYE)) {
            this.setEyeType(nbt.m_128451_(KEY_EYE));
        }
        if (nbt.m_128441_(KEY_FANGS)) {
            this.setFangType(nbt.m_128451_(KEY_FANGS));
        }
        if (nbt.m_128441_(KEY_SPAWN_BITE_PARTICLE)) {
            this.spawnBiteParticle(nbt.m_128451_(KEY_SPAWN_BITE_PARTICLE));
        }
        if (nbt.m_128441_(KEY_GLOWING_EYES)) {
            this.setGlowingEyes(nbt.m_128471_(KEY_GLOWING_EYES));
        }
        if (nbt.m_128441_(KEY_FEED_VICTIM_ID)) {
            this.feed_victim = nbt.m_128451_(KEY_FEED_VICTIM_ID);
        }
        if (nbt.m_128441_(KEY_WING_COUNTER)) {
            this.wing_counter = nbt.m_128451_(KEY_WING_COUNTER);
        }
        if (nbt.m_128441_(KEY_DBNO_MSG)) {
            this.dbnoMessage = Component.Serializer.m_130701_((String)nbt.m_128461_(KEY_DBNO_MSG));
        }
        if (nbt.m_128441_(KEY_DBNO_TIMER)) {
            boolean wasDBNOClient = this.isDBNO();
            this.setDBNOTimer(nbt.m_128451_(KEY_DBNO_TIMER));
            if (!wasDBNOClient && this.isDBNO()) {
                VampirismMod.proxy.showDBNOScreen(this.player, this.dbnoMessage);
                this.player.setForcedPose(Pose.SLEEPING);
                this.player.m_6210_();
            } else if (wasDBNOClient && !this.isDBNO()) {
                this.player.setForcedPose(null);
                this.player.m_6210_();
            }
        }
        this.bloodStats.loadUpdate(nbt);
        this.actionHandler.readUpdateFromServer(nbt);
        this.skillHandler.readUpdateFromServer(nbt);
        if (nbt.m_128441_(KEY_VISION)) {
            IVampireVision vision;
            int id = nbt.m_128451_(KEY_VISION);
            if (id == -1) {
                vision = null;
            } else {
                vision = VampirismAPI.vampireVisionRegistry().getVisionOfId(id);
                if (vision == null) {
                    LOGGER.warn("Failed to find vision with id {}", (Object)id);
                }
            }
            this.activateVision(vision);
        }
    }

    @Override
    protected void writeFullUpdate(CompoundTag nbt) {
        super.writeFullUpdate(nbt);
        nbt.m_128405_(KEY_EYE, this.getEyeType());
        nbt.m_128405_(KEY_FANGS, this.getFangType());
        nbt.m_128379_(KEY_GLOWING_EYES, this.getGlowingEyes());
        nbt.m_128405_(KEY_FEED_VICTIM_ID, this.feed_victim);
        nbt.m_128405_(KEY_WING_COUNTER, this.wing_counter);
        this.bloodStats.writeUpdate(nbt);
        this.actionHandler.writeUpdateForClient(nbt);
        this.skillHandler.writeUpdateForClient(nbt);
        nbt.m_128405_(KEY_VISION, this.activatedVision == null ? -1 : VampirismAPI.vampireVisionRegistry().getIdOfVision(this.activatedVision));
        nbt.m_128405_(KEY_DBNO_TIMER, this.getDbnoTimer());
        if (this.dbnoMessage != null) {
            nbt.m_128359_(KEY_DBNO_MSG, Component.Serializer.m_130703_((Component)this.dbnoMessage));
        }
    }

    private void applyEntityAttributes() {
        this.player.m_21051_((Attribute)ModAttributes.sundamage).m_22100_(((Double)VampirismConfig.BALANCE.vpSundamage.get()).doubleValue());
        this.player.m_21051_((Attribute)ModAttributes.blood_exhaustion).m_22100_(((Double)VampirismConfig.BALANCE.vpBasicBloodExhaustionMod.get()).doubleValue());
    }

    private void applyLevelModifiersA(int level) {
        LevelAttributeModifier.applyModifier(this.player, Attributes.f_22276_, "Vampire", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpHealthMaxMod.get(), 0.5, AttributeModifier.Operation.ADDITION, true);
        LevelAttributeModifier.applyModifier(this.player, (Attribute)ModAttributes.blood_exhaustion, "Vampire", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpExhaustionMaxMod.get(), 0.5, AttributeModifier.Operation.MULTIPLY_BASE, false);
    }

    private void applyLevelModifiersB(int level, boolean heavyArmor) {
        LevelAttributeModifier.applyModifier(this.player, Attributes.f_22279_, "Vampire", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpSpeedMaxMod.get() * (double)(heavyArmor ? 0.5f : 1.0f), 0.5, AttributeModifier.Operation.MULTIPLY_BASE, false);
        LevelAttributeModifier.applyModifier(this.player, Attributes.f_22283_, "Vampire", level, this.getMaxLevel(), (Double)VampirismConfig.BALANCE.vpAttackSpeedMaxMod.get() * (double)(heavyArmor ? 0.5f : 1.0f), 0.5, AttributeModifier.Operation.MULTIPLY_BASE, false);
    }

    private void biteBlock(@Nonnull BlockPos pos, @Nonnull BlockState blockState, @Nullable BlockEntity tileEntity) {
        if (this.isRemote()) {
            return;
        }
        if (this.getLevel() == 0) {
            return;
        }
        if (!this.bloodStats.needsBlood()) {
            return;
        }
        int need = Math.min(8, this.bloodStats.getMaxBlood() - this.bloodStats.getBloodLevel());
        if (((Object)((Object)ModBlocks.blood_container)).equals(blockState.m_60734_()) && tileEntity != null) {
            tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).ifPresent(handler -> {
                FluidStack drained;
                int blood = 0;
                FluidStack drainable = handler.drain(new FluidStack(ModFluids.blood, need * 100), IFluidHandler.FluidAction.SIMULATE);
                if (drainable.getAmount() >= 100 && !(drained = handler.drain(drainable.getAmount() / 100 * 100, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                    blood = drained.getAmount() / 100;
                }
                if (blood > 0) {
                    this.drinkBlood(blood, 0.3f);
                    CompoundTag updatePacket = this.bloodStats.writeUpdate(new CompoundTag());
                    this.sync(updatePacket, true);
                }
            });
        }
    }

    private boolean biteFeed(LivingEntity entity) {
        if (this.isRemote()) {
            return true;
        }
        if (this.getLevel() == 0) {
            return false;
        }
        int blood = 0;
        float saturationMod = 1.0f;
        boolean continue_feeding = true;
        if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_CREATURE && entity.m_6084_()) {
            LazyOptional<IExtendedCreatureVampirism> opt = ExtendedCreature.getSafe((Entity)entity);
            blood = opt.map(creature -> creature.onBite(this)).orElse(0);
            saturationMod = opt.map(IBiteableEntity::getBloodSaturation).orElse(Float.valueOf(0.0f)).floatValue();
            if (this.isAdvancedBiter() && opt.map(IExtendedCreatureVampirism::getBlood).orElse(0) == 1) {
                continue_feeding = false;
            }
        } else if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_PLAYER) {
            blood = VampirePlayer.getOpt((Player)entity).map(v -> v.onBite(this)).orElse(0);
            saturationMod = VampirePlayer.getOpt((Player)entity).map(VampirePlayer::getBloodSaturation).orElse(Float.valueOf(0.0f)).floatValue();
        } else if (this.feed_victim_bite_type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD) {
            blood = ((IBiteableEntity)entity).onBite(this);
            saturationMod = ((IBiteableEntity)entity).getBloodSaturation();
        }
        if (blood > 0) {
            this.drinkBlood(blood, saturationMod);
            CompoundTag updatePacket = this.bloodStats.writeUpdate(new CompoundTag());
            updatePacket.m_128405_(KEY_SPAWN_BITE_PARTICLE, entity.m_142049_());
            this.sync(updatePacket, true);
            if (this.player instanceof ServerPlayer) {
                ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayer)this.player, VampireActionTrigger.Action.SUCK_BLOOD);
            }
            return continue_feeding;
        }
        return false;
    }

    private void handleSpareBlood(int amt) {
        BloodHelper.fillBloodIntoInventory(this.player, amt * 100);
    }

    private void handleSunDamage(boolean isRemote) {
        float damage;
        int sunscreen;
        MobEffectInstance potionEffect = this.player.m_21124_(ModEffects.sunscreen);
        int n = sunscreen = potionEffect == null ? -1 : potionEffect.m_19564_();
        if (this.ticksInSun < 100) {
            ++this.ticksInSun;
        }
        if (sunscreen >= 5 && this.ticksInSun > 50) {
            this.ticksInSun = 50;
        }
        if (isRemote || this.player.m_150110_().f_35937_ || this.player.m_150110_().f_35934_) {
            return;
        }
        if (((Boolean)VampirismConfig.BALANCE.vpSundamageNausea.get()).booleanValue() && this.getLevel() >= (Integer)VampirismConfig.BALANCE.vpSundamageNauseaMinLevel.get() && this.player.f_19797_ % 300 == 1 && this.ticksInSun > 50 && sunscreen == -1) {
            this.player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 180));
        }
        if (this.getLevel() >= (Integer)VampirismConfig.BALANCE.vpSundamageWeaknessMinLevel.get() && this.player.f_19797_ % 150 == 3 && sunscreen < 5) {
            this.player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 152, 0));
        }
        if (this.getLevel() >= (Integer)VampirismConfig.BALANCE.vpSundamageMinLevel.get() && this.ticksInSun >= 100 && this.player.f_19797_ % 40 == 5 && (damage = (float)this.player.m_21051_((Attribute)ModAttributes.sundamage).m_22135_()) > 0.0f) {
            this.player.m_6469_(VReference.SUNDAMAGE, damage);
        }
    }

    private void resetNearbyTargetingMobs() {
        AABB axisalignedbb = new AABB(this.player.m_142538_()).m_82377_(32.0, 10.0, 32.0);
        this.player.f_19853_.m_45976_(Mob.class, axisalignedbb).forEach(e -> {
            if (e.m_5448_() == this.player) {
                e.f_21346_.m_25386_().filter(g -> g.m_26015_() instanceof TargetGoal).forEach(WrappedGoal::m_8041_);
            }
            if (e instanceof NeutralMob) {
                ((NeutralMob)e).m_21676_(this.player);
            }
        });
    }

    private void setDBNOTimer(int newValue) {
        this.dbnoTimer = newValue;
        this.getSpecialAttributes().isDBNO = this.isDBNO();
    }

    private void spawnBiteParticle(int entityId) {
        Entity entity = this.player.f_19853_.m_6815_(entityId);
        if (entity != null) {
            UtilLib.spawnParticles(this.player.f_19853_, (ParticleOptions)ParticleTypes.f_123797_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.player.m_20185_() - entity.m_20185_(), this.player.m_20186_() - entity.m_20186_(), this.player.m_20189_() - entity.m_20189_(), 10, 1.0f);
        }
        for (int j = 0; j < 16; ++j) {
            Vec3 vec3 = new Vec3(((double)this.player.m_21187_().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.m_82496_(-this.player.m_146909_() * (float)Math.PI / 180.0f);
            vec3 = vec3.m_82524_(-this.player.m_146908_() * (float)Math.PI / 180.0f);
            double d0 = (double)(-this.player.m_21187_().nextFloat()) * 0.6 - 0.3;
            Vec3 vec31 = new Vec3(((double)this.player.m_21187_().nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.m_82496_(-this.player.m_146909_() * (float)Math.PI / 180.0f);
            vec31 = vec31.m_82524_(-this.player.m_146908_() * (float)Math.PI / 180.0f);
            vec31 = vec31.m_82520_(this.player.m_20185_(), this.player.m_20186_() + (double)this.player.m_20192_(), this.player.m_20189_());
            this.player.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42410_)), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
        }
        this.player.f_19853_.m_7785_(this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), ModSounds.player_bite, SoundSource.PLAYERS, 1.0f, 1.0f, false);
    }

    private void updateFeeding() {
        Entity entity = this.player.f_19853_.m_6815_(this.feed_victim);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity e = (LivingEntity)entity;
        if (e.m_21223_() == 0.0f) {
            this.endFeeding(true);
            return;
        }
        e.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 7, false, false));
        this.player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 25, 4, false, false));
        ModParticles.spawnParticlesServer(this.player.f_19853_, new FlyingBloodEntityParticleData(ModParticles.flying_blood_entity, this.player.m_142049_(), true), e.m_20185_(), e.m_20186_() + (double)(e.m_20192_() / 2.0f), e.m_20189_(), 10, 0.1f, 0.1f, 0.1f, 0.0);
        if (!this.biteFeed(e)) {
            this.endFeeding(true);
        }
        if (!((double)e.m_20270_((Entity)this.player) <= this.player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() + 1.0) || e.m_21223_() == 0.0f) {
            this.endFeeding(true);
        }
    }
}

