/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.tasks.reward;

import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class LordLevelReward
implements TaskReward,
ITaskRewardInstance {
    public static final ResourceLocation ID = new ResourceLocation("vampirism", "lord_level_reward");
    public final int targetLevel;

    public static LordLevelReward decode(FriendlyByteBuf buffer) {
        return new LordLevelReward(buffer.m_130242_());
    }

    public static LordLevelReward readNbt(CompoundTag nbt) {
        return new LordLevelReward(nbt.m_128451_("targetLevel"));
    }

    public LordLevelReward(int targetLevel) {
        this.targetLevel = targetLevel;
    }

    @Override
    public void applyReward(IFactionPlayer<?> p) {
        FactionPlayerHandler.getOpt(p.getRepresentingPlayer()).ifPresent(fph -> {
            if (fph.getLordLevel() == this.targetLevel - 1) {
                fph.setLordLevel(this.targetLevel);
            }
        });
    }

    @Override
    public ITaskRewardInstance createInstance(IFactionPlayer<?> player) {
        return this;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.targetLevel);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag writeNBT(@Nonnull CompoundTag nbt) {
        nbt.m_128405_("targetLevel", this.targetLevel);
        return nbt;
    }
}

