/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillManager;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkillManager
implements ISkillManager {
    private static final Logger LOGGER = LogManager.getLogger(SkillManager.class);

    @Nonnull
    public <T extends IFactionPlayer<T>> ISkill<T> getRootSkill(IPlayableFaction<T> faction) {
        ISkill skill = (ISkill)ModRegistries.SKILLS.getValue(faction.getID());
        if (skill == null) {
            LOGGER.warn("No root skill exists for faction {}", (Object)faction.getID());
            throw new IllegalStateException("You need to register a root skill for your faction " + faction.getID());
        }
        return skill;
    }

    @Override
    public <T extends IFactionPlayer<T>> List<ISkill<T>> getSkillsForFaction(IPlayableFaction<T> faction) {
        return ModRegistries.SKILLS.getValues().stream().filter(action -> action.getFaction() == faction).map(action -> action).collect(Collectors.toList());
    }

    public void printSkills(IPlayableFaction<?> faction, CommandSourceStack sender) {
        for (ISkill<?> s : this.getSkillsForFaction(faction)) {
            sender.m_81354_((Component)new TextComponent("ID: " + ModRegistries.SKILLS.getKey(s) + " Skill: ").m_7220_(s.getName()), true);
        }
    }
}

