/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.actions;

import com.google.common.collect.ImmutableList;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.util.Permissions;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionHandler<T extends IFactionPlayer<T>>
implements IActionHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger(ActionHandler.class);
    private final Object2IntMap<ResourceLocation> cooldownTimers;
    private final Object2IntMap<ResourceLocation> activeTimers;
    private final T player;
    private final List<IAction<T>> unlockedActions = new ArrayList<IAction<T>>();
    private boolean dirty = false;

    public ActionHandler(T player) {
        this.player = player;
        List actions = VampirismAPI.actionManager().getActionsForFaction(player.getFaction());
        this.cooldownTimers = new Object2IntOpenHashMap(actions.size(), 0.9f);
        this.activeTimers = new Object2IntOpenHashMap(actions.size(), 0.9f);
    }

    @Override
    public void deactivateAllActions() {
        for (ResourceLocation r : this.activeTimers.keySet()) {
            ILastingAction action = (ILastingAction)ModRegistries.ACTIONS.getValue(r);
            assert (action != null);
            int cooldown = action.getCooldown(this.player);
            this.cooldownTimers.put((Object)r, cooldown);
            action.onDeactivated(this.player);
        }
        this.activeTimers.clear();
    }

    @Override
    public void extendActionTimer(@Nonnull ILastingAction<T> action, int duration) {
        int i = this.activeTimers.getOrDefault((Object)action.getRegistryName(), -1);
        if (i > 0) {
            this.activeTimers.put((Object)action.getRegistryName(), i + duration);
        }
    }

    @Override
    public List<IAction<T>> getAvailableActions() {
        ArrayList<IAction<T>> actions = new ArrayList<IAction<T>>();
        for (IAction<T> action : this.unlockedActions) {
            if (action.canUse(this.player) != IAction.PERM.ALLOWED) continue;
            actions.add(action);
        }
        return actions;
    }

    @Override
    public float getPercentageForAction(@Nonnull IAction<T> action) {
        if (this.activeTimers.containsKey((Object)action.getRegistryName())) {
            return (float)this.activeTimers.get((Object)action.getRegistryName()).intValue() / (float)((ILastingAction)action).getDuration(this.player);
        }
        if (this.cooldownTimers.containsKey((Object)action.getRegistryName())) {
            return (float)(-this.cooldownTimers.get((Object)action.getRegistryName()).intValue()) / (float)action.getCooldown(this.player);
        }
        return 0.0f;
    }

    @Override
    public ImmutableList<IAction<T>> getUnlockedActions() {
        return ImmutableList.copyOf(this.unlockedActions);
    }

    @Override
    public boolean isActionActive(@Nonnull ILastingAction<T> action) {
        return this.activeTimers.containsKey((Object)action.getRegistryName());
    }

    @Override
    public boolean isActionActive(ResourceLocation id) {
        return this.activeTimers.containsKey((Object)id);
    }

    @Override
    public boolean isActionOnCooldown(IAction<T> action) {
        return this.cooldownTimers.containsKey((Object)action.getRegistryName());
    }

    @Override
    public boolean isActionUnlocked(IAction<T> action) {
        return this.unlockedActions.contains(action);
    }

    public void loadFromNbt(CompoundTag nbt) {
        this.activeTimers.clear();
        this.cooldownTimers.clear();
        if (nbt.m_128441_("actions_active")) {
            this.loadTimerMapFromNBT(nbt.m_128469_("actions_active"), this.activeTimers);
        }
        if (nbt.m_128441_("actions_cooldown")) {
            this.loadTimerMapFromNBT(nbt.m_128469_("actions_cooldown"), this.cooldownTimers);
        }
    }

    public void onActionsReactivated() {
        if (!this.player.isRemote()) {
            for (ResourceLocation id : this.activeTimers.keySet()) {
                ILastingAction action = (ILastingAction)ModRegistries.ACTIONS.getValue(id);
                assert (action != null);
                action.onReActivated(this.player);
            }
        }
    }

    public void readUpdateFromServer(CompoundTag nbt) {
        if (nbt.m_128441_("actions_active")) {
            ILastingAction action;
            CompoundTag active = nbt.m_128469_("actions_active");
            ObjectIterator it = this.activeTimers.object2IntEntrySet().iterator();
            while (it.hasNext()) {
                Object2IntMap.Entry client_active = (Object2IntMap.Entry)it.next();
                String key = ((ResourceLocation)client_active.getKey()).toString();
                if (active.m_128441_(key)) {
                    client_active.setValue(active.m_128451_(key));
                    nbt.m_128473_(key);
                    continue;
                }
                action = (ILastingAction)ModRegistries.ACTIONS.getValue((ResourceLocation)client_active.getKey());
                assert (action != null);
                action.onDeactivated(this.player);
                it.remove();
            }
            for (String key : active.m_128431_()) {
                ResourceLocation id = new ResourceLocation(key);
                action = (ILastingAction)ModRegistries.ACTIONS.getValue(id);
                if (action == null) {
                    LOGGER.error("Action {} is not available client side", (Object)key);
                    continue;
                }
                action.onActivatedClient(this.player);
                this.activeTimers.put((Object)id, active.m_128451_(key));
            }
        }
        if (nbt.m_128441_("actions_cooldown")) {
            this.cooldownTimers.clear();
            this.loadTimerMapFromNBT(nbt.m_128469_("actions_cooldown"), this.cooldownTimers);
        }
    }

    @Override
    public void relockActions(Collection<IAction<T>> actions) {
        this.unlockedActions.removeAll(actions);
        for (IAction<T> action : actions) {
            if (!(action instanceof ILastingAction) || !this.isActionActive((ILastingAction)action)) continue;
            this.toggleAction(action);
        }
    }

    @Override
    public void resetTimers() {
        for (ResourceLocation id : this.activeTimers.keySet()) {
            ILastingAction action = (ILastingAction)ModRegistries.ACTIONS.getValue(id);
            assert (action != null);
            action.onDeactivated(this.player);
        }
        this.activeTimers.clear();
        this.cooldownTimers.clear();
        this.dirty = true;
    }

    public void saveToNbt(CompoundTag nbt) {
        nbt.m_128365_("actions_active", (Tag)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.activeTimers.object2IntEntrySet()));
        nbt.m_128365_("actions_cooldown", (Tag)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.cooldownTimers.object2IntEntrySet()));
    }

    @Override
    public IAction.PERM toggleAction(IAction<T> action) {
        ResourceLocation id = action.getRegistryName();
        if (this.activeTimers.containsKey((Object)id)) {
            int cooldown = action.getCooldown(this.player);
            int leftTime = this.activeTimers.getInt((Object)id);
            int duration = ((ILastingAction)action).getDuration(this.player);
            cooldown = (int)((float)cooldown - (float)cooldown * ((float)leftTime / (float)duration / 2.0f));
            ((ILastingAction)action).onDeactivated(this.player);
            this.activeTimers.removeInt((Object)id);
            this.cooldownTimers.put((Object)id, Math.max(cooldown, 1));
            this.dirty = true;
            return IAction.PERM.ALLOWED;
        }
        if (this.cooldownTimers.containsKey((Object)id)) {
            return IAction.PERM.COOLDOWN;
        }
        if (!this.isActionUnlocked(action)) {
            return IAction.PERM.NOT_UNLOCKED;
        }
        if (!this.isActionAllowedPermission(action)) {
            return IAction.PERM.DISALLOWED;
        }
        IAction.PERM r = action.canUse(this.player);
        if (r == IAction.PERM.ALLOWED) {
            if (action.onActivated(this.player)) {
                if (action instanceof ILastingAction) {
                    this.activeTimers.put((Object)id, ((ILastingAction)action).getDuration(this.player));
                } else {
                    this.cooldownTimers.put((Object)id, action.getCooldown(this.player));
                }
                this.dirty = true;
            }
            return IAction.PERM.ALLOWED;
        }
        return r;
    }

    @Override
    public void unlockActions(Collection<IAction<T>> actions) {
        for (IAction<T> action : actions) {
            if (ModRegistries.ACTIONS.containsValue(action)) continue;
            throw new ActionNotRegisteredException(action);
        }
        this.unlockedActions.addAll(actions);
    }

    public boolean updateActions() {
        Object2IntMap.Entry entry;
        ObjectIterator it = this.cooldownTimers.object2IntEntrySet().iterator();
        while (it.hasNext()) {
            entry = (Object2IntMap.Entry)it.next();
            int value = entry.getIntValue();
            if (value <= 1) {
                it.remove();
                continue;
            }
            entry.setValue(value - 1);
        }
        it = this.activeTimers.object2IntEntrySet().iterator();
        while (it.hasNext()) {
            entry = (Object2IntMap.Entry)it.next();
            int newtimer = entry.getIntValue() - 1;
            ILastingAction action = (ILastingAction)ModRegistries.ACTIONS.getValue((ResourceLocation)entry.getKey());
            assert (action != null);
            if (newtimer == 0) {
                action.onDeactivated(this.player);
                this.cooldownTimers.put((Object)((ResourceLocation)entry.getKey()), action.getCooldown(this.player));
                it.remove();
                this.dirty = true;
                continue;
            }
            if (action.onUpdate(this.player)) {
                entry.setValue(1);
                continue;
            }
            entry.setValue(newtimer);
        }
        if (this.dirty) {
            this.dirty = false;
            return true;
        }
        return false;
    }

    public void writeUpdateForClient(CompoundTag nbt) {
        nbt.m_128365_("actions_active", (Tag)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.activeTimers.object2IntEntrySet()));
        nbt.m_128365_("actions_cooldown", (Tag)this.writeTimersToNBT((ObjectSet<Object2IntMap.Entry<ResourceLocation>>)this.cooldownTimers.object2IntEntrySet()));
    }

    private boolean isActionAllowedPermission(IAction<T> action) {
        Player player = this.player.getRepresentingPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return (Boolean)PermissionAPI.getPermission((ServerPlayer)serverPlayer, Permissions.ACTION, (PermissionDynamicContext[])new PermissionDynamicContext[]{Permissions.ACTION_CONTEXT.createContext(action)});
        }
        return true;
    }

    private void loadTimerMapFromNBT(CompoundTag nbt, Object2IntMap<ResourceLocation> map) {
        for (String key : nbt.m_128431_()) {
            ResourceLocation id = new ResourceLocation(key);
            if (ModRegistries.ACTIONS.getValue(id) == null) {
                LOGGER.warn("Did not find action with key {}", (Object)key);
                continue;
            }
            map.put((Object)id, nbt.m_128451_(key));
        }
    }

    private CompoundTag writeTimersToNBT(ObjectSet<Object2IntMap.Entry<ResourceLocation>> set) {
        CompoundTag nbt = new CompoundTag();
        for (Object2IntMap.Entry entry : set) {
            nbt.m_128405_(((ResourceLocation)entry.getKey()).toString(), entry.getIntValue());
        }
        return nbt;
    }

    public static class ActionNotRegisteredException
    extends RuntimeException {
        public ActionNotRegisteredException(String name) {
            super("Action " + name + " is not registered. You cannot use it otherwise");
        }

        public ActionNotRegisteredException(IAction<?> action) {
            this(action.toString());
        }
    }
}

