/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.core.ModParticles;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class FlyingBloodEntityParticleData
implements ParticleOptions {
    public static final Codec<FlyingBloodEntityParticleData> CODEC = RecordCodecBuilder.create(p_239803_0_ -> p_239803_0_.group((App)Codec.INT.fieldOf("e").forGetter(p_239807_0_ -> p_239807_0_.entity), (App)Codec.BOOL.fieldOf("d").forGetter(p_239806_0_ -> p_239806_0_.direct)).apply((Applicative)p_239803_0_, (e, d) -> new FlyingBloodEntityParticleData(ModParticles.flying_blood_entity, (int)e, (boolean)d)));
    public static final ParticleOptions.Deserializer<FlyingBloodEntityParticleData> DESERIALIZER = new ParticleOptions.Deserializer<FlyingBloodEntityParticleData>(){

        @Nonnull
        public FlyingBloodEntityParticleData fromCommand(@Nonnull ParticleType<FlyingBloodEntityParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new FlyingBloodEntityParticleData(particleTypeIn, reader.readInt(), reader.readBoolean());
        }

        @Nonnull
        public FlyingBloodEntityParticleData fromNetwork(@Nonnull ParticleType<FlyingBloodEntityParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new FlyingBloodEntityParticleData(particleTypeIn, buffer.m_130242_(), buffer.readBoolean());
        }
    };
    private final int entity;
    private final boolean direct;
    private final ParticleType<FlyingBloodEntityParticleData> particleType;

    public FlyingBloodEntityParticleData(ParticleType<FlyingBloodEntityParticleData> particleTypeIn, int entityID, boolean directIn) {
        this.particleType = particleTypeIn;
        this.entity = entityID;
        this.direct = directIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getDirect() {
        return this.direct;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEntityID() {
        return this.entity;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.entity);
        buffer.writeBoolean(this.direct);
    }

    @Nonnull
    public ParticleType<?> m_6012_() {
        return this.particleType;
    }

    @Nonnull
    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()) + " " + this.entity + this.direct;
    }
}

