/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.player.tasks.TaskInstance;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public record TaskStatusPacket(Set<ITaskInstance> available, Set<UUID> completableTasks, Map<UUID, Map<ResourceLocation, Integer>> completedRequirements, int containerId, UUID taskBoardId) implements IMessage
{
    static void encode(@Nonnull TaskStatusPacket msg, @Nonnull FriendlyByteBuf buf) {
        buf.m_130070_(msg.taskBoardId.toString());
        buf.m_130130_(msg.containerId);
        buf.m_130130_(msg.completableTasks.size());
        msg.completableTasks.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130077_(arg_0));
        buf.m_130130_(msg.available.size());
        msg.available.forEach(ins -> ins.encode(buf));
        buf.m_130130_(msg.completedRequirements.size());
        msg.completedRequirements.forEach((id, resourceLocations) -> {
            buf.m_130130_(resourceLocations.size());
            buf.m_130077_(id);
            resourceLocations.forEach((loc, val) -> {
                buf.m_130085_(loc);
                buf.m_130130_(val.intValue());
            });
        });
    }

    static TaskStatusPacket decode(@Nonnull FriendlyByteBuf buf) {
        UUID taskBoardId = UUID.fromString(buf.m_130277_());
        int containerId = buf.m_130242_();
        int completableTaskSize = buf.m_130242_();
        HashSet completableTasks = Sets.newHashSetWithExpectedSize((int)completableTaskSize);
        for (int i = 0; i < completableTaskSize; ++i) {
            completableTasks.add(buf.m_130259_());
        }
        int taskSize = buf.m_130242_();
        HashSet taskInstances = Sets.newHashSetWithExpectedSize((int)taskSize);
        for (int i = 0; i < taskSize; ++i) {
            taskInstances.add(TaskInstance.decode(buf));
        }
        int completedReqSize = buf.m_130242_();
        HashMap completedRequirements = Maps.newHashMapWithExpectedSize((int)completedReqSize);
        for (int i = 0; i < completedReqSize; ++i) {
            int l;
            UUID id = buf.m_130259_();
            HashMap req = Maps.newHashMapWithExpectedSize((int)l);
            for (l = buf.m_130242_(); l > 0; --l) {
                req.put(buf.m_130281_(), buf.m_130242_());
            }
            completedRequirements.put(id, req);
        }
        return new TaskStatusPacket(taskInstances, completableTasks, completedRequirements, containerId, taskBoardId);
    }

    public static void handle(TaskStatusPacket msg, @Nonnull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleTaskStatusPacket(msg));
        ctx.setPacketHandled(true);
    }
}

