/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.player.skills.SkillNode;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class SkillTreePacket
implements IMessage {
    private final Map<ResourceLocation, SkillNode.Builder> nodes;

    static void encode(SkillTreePacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.nodes.size());
        for (Map.Entry<ResourceLocation, SkillNode.Builder> e : msg.nodes.entrySet()) {
            buf.m_130085_(e.getKey());
            e.getValue().writeTo(buf);
        }
    }

    static SkillTreePacket decode(FriendlyByteBuf buf) {
        SkillTreePacket pkt = new SkillTreePacket();
        int count = buf.m_130242_();
        for (int i = 0; i < count; ++i) {
            ResourceLocation id = buf.m_130281_();
            SkillNode.Builder b = SkillNode.Builder.readFrom(buf);
            pkt.nodes.put(id, b);
        }
        return pkt;
    }

    public static void handle(SkillTreePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleSkillTreePacket(msg));
        ctx.setPacketHandled(true);
    }

    public SkillTreePacket(Map<ResourceLocation, SkillNode.Builder> nodes) {
        this.nodes = nodes;
    }

    private SkillTreePacket() {
        this.nodes = new HashMap<ResourceLocation, SkillNode.Builder>();
    }

    public Map<ResourceLocation, SkillNode.Builder> getNodes() {
        return this.nodes;
    }
}

