/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;

public record RequestMinionSelectPacket(Action action, List<Pair<Integer, Component>> minions) implements IMessage
{
    public static void handle(RequestMinionSelectPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleRequestMinionSelect(msg.action, msg.minions));
        ctx.setPacketHandled(true);
    }

    static void encode(RequestMinionSelectPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.action.ordinal());
        buf.m_130130_(msg.minions.size());
        for (Pair<Integer, Component> minion : msg.minions) {
            buf.m_130130_(((Integer)minion.getLeft()).intValue());
            buf.m_130083_((Component)minion.getRight());
        }
    }

    static RequestMinionSelectPacket decode(FriendlyByteBuf buf) {
        Action a = Action.values()[buf.m_130242_()];
        int count = buf.m_130242_();
        ArrayList<Pair<Integer, Component>> minions = new ArrayList<Pair<Integer, Component>>(count);
        for (int i = 0; i < count; ++i) {
            minions.add((Pair<Integer, Component>)Pair.of((Object)buf.m_130242_(), (Object)buf.m_130238_()));
        }
        return new RequestMinionSelectPacket(a, minions);
    }

    public static enum Action {
        CALL;

    }
}

