/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public record BloodValuePacket(Pair<Map<ResourceLocation, Integer>, Integer>[] values) implements IMessage
{
    static void encode(BloodValuePacket msg, FriendlyByteBuf buf) {
        for (Pair<Map<ResourceLocation, Integer>, Integer> e : msg.values) {
            buf.m_130130_(((Map)e.getFirst()).size());
            for (Map.Entry f : ((Map)e.getFirst()).entrySet()) {
                buf.m_130085_((ResourceLocation)f.getKey());
                buf.m_130130_(((Integer)f.getValue()).intValue());
            }
            buf.m_130130_(((Integer)e.getSecond()).intValue());
        }
    }

    static BloodValuePacket decode(FriendlyByteBuf buf) {
        Pair[] values = (Pair[])Array.newInstance(Pair.class, 3);
        for (int i = 0; i < 3; ++i) {
            ConcurrentMap map = Maps.newConcurrentMap();
            int z = buf.m_130242_();
            for (int u = 0; u < z; ++u) {
                map.put(buf.m_130281_(), buf.m_130242_());
            }
            values[i] = new Pair((Object)map, (Object)buf.m_130242_());
        }
        return new BloodValuePacket(values);
    }

    public static void handle(BloodValuePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleBloodValuePacket(msg));
        ctx.setPacketHandled(true);
    }

    public Pair<Map<ResourceLocation, Integer>, Integer>[] getValues() {
        return this.values;
    }
}

