/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class AppearancePacket
implements IMessage {
    public final int entityId;
    public final String name;
    public final int[] data;

    static void encode(AppearancePacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entityId);
        buf.m_130070_(msg.name);
        buf.m_130130_(msg.data.length);
        for (int value : msg.data) {
            buf.m_130130_(value);
        }
    }

    static AppearancePacket decode(FriendlyByteBuf buf) {
        int entityId = buf.m_130242_();
        String newName = buf.m_130136_(15);
        int[] data = new int[buf.m_130242_()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = buf.m_130242_();
        }
        return new AppearancePacket(entityId, newName, data);
    }

    public static void handle(AppearancePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> VampirismMod.proxy.handleAppearancePacket((Player)ctx.getSender(), msg));
        ctx.setPacketHandled(true);
    }

    public AppearancePacket(int entityId, String newName, int ... data) {
        this.entityId = entityId;
        this.name = newName;
        this.data = data;
    }
}

