/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import de.teamlapen.vampirism.player.tasks.reward.ItemReward;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TaskRecipeCategory
implements IRecipeCategory<Task> {
    private final IDrawable background;
    private final IDrawable icon;

    public TaskRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(new ResourceLocation("jei", "textures/gui/slot.png"), 0, 0, 18, 18).setTextureSize(18, 18).addPadding(14, 90, 75, 75).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModItems.vampire_fang));
    }

    public void draw(Task task, @Nonnull PoseStack stack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        int x = 4;
        int y = 40;
        minecraft.f_91062_.m_92889_(stack, task.getTranslation(), 1.0f, 1.0f, Color.GRAY.getRGB());
        IPlayableFaction<?> f = task.getFaction();
        TranslatableComponent taskmasterComponent = f == null || f.getVillageData().getTaskMasterEntity() == null ? new TranslatableComponent("text.vampirism.faction_representative") : new TranslatableComponent(f.getVillageData().getTaskMasterEntity().m_20675_());
        TranslatableComponent text = new TranslatableComponent("text.vampirism.task.reward_obtain", new Object[]{taskmasterComponent});
        y += UtilLib.renderMultiLine(minecraft.f_91062_, stack, (Component)text, 160, x, y, Color.GRAY.getRGB());
        MutableComponent prerequisites = new TranslatableComponent("text.vampirism.task.prerequisites").m_130946_(":\n");
        TaskUnlocker[] unlockers = task.getUnlocker();
        if (unlockers.length > 0) {
            TextComponent newLine = new TextComponent("\n");
            for (TaskUnlocker u : unlockers) {
                prerequisites.m_7220_((Component)new TextComponent("- ")).m_7220_(u.getDescription()).m_7220_((Component)newLine);
            }
        } else {
            prerequisites.m_7220_((Component)new TranslatableComponent("text.vampirism.task.prerequisites.none"));
        }
        y += UtilLib.renderMultiLine(minecraft.f_91062_, stack, (Component)prerequisites, 160, x, y, Color.GRAY.getRGB());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public Class<? extends Task> getRecipeClass() {
        return Task.class;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("text.vampirism.task.reward");
    }

    @Nonnull
    public ResourceLocation getUid() {
        return VampirismJEIPlugin.TASK_RECIPE_UID;
    }

    public void setIngredients(Task recipe, @Nonnull IIngredients ingredients) {
        TaskReward reward = recipe.getReward();
        if (reward instanceof ItemReward) {
            ingredients.setOutputs(VanillaTypes.ITEM, ((ItemReward)reward).getAllPossibleRewards());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull Task recipe, IIngredients ingredients) {
        int craftOutputSlot = 0;
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        guiItemStackGroup.init(craftOutputSlot, false, 75, 14);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        guiItemStackGroup.set(craftOutputSlot, outputs.stream().flatMap(Collection::stream).collect(Collectors.toList()));
    }
}

