/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.modcompat.jei.JEIPotionMix;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.Objects;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PotionTableRecipeCategory
implements IRecipeCategory<JEIPotionMix> {
    private static final ResourceLocation backgroundLocation = new ResourceLocation("vampirism", "textures/gui/potion_table.png");
    private final Component localizedName = new TranslatableComponent(ModBlocks.potion_table.m_7705_());
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotDrawable;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated bubbles;
    private final IDrawableStatic blazeHeat;

    PotionTableRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.potion_table));
        this.background = guiHelper.drawableBuilder(backgroundLocation, 65, 6, 103, 73).addPadding(0, 33, 0, 25).build();
        this.slotDrawable = guiHelper.getSlotDrawable();
        BrewingBubblesTickTimer bubblesTickTimer = new BrewingBubblesTickTimer(guiHelper);
        this.bubbles = guiHelper.drawableBuilder(backgroundLocation, 185, 0, 12, 29).buildAnimated((ITickTimer)bubblesTickTimer, IDrawableAnimated.StartDirection.BOTTOM);
        this.blazeHeat = guiHelper.createDrawable(backgroundLocation, 176, 29, 18, 4);
        this.arrow = guiHelper.drawableBuilder(backgroundLocation, 176, 0, 9, 28).buildAnimated(400, IDrawableAnimated.StartDirection.TOP, false);
    }

    public void draw(JEIPotionMix recipe, @Nonnull PoseStack stack, double mouseX, double mouseY) {
        this.blazeHeat.draw(stack, 1, 35);
        this.bubbles.draw(stack, 3, 4);
        this.arrow.draw(stack, 80, 10);
        int y = 75;
        int x = 5;
        Minecraft minecraft = Minecraft.m_91087_();
        if (recipe.getOriginal().durable && recipe.getOriginal().concentrated) {
            minecraft.f_91062_.m_92889_(stack, HunterSkills.concentrated_durable_brewing.getName(), (float)x, (float)y, Color.GRAY.getRGB());
            Objects.requireNonNull(minecraft.f_91062_);
            y += 9;
        } else if (recipe.getOriginal().durable) {
            minecraft.f_91062_.m_92889_(stack, HunterSkills.durable_brewing.getName(), (float)x, (float)y, Color.GRAY.getRGB());
            Objects.requireNonNull(minecraft.f_91062_);
            y += 9;
        } else if (recipe.getOriginal().concentrated) {
            minecraft.f_91062_.m_92889_(stack, HunterSkills.concentrated_brewing.getName(), (float)x, (float)y, Color.GRAY.getRGB());
            Objects.requireNonNull(minecraft.f_91062_);
            y += 9;
        }
        if (recipe.getOriginal().master) {
            minecraft.f_91062_.m_92889_(stack, HunterSkills.master_brewer.getName(), (float)x, (float)y, Color.GRAY.getRGB());
            Objects.requireNonNull(minecraft.f_91062_);
            y += 9;
        }
        if (recipe.getOriginal().efficient) {
            minecraft.f_91062_.m_92889_(stack, HunterSkills.efficient_brewing.getName(), (float)x, (float)y, Color.GRAY.getRGB());
            Objects.requireNonNull(minecraft.f_91062_);
            y += 9;
        }
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public Class<? extends JEIPotionMix> getRecipeClass() {
        return JEIPotionMix.class;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return VampirismJEIPlugin.POTION_RECIPE_UID;
    }

    public void setIngredients(JEIPotionMix extendedPotionMix, IIngredients iIngredients) {
        iIngredients.setInputLists(VanillaTypes.ITEM, extendedPotionMix.getInputs());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)extendedPotionMix.getPotionOutput());
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull JEIPotionMix extendedPotionMix, @Nonnull IIngredients iIngredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 38, 52);
        itemStacks.init(1, true, 60, 52);
        itemStacks.init(2, true, 82, 52);
        itemStacks.init(3, true, 60, 1);
        itemStacks.init(4, true, 35, 9);
        itemStacks.init(5, false, 103, 13);
        itemStacks.setBackground(5, this.slotDrawable);
        itemStacks.set(iIngredients);
    }

    private static class BrewingBubblesTickTimer
    implements ITickTimer {
        private static final int[] BUBBLE_LENGTHS = new int[]{29, 23, 18, 13, 9, 5, 0};
        private final ITickTimer internalTimer;

        public BrewingBubblesTickTimer(IGuiHelper guiHelper) {
            this.internalTimer = guiHelper.createTickTimer(14, BUBBLE_LENGTHS.length - 1, false);
        }

        public int getMaxValue() {
            return BUBBLE_LENGTHS[0];
        }

        public int getValue() {
            int timerValue = this.internalTimer.getValue();
            return BUBBLE_LENGTHS[timerValue];
        }
    }
}

