/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class JEIPotionMix {
    private final List<List<ItemStack>> inputs;
    private final ItemStack potionOutput;
    private final ExtendedPotionMix original;

    public static Collection<JEIPotionMix> createFromMix(ExtendedPotionMix mix) {
        List<ItemStack> in1 = mix.reagent1.map(Ingredient::m_43908_).stream().flatMap(Arrays::stream).map(ItemStack::m_41777_).peek(s -> s.m_41764_(mix.reagent1Count)).filter(s -> !s.m_41619_()).collect(Collectors.toList());
        List<ItemStack> in2 = mix.reagent2.map(Ingredient::m_43908_).stream().flatMap(Arrays::stream).map(ItemStack::m_41777_).peek(s -> s.m_41764_(mix.reagent2Count)).filter(s -> !s.m_41619_()).collect(Collectors.toList());
        ArrayList<JEIPotionMix> recipes = new ArrayList<JEIPotionMix>(3);
        recipes.add(JEIPotionMix.build(mix, Items.f_42589_, (Potion)mix.input.get(), (Potion)mix.output.get(), in1, in2));
        if (((Potion)mix.output.get()).m_43488_().stream().noneMatch(s -> s.m_19544_().m_19483_() != MobEffectCategory.HARMFUL)) {
            recipes.add(JEIPotionMix.build(mix, Items.f_42739_, (Potion)mix.input.get(), (Potion)mix.output.get(), in1, in2));
            recipes.add(JEIPotionMix.build(mix, Items.f_42736_, (Potion)mix.input.get(), (Potion)mix.output.get(), in1, in2));
        }
        return recipes;
    }

    private static JEIPotionMix build(ExtendedPotionMix mix, Item base, Potion in, Potion out, List<ItemStack> in1, List<ItemStack> in2) {
        ArrayList<List<ItemStack>> ingredientList = new ArrayList<List<ItemStack>>();
        ItemStack potionIn = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)base), (Potion)in);
        ItemStack potionOut = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)base), (Potion)out);
        List<ItemStack> potionInList = Collections.singletonList(potionIn);
        ingredientList.add(potionInList);
        ingredientList.add(potionInList);
        ingredientList.add(potionInList);
        ingredientList.add(in1);
        ingredientList.add(in2);
        return new JEIPotionMix(mix, ingredientList, potionOut);
    }

    private JEIPotionMix(ExtendedPotionMix original, List<List<ItemStack>> inputs, ItemStack potionOutput) {
        this.inputs = inputs;
        this.potionOutput = potionOutput;
        this.original = original;
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public ExtendedPotionMix getOriginal() {
        return this.original;
    }

    public ItemStack getPotionOutput() {
        return this.potionOutput;
    }
}

