/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.inventory.recipes.AlchemicalCauldronRecipe;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class AlchemicalCauldronRecipeCategory
implements IRecipeCategory<AlchemicalCauldronRecipe> {
    private static final ResourceLocation location = new ResourceLocation("vampirism", "textures/gui/alchemical_cauldron.png");
    private final Component localizedName = new TranslatableComponent(ModBlocks.alchemical_cauldron.m_7705_());
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated flame;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated bubbles;

    AlchemicalCauldronRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.alchemical_cauldron));
        this.background = guiHelper.drawableBuilder(location, 38, 10, 120, 70).addPadding(0, 33, 0, 0).build();
        IDrawableStatic flameDrawable = guiHelper.createDrawable(location, 176, 0, 14, 14);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 300, IDrawableAnimated.StartDirection.TOP, true);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, 176, 14, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        IDrawableStatic bubblesDrawable = guiHelper.createDrawable(location, 176, 31, 12, 29);
        this.bubbles = guiHelper.createAnimatedDrawable(bubblesDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public void draw(AlchemicalCauldronRecipe recipe, @Nonnull PoseStack stack, double mouseX, double mouseY) {
        this.flame.draw(stack, 19, 27);
        this.arrow.draw(stack, 41, 25);
        this.bubbles.draw(stack, 104, 19);
        Minecraft minecraft = Minecraft.m_91087_();
        int x = 0;
        int y = 65;
        if (recipe.getRequiredLevel() > 1) {
            TranslatableComponent level = new TranslatableComponent("gui.vampirism.alchemical_cauldron.level", new Object[]{recipe.getRequiredLevel()});
            minecraft.f_91062_.m_92889_(stack, (Component)level, (float)x, (float)y, Color.GRAY.getRGB());
            Objects.requireNonNull(minecraft.f_91062_);
            y += 9 + 2;
        }
        if (recipe.getRequiredSkills().length > 0) {
            TranslatableComponent skillText = new TranslatableComponent("gui.vampirism.alchemical_cauldron.skill", new Object[]{" "});
            for (ISkill<?> s : recipe.getRequiredSkills()) {
                skillText.m_7220_(s.getName()).m_130946_(" ");
            }
            y += UtilLib.renderMultiLine(minecraft.f_91062_, stack, (Component)skillText, 132, x, y, Color.GRAY.getRGB());
        }
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public Class<? extends AlchemicalCauldronRecipe> getRecipeClass() {
        return AlchemicalCauldronRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public ResourceLocation getUid() {
        return VampirismJEIPlugin.ALCHEMICAL_CAULDRON_RECIPE_UID;
    }

    public void setIngredients(AlchemicalCauldronRecipe recipe, IIngredients iIngredients) {
        ArrayList ingredients = new ArrayList();
        recipe.getFluid().ifRight(fluidStack -> ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{fluidStack.getFluid().m_6859_()})));
        recipe.getFluid().ifLeft(ingredients::add);
        ingredients.addAll(recipe.m_7527_());
        iIngredients.setInputIngredients(ingredients);
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull AlchemicalCauldronRecipe recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        guiItemStackGroup.init(0, false, 77, 23);
        guiItemStackGroup.init(1, true, 5, 6);
        guiItemStackGroup.init(2, true, 29, 6);
        guiItemStackGroup.set(ingredients);
    }
}

