/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide;

import de.maxanier.guideapi.api.IGuideBook;
import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.IRecipeRenderer;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.BookBinder;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.BookHelper;
import de.maxanier.guideapi.api.util.PageHelper;
import de.maxanier.guideapi.category.CategoryItemStack;
import de.maxanier.guideapi.entry.EntryItemStack;
import de.maxanier.guideapi.entry.EntryResourceLocation;
import de.maxanier.guideapi.page.PageEntity;
import de.maxanier.guideapi.page.PageHolderWithLinks;
import de.maxanier.guideapi.page.PageIRecipe;
import de.maxanier.guideapi.page.PageImage;
import de.maxanier.guideapi.page.PageText;
import de.maxanier.guideapi.page.PageTextImage;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import de.teamlapen.vampirism.blocks.AltarPillarBlock;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTasks;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.inventory.recipes.AlchemicalCauldronRecipe;
import de.teamlapen.vampirism.inventory.recipes.ShapedWeaponTableRecipe;
import de.teamlapen.vampirism.inventory.recipes.ShapelessWeaponTableRecipe;
import de.teamlapen.vampirism.items.BloodBottleItem;
import de.teamlapen.vampirism.modcompat.guide.EntryText;
import de.teamlapen.vampirism.modcompat.guide.GuideHelper;
import de.teamlapen.vampirism.modcompat.guide.VampirismGuideBookCategoriesEvent;
import de.teamlapen.vampirism.modcompat.guide.pages.PagePotionTableMix;
import de.teamlapen.vampirism.modcompat.guide.pages.PageTable;
import de.teamlapen.vampirism.modcompat.guide.recipes.AlchemicalCauldronRecipeRenderer;
import de.teamlapen.vampirism.modcompat.guide.recipes.ShapedWeaponTableRecipeRenderer;
import de.teamlapen.vampirism.modcompat.guide.recipes.ShapelessWeaponTableRecipeRenderer;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.player.vampire.VampireLevelingConf;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@de.maxanier.guideapi.api.GuideBook
public class GuideBook
implements IGuideBook {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String IMAGE_BASE = "vampirismguide:textures/images/";
    private static Book guideBook;

    static void buildCategories(List<CategoryAbstract> categories) {
        LOGGER.debug("Building content");
        long start = System.currentTimeMillis();
        BookHelper helper = new BookHelper.Builder("vampirism").setBaseKey("guide.vampirism").setLocalizer(GuideBook::translateComponent).setRecipeRendererSupplier(GuideBook::getRenderer).build();
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildOverview(helper), (Component)GuideBook.translateComponent("guide.vampirism.overview.title", new Object[0]), new ItemStack((ItemLike)ModItems.vampire_fang)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildVampire(helper), (Component)GuideBook.translateComponent("guide.vampirism.vampire.title", new Object[0]), BloodBottleItem.getStackWithDamage(9)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildHunter(helper), (Component)GuideBook.translateComponent("guide.vampirism.hunter.title", new Object[0]), new ItemStack((ItemLike)ModItems.human_heart)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildCreatures(helper), (Component)GuideBook.translateComponent("guide.vampirism.entity.title", new Object[0]), new ItemStack((ItemLike)Items.f_42681_)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildWorld(helper), (Component)GuideBook.translateComponent("guide.vampirism.world.title", new Object[0]), new ItemStack((ItemLike)ModBlocks.cursed_earth)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildItems(helper), (Component)GuideBook.translateComponent("guide.vampirism.items.title", new Object[0]), new ItemStack((ItemLike)Items.f_42410_)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildBlocks(helper), (Component)GuideBook.translateComponent("guide.vampirism.blocks.title", new Object[0]), new ItemStack((ItemLike)ModBlocks.castle_block_dark_brick)));
        categories.add((CategoryAbstract)new CategoryItemStack(GuideBook.buildChangelog(helper), (Component)GuideBook.translateComponent("guide.vampirism.changelog.title", new Object[0]), new ItemStack((ItemLike)Items.f_42614_)));
        MinecraftForge.EVENT_BUS.post((Event)new VampirismGuideBookCategoriesEvent(categories));
        helper.registerLinkablePages(categories);
        LOGGER.debug("Built content in {} ms", (Object)(System.currentTimeMillis() - start));
    }

    @Nullable
    private static IRecipeRenderer getRenderer(Recipe<?> recipe) {
        IRecipeRenderer recipeRenderer = PageIRecipe.getRenderer(recipe);
        if (recipeRenderer != null) {
            return recipeRenderer;
        }
        if (recipe instanceof ShapedWeaponTableRecipe) {
            return new ShapedWeaponTableRecipeRenderer((ShapedWeaponTableRecipe)recipe);
        }
        if (recipe instanceof ShapelessWeaponTableRecipe) {
            return new ShapelessWeaponTableRecipeRenderer((ShapelessWeaponTableRecipe)recipe);
        }
        if (recipe instanceof AlchemicalCauldronRecipe) {
            return new AlchemicalCauldronRecipeRenderer((AlchemicalCauldronRecipe)recipe);
        }
        LOGGER.warn("Did not find renderer for recipe {}", recipe);
        return null;
    }

    private static Map<ResourceLocation, EntryAbstract> buildOverview(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.overview.";
        ArrayList<IPage> introPages = new ArrayList<IPage>();
        introPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "intro.text", new Object[0])));
        entries.put(new ResourceLocation(base + "intro"), (EntryAbstract)new EntryText(introPages, (Component)GuideBook.translateComponent(base + "intro", new Object[0])));
        ArrayList<IPage> gettingStartedPages = new ArrayList<IPage>();
        PageText p = new PageText((FormattedText)GuideBook.translateComponent(base + "getting_started.text", new Object[0]));
        p = new PageHolderWithLinks(helper, (IPage)p).addLink("guide.vampirism.vampire.getting_started").addLink("guide.vampirism.hunter.getting_started");
        gettingStartedPages.add((IPage)p);
        entries.put(new ResourceLocation(base + "getting_started"), (EntryAbstract)new EntryText(gettingStartedPages, (Component)GuideBook.translateComponent(base + "getting_started", new Object[0])));
        ArrayList<IPage> configPages = new ArrayList<IPage>();
        configPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "config.text", new Object[0])));
        configPages.addAll(PageHelper.pagesForLongText((FormattedText)FormattedText.m_130773_((FormattedText[])new FormattedText[]{GuideBook.translateComponent(base + "config.general.text", new Object[0]), GuideBook.translateComponent(base + "config.general.examples", new Object[0])})));
        configPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "config.balance.text", new Object[0])));
        entries.put(new ResourceLocation(base + "config"), (EntryAbstract)new EntryText(configPages, (Component)GuideBook.translateComponent(base + "config", new Object[0])));
        ArrayList<IPage> troublePages = new ArrayList<IPage>();
        troublePages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "trouble.text", new Object[0])));
        helper.addLinks(troublePages, new Object[]{new PageHolderWithLinks.URLLink((Component)GuideBook.translateComponent(base + "trouble", new Object[0]), URI.create("https://github.com/TeamLapen/Vampirism/wiki/Troubleshooting"))});
        entries.put(new ResourceLocation(base + "trouble"), (EntryAbstract)new EntryText(troublePages, (Component)GuideBook.translateComponent(base + "trouble", new Object[0])));
        ArrayList<IPage> devPages = new ArrayList<IPage>();
        PageHolderWithLinks.URLLink helpLink = new PageHolderWithLinks.URLLink((Component)new TextComponent("How to help"), URI.create("https://github.com/TeamLapen/Vampirism/wiki#how-you-can-help"));
        devPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "dev.text", new Object[0])), new Object[]{helpLink}));
        entries.put(new ResourceLocation(base + "dev"), (EntryAbstract)new EntryText(devPages, (Component)GuideBook.translateComponent(base + "dev", new Object[0])));
        ArrayList<IPage> supportPages = new ArrayList<IPage>();
        supportPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "support.text", new Object[0])));
        PageHolderWithLinks.URLLink linkCurseForge = new PageHolderWithLinks.URLLink("CurseForge", URI.create("https://minecraft.curseforge.com/projects/vampirism-become-a-vampire"));
        helper.addLinks(supportPages, new Object[]{linkCurseForge, new ResourceLocation(base + "dev")});
        entries.put(new ResourceLocation(base + "support"), (EntryAbstract)new EntryText(supportPages, (Component)GuideBook.translateComponent(base + "support", new Object[0])));
        ArrayList<IPage> creditsPages = new ArrayList<IPage>();
        String lang = VampLib.proxy.getActiveLanguage();
        String credits = "\u00a7lDeveloper:\u00a7r\nMaxanier\nCheaterpaul\n\u00a7lThanks to:\u00a7r\nMistadon\nwildbill22\n1LiterZinalco\nAlis\ndimensionpainter\nS_olace\nPiklach\n\n\u00a7lTranslators:\u00a7r\n\u00a7b" + lang + "\u00a7r\n" + GuideBook.translateComponent("text.vampirism.translators", new Object[0]).getString();
        creditsPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(credits, new Object[0])));
        entries.put(new ResourceLocation(base + "credits"), (EntryAbstract)new EntryText(creditsPages, (Component)GuideBook.translateComponent(base + "credits", new Object[0])));
        return entries;
    }

    private static String loc(Block b) {
        return UtilLib.translate(b.m_7705_(), new Object[0]);
    }

    private static String loc(Item i) {
        return UtilLib.translate(i.m_5524_(), new Object[0]);
    }

    private static Map<ResourceLocation, EntryAbstract> buildVampire(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.vampire.";
        ArrayList<IPage> gettingStarted = new ArrayList<IPage>();
        gettingStarted.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "getting_started.become", new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "getting_started.as_vampire", new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "getting_started.zombie", new Object[0])));
        gettingStarted.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "getting_started.blood", new TranslatableComponent(ModKeys.SUCK.m_90865_()))));
        gettingStarted.addAll(PageHelper.pagesForLongText((FormattedText)FormattedText.m_130773_((FormattedText[])new FormattedText[]{GuideBook.translateComponent(base + "getting_started.level", new Object[0]), GuideBook.translateComponent(base + "getting_started.level2", new Object[0])})));
        entries.put(new ResourceLocation(base + "getting_started"), (EntryAbstract)new EntryText(gettingStarted, (Component)GuideBook.translateComponent(base + "getting_started", new Object[0])));
        ArrayList<IPage> bloodPages = new ArrayList<IPage>();
        bloodPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "blood.text", GuideBook.loc(ModItems.blood_bottle), GuideBook.loc(Items.f_42590_))));
        bloodPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "blood.storage", GuideBook.loc((Block)ModBlocks.blood_container))), new Object[]{new ResourceLocation("guide.vampirism.blocks.blood_container")}));
        bloodPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "blood.biteable_creatures", new Object[0])), new Object[]{new PageHolderWithLinks.URLLink("Biteable Creatures", URI.create("https://github.com/TeamLapen/Vampirism/wiki/Biteable-Creatures"))}));
        entries.put(new ResourceLocation(base + "blood"), (EntryAbstract)new EntryText(bloodPages, (Component)GuideBook.translateComponent(base + "blood", new Object[0])));
        VampireLevelingConf levelingConf = VampireLevelingConf.getInstance();
        ArrayList<IPage> levelingPages = new ArrayList<IPage>();
        levelingPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "leveling.intro", new Object[0])));
        String altarOfInspiration = "\u00a7l" + GuideBook.loc((Block)ModBlocks.altar_inspiration) + "\u00a7r\n\u00a7o" + GuideBook.translate(base + "leveling.inspiration.reach", new Object[0]) + "\u00a7r\n";
        altarOfInspiration = altarOfInspiration + GuideBook.translate(base + "leveling.inspiration.text", new Object[0]) + "\n";
        altarOfInspiration = altarOfInspiration + GuideBook.translate(base + "leveling.inspiration.requirements", levelingConf.getRequiredBloodForAltarInspiration(2), levelingConf.getRequiredBloodForAltarInspiration(3), levelingConf.getRequiredBloodForAltarInspiration(4));
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)new TextComponent(altarOfInspiration)), new Object[]{new ResourceLocation("guide.vampirism.blocks.altar_inspiration")}));
        String altarOfInfusion = "\u00a7l" + GuideBook.loc((Block)ModBlocks.altar_infusion) + "\u00a7r\n\u00a7o" + GuideBook.translate(base + "leveling.infusion.reach", new Object[0]) + "\u00a7r\n";
        altarOfInfusion = altarOfInfusion + GuideBook.translate(base + "leveling.infusion.intro", GuideBook.loc((Block)ModBlocks.altar_infusion), GuideBook.loc(ModBlocks.altar_pillar), GuideBook.loc(ModBlocks.altar_tip));
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)new TextComponent(altarOfInfusion)), new Object[]{new ResourceLocation("guide.vampirism.blocks.altar_infusion")}));
        StringBuilder blocks = new StringBuilder();
        for (AltarPillarBlock.EnumPillarType t : AltarPillarBlock.EnumPillarType.values()) {
            if (t == AltarPillarBlock.EnumPillarType.NONE) continue;
            blocks.append(GuideBook.translate(t.fillerBlock.m_7705_(), new Object[0])).append("(").append(t.getValue()).append("),");
        }
        levelingPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "leveling.infusion.structure", blocks.toString())));
        String items = GuideBook.loc(ModItems.human_heart) + ", " + GuideBook.loc(ModItems.pure_blood_0) + ", " + GuideBook.loc(ModItems.vampire_book);
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "leveling.infusion.items", items)), new Object[]{new ResourceLocation("guide.vampirism.items.human_heart"), new ResourceLocation("guide.vampirism.items.pure_blood_0"), new ResourceLocation("guide.vampirism.items.vampire_book")}));
        PageTable.Builder requirementsBuilder = new PageTable.Builder(5);
        requirementsBuilder.addUnlocLine("text.vampirism.level_short", base + "leveling.infusion.req.structure_points", ModItems.pure_blood_0.m_5524_(), base + "leveling.infusion.req.heart", base + "leveling.infusion.req.book");
        requirementsBuilder.addLine("5", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(5), "0", "5", "1");
        requirementsBuilder.addLine("6", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(6), "1 Purity(1)", "5", "1");
        requirementsBuilder.addLine("7", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(7), "1 Purity(1)", "10", "1");
        requirementsBuilder.addLine("8", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(8), "1 Purity(2)", "10", "1");
        requirementsBuilder.addLine("9", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(9), "1 Purity(2)", "10", "1");
        requirementsBuilder.addLine("10", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(10), "1 Purity(3)", "15", "1");
        requirementsBuilder.addLine("11", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(11), "1 Purity(3)", "15", "1");
        requirementsBuilder.addLine("12", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(12), "1 Purity(4)", "20", "1");
        requirementsBuilder.addLine("13", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(13), "2 Purity(4)", "20", "1");
        requirementsBuilder.addLine("14", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(14), "2 Purity(5)", "25", "1");
        requirementsBuilder.setHeadline(GuideBook.translateComponent(base + "leveling.infusion.req", new Object[0]));
        PageHolderWithLinks requirementTable = new PageHolderWithLinks(helper, (IPage)requirementsBuilder.build());
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.human_heart"));
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.vampire_book"));
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.pure_blood_0"));
        levelingPages.add((IPage)requirementTable);
        levelingPages.add((IPage)new PageTextImage((FormattedText)GuideBook.translateComponent(base + "leveling.infusion.image1", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion1.png"), false));
        levelingPages.add((IPage)new PageTextImage((FormattedText)GuideBook.translateComponent(base + "leveling.infusion.image2", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion2.png"), false));
        levelingPages.add((IPage)new PageTextImage((FormattedText)GuideBook.translateComponent(base + "leveling.infusion.image3", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion3.png"), false));
        levelingPages.add((IPage)new PageTextImage((FormattedText)GuideBook.translateComponent(base + "leveling.infusion.image4", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion4.png"), false));
        levelingPages.add((IPage)new PageTextImage((FormattedText)GuideBook.translateComponent(base + "leveling.infusion.image5", new Object[0]), new ResourceLocation("vampirismguide:textures/images/infusion5.png"), false));
        entries.put(new ResourceLocation(base + "leveling"), (EntryAbstract)new EntryText(levelingPages, (Component)GuideBook.translateComponent(base + "leveling", new Object[0])));
        ArrayList<IPage> skillPages = new ArrayList<IPage>();
        skillPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "skills.text", new Object[0])), new Object[]{new ResourceLocation(base + "vampirism_menu")}));
        skillPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "skills.actions", UtilLib.translate(ModKeys.ACTION.m_90865_(), new Object[0]))));
        skillPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent("guide.vampirism.skills.bind_action", new Object[0])));
        skillPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "skills.actions2", new Object[0])));
        skillPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "skills.refinements", new Object[0])), new Object[]{new ResourceLocation("guide.vampirism.items.accessories")}));
        entries.put(new ResourceLocation(base + "skills"), (EntryAbstract)new EntryText(skillPages, (Component)GuideBook.translateComponent(base + "skills", new Object[0])));
        ArrayList<IPage> armorPages = new ArrayList<IPage>(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "armor.text", new Object[0])), new Object[]{new ResourceLocation("guide.vampirism.items.accessories")}));
        entries.put(new ResourceLocation(base + "armor"), (EntryAbstract)new EntryText(armorPages, (Component)GuideBook.translateComponent(base + "armor", new Object[0])));
        ArrayList<IPage> dbnoPages = new ArrayList<IPage>(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "dbno.text", ModEffects.neonatal.m_19482_())));
        entries.put(new ResourceLocation(base + "dbno"), (EntryAbstract)new EntryText(dbnoPages, (Component)GuideBook.translateComponent(base + "dbno", new Object[0])));
        ArrayList<IPage> lordPages = new ArrayList<IPage>();
        lordPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "lord.text", ModEntities.task_master_vampire.m_20676_().getString(), VReference.VAMPIRE_FACTION.getLordTitle(1, false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(1, true).getString(), VReference.VAMPIRE_FACTION.getLordTitle(VReference.VAMPIRE_FACTION.getHighestLordLevel(), false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(VReference.VAMPIRE_FACTION.getHighestLordLevel(), true).getString())), new Object[]{new ResourceLocation("guide.vampirism.entity.taskmaster")}));
        PageTable.Builder lordTitleBuilder = new PageTable.Builder(3).setHeadline(GuideBook.translateComponent(base + "lord.titles", new Object[0]));
        lordTitleBuilder.addUnlocLine("text.vampirism.level", "text.vampirism.title", "text.vampirism.title");
        lordTitleBuilder.addLine(1, VReference.VAMPIRE_FACTION.getLordTitle(1, false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(1, true).getString());
        lordTitleBuilder.addLine(2, VReference.VAMPIRE_FACTION.getLordTitle(2, false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(2, true).getString());
        lordTitleBuilder.addLine(3, VReference.VAMPIRE_FACTION.getLordTitle(3, false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(3, true).getString());
        lordTitleBuilder.addLine(4, VReference.VAMPIRE_FACTION.getLordTitle(4, false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(4, true).getString());
        lordTitleBuilder.addLine(5, VReference.VAMPIRE_FACTION.getLordTitle(5, false).getString(), VReference.VAMPIRE_FACTION.getLordTitle(5, true).getString());
        lordPages.add((IPage)lordTitleBuilder.build());
        lordPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "lord.minion", GuideBook.loc(ModItems.vampire_minion_binding), GuideBook.loc(ModItems.vampire_minion_upgrade_simple), GuideBook.loc(ModItems.vampire_minion_upgrade_enhanced), GuideBook.loc(ModItems.vampire_minion_upgrade_special))), new Object[]{new ResourceLocation("guide.vampirism.items.vampire_minion_binding")}));
        lordPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent("guide.vampirism.common.minion_control", GuideBook.translate(ModKeys.MINION.m_90865_(), new Object[0]), GuideBook.translate("text.vampirism.minion.call_single", new Object[0]), GuideBook.translate("text.vampirism.minion.respawn", new Object[0]))), new Object[0]));
        entries.put(new ResourceLocation(base + "lord"), (EntryAbstract)new EntryText(lordPages, (Component)new TranslatableComponent(base + "lord")));
        ArrayList<IPage> vampirismMenu = new ArrayList<IPage>(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent("guide.vampirism.overview.vampirism_menu.text", GuideBook.translateComponent(ModKeys.VAMPIRISM_MENU.m_90865_(), new Object[0])).m_7220_((Component)GuideBook.translateComponent("guide.vampirism.overview.vampirism_menu.text_vampire", GuideBook.translateComponent("guide.vampirism.items.accessories", new Object[0])))));
        entries.put(new ResourceLocation(base + "vampirism_menu"), (EntryAbstract)new EntryText(vampirismMenu, (Component)GuideBook.translateComponent("guide.vampirism.overview.vampirism_menu", new Object[0])));
        ArrayList<IPage> unvampirePages = new ArrayList<IPage>();
        unvampirePages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "unvampire.text", GuideBook.loc(ModBlocks.altar_cleansing))));
        entries.put(new ResourceLocation(base + "unvampire"), (EntryAbstract)new EntryText(unvampirePages, (Component)GuideBook.translateComponent(base + "unvampire", new Object[0])));
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildHunter(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.hunter.";
        ArrayList<IPage> gettingStarted = new ArrayList<IPage>();
        MutableComponent become = GuideBook.translateComponent(base + "getting_started.become", GuideBook.translateComponent(ModEntities.hunter_trainer.m_20675_(), new Object[0]), GuideBook.loc(ModItems.injection_garlic));
        gettingStarted.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)become), new Object[]{new ResourceLocation("guide.vampirism.items.injection_empty")}));
        gettingStarted.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/hunter_trainer.png")));
        gettingStarted.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "getting_started.as_hunter", new Object[0])));
        entries.put(new ResourceLocation(base + "getting_started"), (EntryAbstract)new EntryText(gettingStarted, (Component)GuideBook.translateComponent(base + "getting_started", new Object[0])));
        HunterLevelingConf levelingConf = HunterLevelingConf.instance();
        ArrayList<IPage> levelingPages = new ArrayList<IPage>();
        levelingPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "leveling.intro", new Object[0])));
        String train1 = "\u00a7l" + GuideBook.translate(base + "leveling.to_reach", "2-4") + "\u00a7r\n";
        train1 = train1 + GuideBook.translate(base + "leveling.train1.text", levelingConf.getVampireBloodCountForBasicHunter(2), levelingConf.getVampireBloodCountForBasicHunter(3), levelingConf.getVampireBloodCountForBasicHunter(4));
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)new TextComponent(train1)), new Object[]{new ResourceLocation("guide.vampirism.items.stake"), new ResourceLocation("guide.vampirism.items.vampire_blood_bottle")}));
        String train2 = "\u00a7l" + GuideBook.translate(base + "leveling.to_reach", "5+") + "\u00a7r\n";
        train2 = train2 + GuideBook.translate(base + "leveling.train2.text", GuideBook.loc(ModBlocks.hunter_table), GuideBook.loc(ModBlocks.weapon_table), GuideBook.loc((Block)ModBlocks.potion_table), GuideBook.loc((Block)ModBlocks.alchemical_cauldron));
        levelingPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)new TranslatableComponent(train2)), new Object[]{new ResourceLocation("guide.vampirism.blocks.hunter_table"), new ResourceLocation("guide.vampirism.blocks.weapon_table"), new ResourceLocation("guide.vampirism.blocks.alchemical_cauldron"), new ResourceLocation("guide.vampirism.blocks.potion_table")}));
        PageTable.Builder builder = new PageTable.Builder(4);
        builder.addUnlocLine("text.vampirism.level", base + "leveling.train2.fang", GuideBook.loc(ModItems.pure_blood_0), GuideBook.loc(ModItems.vampire_book));
        for (int i = levelingConf.TABLE_MIN_LEVEL; i <= levelingConf.TABLE_MAX_LEVEL; ++i) {
            int[] req = levelingConf.getItemRequirementsForTable(i);
            Object pure = "";
            if (req[1] > 0) {
                pure = req[1] + " Purity(" + (req[2] + 1) + ")";
            }
            builder.addLine(i, req[0], pure, req[3]);
        }
        builder.setHeadline(GuideBook.translateComponent(base + "leveling.train2.req", new Object[0]));
        PageHolderWithLinks requirementsTable = new PageHolderWithLinks(helper, (IPage)builder.build());
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.vampire_fang"));
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.pure_blood_0"));
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.vampire_book"));
        levelingPages.add((IPage)requirementsTable);
        entries.put(new ResourceLocation(base + "leveling"), (EntryAbstract)new EntryText(levelingPages, (Component)GuideBook.translateComponent(base + "leveling", new Object[0])));
        ArrayList<IPage> skillPages = new ArrayList<IPage>();
        skillPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "skills.intro", new Object[0])), new Object[]{new ResourceLocation(base + "vampirism_menu")}));
        Object disguise = String.format("\u00a7l%s\u00a7r\n", HunterActions.disguise_hunter.getName().getString());
        disguise = (String)disguise + GuideBook.translate(base + "skills.disguise.text", ModKeys.ACTION.m_90865_());
        skillPages.addAll(PageHelper.pagesForLongText((FormattedText)new TextComponent((String)disguise)));
        Object weaponTable = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc(ModBlocks.weapon_table));
        weaponTable = (String)weaponTable + GuideBook.translate(base + "skills.weapon_table.text", new Object[0]);
        skillPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)new TextComponent((String)weaponTable)), new Object[]{new ResourceLocation("guide.vampirism.blocks.weapon_table")}));
        entries.put(new ResourceLocation(base + "skills"), (EntryAbstract)new EntryText(skillPages, (Component)GuideBook.translateComponent(base + "skills", new Object[0])));
        Object potionTable = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc((Block)ModBlocks.potion_table));
        potionTable = (String)potionTable + GuideBook.translate(base + "skills.potion_table.text", new Object[0]);
        ArrayList<IPage> potionTablePages = new ArrayList<IPage>(PageHelper.pagesForLongText((FormattedText)new TextComponent((String)potionTable)));
        potionTablePages.addAll(Arrays.asList(GuideBook.generatePotionMixes()));
        skillPages.addAll(helper.addLinks(potionTablePages, new Object[]{new ResourceLocation("guide.vampirism.blocks.potion_table")}));
        entries.put(new ResourceLocation(base + "skills"), (EntryAbstract)new EntryText(skillPages, (Component)new TranslatableComponent(base + "skills")));
        ArrayList<IPage> vampSlayerPages = new ArrayList<IPage>();
        vampSlayerPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "vamp_slayer.intro", new Object[0])));
        Object garlic = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc(ModItems.item_garlic));
        garlic = (String)garlic + GuideBook.translate(base + "vamp_slayer.garlic", new Object[0]) + "\n" + GuideBook.translate(base + "vamp_slayer.garlic2", new Object[0]) + "\n" + GuideBook.translate(base + "vamp_slayer.garlic.diffuser", new Object[0]);
        vampSlayerPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)new TextComponent((String)garlic)), new Object[]{new ResourceLocation("guide.vampirism.blocks.garlic_diffuser")}));
        Object holyWater = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc(ModItems.holy_water_bottle_normal));
        holyWater = (String)holyWater + GuideBook.translate(base + "vamp_slayer.holy_water", new Object[0]);
        vampSlayerPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)new TextComponent((String)holyWater)), new Object[]{new ResourceLocation("guide.vampirism.items.holy_water_bottle")}));
        Object fire = String.format("\u00a7l%s\u00a7r\n", GuideBook.loc(Blocks.f_50083_));
        fire = (String)fire + GuideBook.translate(base + "vamp_slayer.fire", new Object[0]);
        vampSlayerPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)new TextComponent((String)fire)), new Object[]{new ResourceLocation("guide.vampirism.items.item_alchemical_fire"), new ResourceLocation("guide.vampirism.items.crossbow_arrow_normal")}));
        entries.put(new ResourceLocation(base + "vamp_slayer"), (EntryAbstract)new EntryText(vampSlayerPages, (Component)GuideBook.translateComponent(base + "vamp_slayer", new Object[0])));
        ArrayList<IPage> lordPages = new ArrayList<IPage>();
        lordPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "lord.text", ModEntities.task_master_hunter.m_20676_().getString(), VReference.HUNTER_FACTION.getLordTitle(1, false).getString(), VReference.HUNTER_FACTION.getLordTitle(VReference.HUNTER_FACTION.getHighestLordLevel(), false).getString())), new Object[]{new ResourceLocation("guide.vampirism.entity.taskmaster")}));
        PageTable.Builder lordTitleBuilder = new PageTable.Builder(2);
        lordTitleBuilder.setHeadline(GuideBook.translateComponent(base + "lord.titles", new Object[0]));
        lordTitleBuilder.addUnlocLine("text.vampirism.level", "text.vampirism.title");
        lordTitleBuilder.addLine(1, VReference.HUNTER_FACTION.getLordTitle(1, false).getString());
        lordTitleBuilder.addLine(2, VReference.HUNTER_FACTION.getLordTitle(2, false).getString());
        lordTitleBuilder.addLine(3, VReference.HUNTER_FACTION.getLordTitle(3, false).getString());
        lordTitleBuilder.addLine(4, VReference.HUNTER_FACTION.getLordTitle(4, false).getString());
        lordTitleBuilder.addLine(5, VReference.HUNTER_FACTION.getLordTitle(5, false).getString());
        lordPages.add((IPage)lordTitleBuilder.build());
        lordPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "lord.minion", GuideBook.loc(ModItems.hunter_minion_equipment), GuideBook.loc(ModItems.hunter_minion_upgrade_simple), GuideBook.loc(ModItems.hunter_minion_upgrade_enhanced), GuideBook.loc(ModItems.hunter_minion_upgrade_special))), new Object[]{new ResourceLocation("guide.vampirism.items.hunter_minion_equipment")}));
        lordPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent("guide.vampirism.common.minion_control", GuideBook.translate(ModKeys.MINION.m_90865_(), new Object[0]), GuideBook.translate("text.vampirism.minion.call_single", new Object[0]), GuideBook.translate("text.vampirism.minion.respawn", new Object[0]))), new Object[0]));
        entries.put(new ResourceLocation(base + "lord"), (EntryAbstract)new EntryText(lordPages, (Component)new TranslatableComponent(base + "lord")));
        ArrayList<IPage> vampirismMenu = new ArrayList<IPage>(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent("guide.vampirism.overview.vampirism_menu.text", GuideBook.translate(ModKeys.VAMPIRISM_MENU.m_90865_(), new Object[0]))));
        entries.put(new ResourceLocation(base + "vampirism_menu"), (EntryAbstract)new EntryText(vampirismMenu, (Component)GuideBook.translateComponent("guide.vampirism.overview.vampirism_menu", new Object[0])));
        ArrayList<IPage> unHunterPages = new ArrayList<IPage>();
        unHunterPages.addAll(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "unhunter.text", GuideBook.loc(ModItems.injection_sanguinare), GuideBook.loc(ModBlocks.med_chair))), new Object[]{new ResourceLocation("guide.vampirism.items.injection_empty"), new ResourceLocation("guide.vampirism.blocks.item_med_chair")}));
        entries.put(new ResourceLocation(base + "unhunter"), (EntryAbstract)new EntryText(unHunterPages, (Component)GuideBook.translateComponent(base + "unhunter", new Object[0])));
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildCreatures(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.entity.";
        ArrayList<IPage> generalPages = new ArrayList<IPage>(PageHelper.pagesForLongText((FormattedText)FormattedText.m_130773_((FormattedText[])new FormattedText[]{GuideBook.translateComponent(base + "general.text", new Object[0]), GuideBook.translateComponent(base + "general.text2", new Object[0])})));
        entries.put(new ResourceLocation(base + "general"), (EntryAbstract)new EntryText(generalPages, (Component)GuideBook.translateComponent(base + "general", new Object[0])));
        ArrayList<IPage> hunterPages = new ArrayList<IPage>();
        hunterPages.add((IPage)new PageEntity(world -> {
            BasicHunterEntity entity = (BasicHunterEntity)ModEntities.hunter.m_20615_(world);
            entity.setEntityLevel(1);
            return entity;
        }));
        hunterPages.add((IPage)new PageEntity(world -> {
            BasicHunterEntity entity = (BasicHunterEntity)ModEntities.hunter.m_20615_(world);
            entity.setEntityLevel(0);
            return entity;
        }));
        hunterPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "hunter.text", GuideBook.loc(ModItems.human_heart))));
        entries.put(new ResourceLocation(base + "hunter"), (EntryAbstract)new EntryText(hunterPages, ModEntities.hunter.m_20676_()));
        ArrayList<IPage> vampirePages = new ArrayList<IPage>();
        vampirePages.add((IPage)new PageEntity(ModEntities.vampire));
        vampirePages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "vampire.text", GuideBook.loc(ModItems.vampire_fang), GuideBook.loc(ModItems.vampire_blood_bottle), GuideBook.loc((Item)ModItems.stake))));
        entries.put(new ResourceLocation(base + "vampire"), (EntryAbstract)new EntryText(vampirePages, ModEntities.vampire.m_20676_()));
        ArrayList<IPage> advancedHunterPages = new ArrayList<IPage>();
        advancedHunterPages.add((IPage)new PageEntity(ModEntities.advanced_hunter));
        advancedHunterPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "advanced_hunter.text", new Object[0])));
        entries.put(new ResourceLocation(base + "advanced_hunter"), (EntryAbstract)new EntryText(advancedHunterPages, ModEntities.advanced_hunter.m_20676_()));
        ArrayList<IPage> advancedVampirePages = new ArrayList<IPage>();
        advancedVampirePages.add((IPage)new PageEntity(ModEntities.advanced_vampire));
        advancedVampirePages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "advanced_vampire.text", GuideBook.loc(ModItems.blood_bottle), GuideBook.loc(ModItems.vampire_blood_bottle))));
        entries.put(new ResourceLocation(base + "advanced_vampire"), (EntryAbstract)new EntryText(advancedVampirePages, ModEntities.advanced_vampire.m_20676_()));
        ArrayList<IPage> vampireBaronPages = new ArrayList<IPage>();
        vampireBaronPages.add((IPage)new PageEntity(ModEntities.vampire_baron));
        vampireBaronPages.add((IPage)new PageEntity(world -> {
            VampireBaronEntity baron = (VampireBaronEntity)ModEntities.vampire_baron.m_20615_(world);
            baron.setLady(true);
            return baron;
        }, ModEntities.vampire_baron.m_20676_()));
        vampireBaronPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "vampire_baron.text", GuideBook.loc(ModItems.pure_blood_0))));
        helper.addLinks(vampireBaronPages, new Object[]{new ResourceLocation("guide.vampirism.world.vampire_forest")});
        entries.put(new ResourceLocation(base + "vampire_baron"), (EntryAbstract)new EntryText(vampireBaronPages, ModEntities.vampire_baron.m_20676_()));
        ArrayList<IPage> hunterTrainerPages = new ArrayList<IPage>();
        hunterTrainerPages.add((IPage)new PageEntity(ModEntities.hunter_trainer));
        hunterTrainerPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "hunter_trainer.text", new Object[0])));
        entries.put(new ResourceLocation(base + "hunter_trainer"), (EntryAbstract)new EntryText(hunterTrainerPages, ModEntities.hunter_trainer.m_20676_()));
        ArrayList<IPage> taskMasterPages = new ArrayList<IPage>();
        taskMasterPages.add((IPage)new PageEntity(ModEntities.task_master_vampire));
        taskMasterPages.add((IPage)new PageEntity(ModEntities.task_master_hunter));
        taskMasterPages.addAll(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "taskmaster.text", new Object[0])));
        taskMasterPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/taskscreen.png")));
        entries.put(new ResourceLocation(base + "taskmaster"), (EntryAbstract)new EntryText(taskMasterPages, (Component)new TranslatableComponent(base + "taskmaster")));
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildWorld(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.world.";
        ArrayList<IPage> vampireForestPages = new ArrayList<IPage>(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "vampire_forest.text", new Object[0])));
        entries.put(new ResourceLocation(base + "vampire_forest"), (EntryAbstract)new EntryText(vampireForestPages, (Component)GuideBook.translateComponent(base + "vampire_forest", new Object[0])));
        ArrayList<IPage> villagePages = new ArrayList<IPage>(helper.addLinks(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "villages.text", new Object[0]).m_130946_("\n").m_7220_((Component)GuideBook.translateComponent(base + "villages.raids", new Object[0]))), new Object[]{new ResourceLocation("guide.vampirism.blocks.totem_base"), new ResourceLocation("guide.vampirism.blocks.totem_top_crafted")}));
        entries.put(new ResourceLocation(base + "villages"), (EntryAbstract)new EntryText(villagePages, (Component)GuideBook.translateComponent(base + "villages", new Object[0])));
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildItems(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.items.";
        helper.info(new Item[]{ModItems.vampire_fang}).build(entries);
        helper.info(new Item[]{ModItems.human_heart}).build(entries);
        helper.info(new Item[]{ModItems.pure_blood_0, ModItems.pure_blood_1, ModItems.pure_blood_2, ModItems.pure_blood_3, ModItems.pure_blood_4}).setFormats(new Object[]{GuideBook.translateComponent(ModEntities.vampire_baron.m_20675_(), new Object[0])}).build(entries);
        helper.info(new Item[]{ModItems.vampire_blood_bottle}).setFormats(new Object[]{GuideBook.translateComponent(ModEntities.vampire.m_20675_(), new Object[0]), GuideBook.translateComponent(ModEntities.advanced_vampire.m_20675_(), GuideBook.loc((Item)ModItems.stake))}).build(entries);
        helper.info(new Item[]{ModItems.vampire_book}).build(entries);
        helper.info(new Item[]{ModItems.oblivion_potion}).customPages(new IPage[]{GuideHelper.createItemTaskDescription(ModTasks.oblivion_potion)}).build(entries);
        helper.info(false, new ItemStack[]{BloodBottleItem.getStackWithDamage(9)}).build(entries);
        helper.info(new Item[]{ModItems.blood_infused_iron_ingot}).recipes(new String[]{"vampire/blood_infused_iron_ingot", "vampire/blood_infused_enhanced_iron_ingot"}).build(entries);
        helper.info(new Item[]{ModItems.heart_seeker_normal, ModItems.heart_seeker_enhanced, ModItems.heart_seeker_ultimate}).recipes(new String[]{"vampire/heart_seeker_normal", "vampire/heart_seeker_enhanced"}).build(entries);
        helper.info(new Item[]{ModItems.heart_striker_normal, ModItems.heart_striker_enhanced, ModItems.heart_striker_ultimate}).recipes(new String[]{"vampire/heart_striker_normal", "vampire/heart_striker_normal"}).build(entries);
        helper.info(new Item[]{ModItems.feeding_adapter}).customPages(new IPage[]{GuideHelper.createItemTaskDescription(ModTasks.feeding_adapter)}).build(entries);
        helper.info(new Item[]{ModItems.vampire_minion_binding, ModItems.vampire_minion_upgrade_simple, ModItems.vampire_minion_upgrade_enhanced, ModItems.vampire_minion_upgrade_special}).setFormats(new Object[]{GuideBook.loc(ModItems.vampire_minion_binding), GuideBook.loc(ModItems.vampire_minion_upgrade_simple), ModItems.vampire_minion_upgrade_simple.getMinLevel() + 1, ModItems.vampire_minion_upgrade_simple.getMaxLevel() + 1, GuideBook.loc(ModItems.vampire_minion_upgrade_enhanced), ModItems.vampire_minion_upgrade_enhanced.getMinLevel() + 1, ModItems.vampire_minion_upgrade_enhanced.getMaxLevel() + 1, GuideBook.loc(ModItems.vampire_minion_upgrade_special), ModItems.vampire_minion_upgrade_special.getMinLevel() + 1, ModItems.vampire_minion_upgrade_special.getMaxLevel() + 1, GuideBook.translate(ModEntities.task_master_vampire.m_20675_(), new Object[0])}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.entity.taskmaster"), new ResourceLocation("guide.vampirism.vampire.lord")}).build(entries);
        helper.info(new Item[]{ModItems.garlic_finder}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.blocks.garlic_diffuser")}).recipes(new String[]{"vampire/garlic_finder"}).build(entries);
        helper.info(new Item[]{ModItems.vampire_clothing_crown, ModItems.vampire_clothing_hat, ModItems.vampire_clothing_legs, ModItems.vampire_clothing_boots, ModItems.vampire_cloak_red_black, ModItems.vampire_cloak_black_red, ModItems.vampire_cloak_black_blue, ModItems.vampire_cloak_red_black, ModItems.vampire_cloak_black_white, ModItems.vampire_cloak_white_black}).useCustomEntryName().setKeyName("vampire_clothing").recipes(new String[]{"vampire/vampire_clothing_legs", "vampire/vampire_clothing_boots", "vampire/vampire_clothing_hat", "vampire/vampire_clothing_crown", "vampire/vampire_cloak_black_red", "vampire/vampire_cloak_black_blue", "vampire/vampire_cloak_black_white", "vampire/vampire_cloak_red_black", "vampire/vampire_cloak_white_black"}).build(entries);
        helper.info(new Item[]{ModItems.amulet, ModItems.ring, ModItems.obi_belt}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.vampire.vampirism_menu")}).useCustomEntryName().setKeyName("accessories").build(entries);
        helper.info(new Item[]{ModItems.injection_empty, ModItems.injection_garlic, ModItems.injection_sanguinare}).recipes(new String[]{"general/injection_0", "general/injection_1", "general/injection_2"}).build(entries);
        helper.info(new Item[]{ModItems.hunter_intel_0}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.blocks.hunter_table")}).setFormats(new Object[]{GuideBook.loc(ModBlocks.hunter_table)}).build(entries);
        helper.info(new Item[]{ModItems.item_garlic}).build(entries);
        helper.info(new Item[]{ModItems.purified_garlic}).setFormats(new Object[]{GuideBook.loc((Block)ModBlocks.garlic_diffuser_normal)}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.blocks.garlic_diffuser")}).recipes(new String[]{"alchemical_cauldron/purified_garlic"}).build(entries);
        helper.info(new Item[]{ModItems.pitchfork}).recipes(new String[]{"weapontable/pitchfork"}).build(entries);
        helper.info(new Item[]{ModItems.stake}).setFormats(new Object[]{(int)((Double)VampirismConfig.BALANCE.hsInstantKill1MaxHealth.get() * 100.0) + "%"}).recipes(new String[]{"hunter/stake"}).build(entries);
        helper.info(new Item[]{ModItems.basic_crossbow, ModItems.enhanced_crossbow, ModItems.basic_double_crossbow, ModItems.enhanced_double_crossbow, ModItems.basic_tech_crossbow, ModItems.enhanced_tech_crossbow}).setFormats(new Object[]{GuideBook.loc(ModItems.crossbow_arrow_normal), GuideBook.loc(ModItems.tech_crossbow_ammo_package)}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.items.crossbow_arrow_normal")}).recipes(new String[]{"weapontable/basic_crossbow", "weapontable/enhanced_crossbow", "weapontable/basic_double_crossbow", "weapontable/enhanced_double_crossbow", "weapontable/basic_tech_crossbow", "weapontable/enhanced_tech_crossbow", "weapontable/tech_crossbow_ammo_package"}).useCustomEntryName().setKeyName("crossbows").build(entries);
        helper.info(new Item[]{ModItems.crossbow_arrow_normal, ModItems.crossbow_arrow_spitfire, ModItems.crossbow_arrow_vampire_killer}).recipes(new String[]{"hunter/crossbow_arrow_normal", "weapontable/crossbow_arrow_spitfire", "weapontable/crossbow_arrow_vampire_killer"}).build(entries);
        helper.info(new Item[]{ModItems.holy_water_bottle_normal, ModItems.holy_water_bottle_enhanced, ModItems.holy_water_bottle_ultimate}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.hunter.vamp_slayer"), new ResourceLocation("guide.vampirism.items.holy_salt")}).setFormats(new Object[]{GuideBook.loc(ModItems.holy_salt_water), GuideBook.loc(ModItems.holy_salt_water), GuideBook.loc(ModItems.holy_salt)}).brewingItems(new Item[]{ModItems.holy_salt_water, ModItems.holy_water_splash_bottle_normal}).setKeyName("holy_water_bottle").build(entries);
        helper.info(new Item[]{ModItems.holy_salt}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.items.holy_water_bottle")}).setFormats(new Object[]{GuideBook.loc(ModItems.pure_salt), GuideBook.loc(ModItems.pure_salt), GuideBook.loc((Block)ModBlocks.alchemical_cauldron)}).recipes(new String[]{"alchemical_cauldron/pure_salt"}).build(entries);
        helper.info(new Item[]{ModItems.item_alchemical_fire}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.items.crossbow_arrow_normal")}).recipes(new String[]{"alchemical_cauldron/alchemical_fire_4", "alchemical_cauldron/alchemical_fire_5", "alchemical_cauldron/alchemical_fire_6"}).build(entries);
        helper.info(new Item[]{ModItems.armor_of_swiftness_chest_normal, ModItems.armor_of_swiftness_chest_enhanced, ModItems.armor_of_swiftness_chest_enhanced, ModItems.armor_of_swiftness_legs_normal, ModItems.armor_of_swiftness_legs_enhanced, ModItems.armor_of_swiftness_legs_ultimate, ModItems.armor_of_swiftness_head_normal, ModItems.armor_of_swiftness_head_enhanced, ModItems.armor_of_swiftness_head_ultimate, ModItems.armor_of_swiftness_feet_normal, ModItems.armor_of_swiftness_feet_enhanced, ModItems.armor_of_swiftness_feet_ultimate}).recipes(new String[]{"weapontable/armor_of_swiftness_chest_normal", "weapontable/armor_of_swiftness_legs_normal", "weapontable/armor_of_swiftness_head_normal", "weapontable/armor_of_swiftness_feet_normal", "weapontable/armor_of_swiftness_chest_enhanced", "weapontable/armor_of_swiftness_legs_enhanced", "weapontable/armor_of_swiftness_head_enhanced", "weapontable/armor_of_swiftness_feet_enhanced"}).build(entries);
        helper.info(new Item[]{ModItems.hunter_coat_chest_normal, ModItems.hunter_coat_chest_enhanced, ModItems.hunter_coat_chest_enhanced, ModItems.hunter_coat_legs_normal, ModItems.hunter_coat_legs_enhanced, ModItems.hunter_coat_legs_ultimate, ModItems.hunter_coat_head_normal, ModItems.hunter_coat_head_enhanced, ModItems.hunter_coat_head_ultimate, ModItems.hunter_coat_feet_normal, ModItems.hunter_coat_feet_enhanced, ModItems.hunter_coat_feet_ultimate}).recipes(new String[]{"weapontable/hunter_coat_chest_normal", "weapontable/hunter_coat_legs_normal", "weapontable/hunter_coat_head_normal", "weapontable/hunter_coat_feet_normal", "weapontable/hunter_coat_chest_enhanced", "weapontable/hunter_coat_legs_enhanced", "weapontable/hunter_coat_head_enhanced", "weapontable/hunter_coat_feet_enhanced"}).build(entries);
        helper.info(new Item[]{ModItems.obsidian_armor_chest_normal, ModItems.obsidian_armor_chest_enhanced, ModItems.obsidian_armor_chest_enhanced, ModItems.obsidian_armor_legs_normal, ModItems.obsidian_armor_legs_enhanced, ModItems.obsidian_armor_legs_ultimate, ModItems.obsidian_armor_head_normal, ModItems.obsidian_armor_head_enhanced, ModItems.obsidian_armor_head_ultimate, ModItems.obsidian_armor_feet_normal, ModItems.obsidian_armor_feet_enhanced, ModItems.obsidian_armor_feet_ultimate}).recipes(new String[]{"weapontable/obsidian_armor_chest_normal", "weapontable/obsidian_armor_legs_normal", "weapontable/obsidian_armor_head_normal", "weapontable/obsidian_armor_feet_normal", "weapontable/obsidian_armor_chest_enhanced", "weapontable/obsidian_armor_legs_enhanced", "weapontable/obsidian_armor_head_enhanced", "weapontable/obsidian_armor_feet_enhanced"}).build(entries);
        helper.info(new Item[]{ModItems.hunter_axe_normal, ModItems.hunter_axe_enhanced, ModItems.hunter_axe_ultimate}).recipes(new String[]{"weapontable/hunter_axe_normal", "weapontable/hunter_axe_enhanced"}).build(entries);
        helper.info(new Item[]{ModItems.hunter_minion_equipment, ModItems.hunter_minion_upgrade_simple, ModItems.hunter_minion_upgrade_enhanced, ModItems.hunter_minion_upgrade_special}).setFormats(new Object[]{GuideBook.loc(ModItems.hunter_minion_equipment), GuideBook.loc(ModItems.hunter_minion_upgrade_simple), ModItems.hunter_minion_upgrade_simple.getMinLevel() + 1, ModItems.hunter_minion_upgrade_simple.getMaxLevel() + 1, GuideBook.loc(ModItems.hunter_minion_upgrade_enhanced), ModItems.hunter_minion_upgrade_enhanced.getMinLevel() + 1, ModItems.hunter_minion_upgrade_enhanced.getMaxLevel() + 1, GuideBook.loc(ModItems.hunter_minion_upgrade_special), ModItems.hunter_minion_upgrade_special.getMinLevel() + 1, ModItems.hunter_minion_upgrade_special.getMaxLevel() + 1, GuideBook.translate(ModEntities.task_master_hunter.m_20675_(), new Object[0])}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.entity.taskmaster"), new ResourceLocation("guide.vampirism.hunter.lord")}).build(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildBlocks(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.blocks.";
        helper.info(new Block[]{ModBlocks.castle_block_dark_brick}).recipes(new String[]{"general/castle_block_dark_brick_0", "general/castle_block_dark_brick_1", "general/castle_block_dark_stone", "general/castle_block_normal_brick", "general/castle_block_purple_brick", "general/castle_slab_dark_brick", "general/castle_stairs_dark_brick"}).build(entries);
        helper.info(new Block[]{ModBlocks.vampire_orchid}).build(entries);
        helper.info(new Block[]{ModBlocks.blood_container}).recipes(new String[]{"vampire/blood_container"}).build(entries);
        helper.info(new Block[]{ModBlocks.altar_inspiration}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.vampire.leveling")}).recipes(new String[]{"vampire/altar_inspiration"}).build(entries);
        helper.info(new Block[]{ModBlocks.altar_infusion}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.vampire.leveling")}).recipes(new String[]{"vampire/altar_infusion", "vampire/altar_pillar", "vampire/altar_tip"}).build(entries);
        helper.info(new Block[]{ModBlocks.coffin}).recipes(new String[]{"vampire/coffin"}).build(entries);
        helper.info(new Block[]{ModBlocks.altar_cleansing}).build(entries);
        helper.info(true, new ItemStack[]{new ItemStack((ItemLike)ModItems.item_med_chair)}).setFormats(new Object[]{GuideBook.loc(ModItems.injection_garlic), GuideBook.loc(ModItems.injection_sanguinare)}).recipes(new String[]{"hunter/item_med_chair"}).build(entries);
        helper.info(new Block[]{ModBlocks.hunter_table}).setFormats(new Object[]{GuideBook.loc(ModItems.hunter_intel_0)}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.hunter.leveling"), new ResourceLocation("guide.vampirism.items.hunter_intel")}).recipes(new String[]{"hunter/hunter_table"}).build(entries);
        helper.info(new Block[]{ModBlocks.weapon_table}).recipes(new String[]{"hunter/weapon_table"}).build(entries);
        helper.info(new Block[]{ModBlocks.alchemical_cauldron}).recipes(new String[]{"hunter/alchemical_cauldron"}).build(entries);
        int cn = (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserNormalDist.get() * 2 + 1;
        int ce = (Integer)VampirismConfig.BALANCE.hsGarlicDiffuserEnhancedDist.get() * 2 + 1;
        helper.info(new Block[]{ModBlocks.garlic_diffuser_normal, ModBlocks.garlic_diffuser_weak, ModBlocks.garlic_diffuser_weak}).setFormats(new Object[]{cn, cn, ce, ce, GuideBook.loc(ModItems.purified_garlic)}).useCustomEntryName().setKeyName("garlic_diffuser").setLinks(new Object[]{new ResourceLocation("guide.vampirism.items.item_garlic"), new ResourceLocation("guide.vampirism.items.purified_garlic"), new ResourceLocation("guide.vampirism.items.holy_water_bottle")}).recipes(new String[]{"hunter/garlic_diffuser_normal", "hunter/garlic_diffuser_improved", "alchemical_cauldron/garlic_diffuser_core", "alchemical_cauldron/garlic_diffuser_core_improved"}).build(entries);
        helper.info(new Block[]{ModBlocks.blood_pedestal}).recipes(new String[]{"vampire/blood_pedestal"}).build(entries);
        helper.info(new Block[]{ModBlocks.blood_grinder}).recipes(new String[]{"general/blood_grinder"}).setFormats(new Object[]{GuideBook.loc(ModItems.human_heart), GuideBook.loc(Items.f_42579_), GuideBook.loc((Block)ModBlocks.blood_sieve)}).build(entries);
        helper.info(new Block[]{ModBlocks.blood_sieve}).recipes(new String[]{"general/blood_sieve"}).setFormats(new Object[]{GuideBook.translateComponent(ModFluids.impure_blood.getAttributes().getTranslationKey(), new Object[0]), GuideBook.loc((Block)ModBlocks.blood_grinder)}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.blocks.blood_grinder")}).build(entries);
        helper.info(new Block[]{ModBlocks.totem_top_crafted, ModBlocks.totem_top}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.blocks.totem_base"), new ResourceLocation("guide.vampirism.world.villages")}).build(entries);
        helper.info(new Block[]{ModBlocks.totem_base}).recipes(new String[]{"general/totem_base"}).setLinks(new Object[]{new ResourceLocation("guide.vampirism.blocks.totem_top_crafted"), new ResourceLocation("guide.vampirism.world.villages")}).build(entries);
        helper.info(new Block[]{ModBlocks.potion_table}).recipes(new String[]{"hunter/potion_table"}).customPages(GuideBook.generatePotionMixes()).build(entries);
        ArrayList<IPage> decorativeBlocks = new ArrayList<IPage>(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base + "decorative.text", new Object[0]), (Item)ModItems.item_candelabra));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "vampire/candelabra")));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "vampire/chandelier")));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "hunter/cross")));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "general/tombstone1")));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "general/tombstone2")));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "general/tombstone3")));
        decorativeBlocks.add(helper.getRecipePage(new ResourceLocation("vampirism", "general/grave_cage")));
        entries.put(new ResourceLocation(base + "decorative"), (EntryAbstract)new EntryItemStack(decorativeBlocks, (Component)new TranslatableComponent(base + "decorative.title"), new ItemStack((ItemLike)ModItems.item_candelabra)));
        return entries;
    }

    public static Map<ResourceLocation, EntryAbstract> buildChangelog(BookHelper helper) {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.changelog.";
        entries.put(new ResourceLocation(base + "v1_8"), GuideBook.buildChangelog1_8());
        return entries;
    }

    public static EntryAbstract buildChangelog1_8() {
        String base = "guide.vampirism.changelog.";
        String base1_8 = base + "v1_8.";
        ArrayList v1_8 = new ArrayList(PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base1_8 + "overview.text", new Object[0])));
        List vampirism_menu = PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base1_8 + "vampirism_menu.text", ModKeys.VAMPIRISM_MENU.m_90863_()));
        vampirism_menu.add(new PageTextImage((FormattedText)GuideBook.translateComponent(base1_8 + "vampirism_menu.image", new Object[0]), new ResourceLocation("vampirismguide:textures/images/vampirism_menu.png"), false));
        v1_8.addAll(vampirism_menu);
        List accessories = PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base1_8 + "accessories.text", new Object[0]));
        accessories.add(new PageTextImage((FormattedText)GuideBook.translateComponent(base1_8 + "accessories.image", new Object[0]), new ResourceLocation("vampirismguide:textures/images/vampire_accessories.png"), false));
        v1_8.addAll(accessories);
        List armor = PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base1_8 + "vampire_armor.text", new Object[0]));
        v1_8.addAll(armor);
        List immortality = PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base1_8 + "vampire_immortality.text", new Object[0]));
        v1_8.addAll(immortality);
        List task_changes = PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base1_8 + "tasks.text", new Object[0]));
        v1_8.addAll(task_changes);
        List raids = PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base1_8 + "raids.text", new Object[0]));
        v1_8.addAll(raids);
        List skills = PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base1_8 + "skills.text", new Object[0]));
        skills.add(new PageTextImage((FormattedText)GuideBook.translateComponent(base1_8 + "skills.vista.image", new Object[0]), new ResourceLocation("vampirism", "textures/skills/vampire_forest_fog.png"), false));
        skills.add(new PageTextImage((FormattedText)GuideBook.translateComponent(base1_8 + "skills.neonatal.image", new Object[0]), new ResourceLocation("vampirism", "textures/skills/neonatal_decrease.png"), false));
        skills.add(new PageTextImage((FormattedText)GuideBook.translateComponent(base1_8 + "skills.dbno.image", new Object[0]), new ResourceLocation("vampirism", "textures/skills/dbno_duration.png"), false));
        skills.add(new PageTextImage((FormattedText)GuideBook.translateComponent(base1_8 + "skills.hissing.image", new Object[0]), new ResourceLocation("vampirism", "textures/actions/hissing.png"), false));
        v1_8.addAll(skills);
        List balancing = PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base1_8 + "balancing.text", new Object[0]));
        v1_8.addAll(balancing);
        List misc = PageHelper.pagesForLongText((FormattedText)GuideBook.translateComponent(base1_8 + "misc.text", new Object[0]));
        v1_8.addAll(misc);
        return new EntryResourceLocation(v1_8, (Component)GuideBook.translateComponent(base + "v1_8", new Object[0]), new ResourceLocation("textures/item/writable_book.png"));
    }

    private static IPage[] generatePotionMixes() {
        IPage[] pages = new IPage[]{new PagePotionTableMix(HunterSkills.durable_brewing.getName(), (ExtendedPotionMix[])VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().filter(mix -> mix.durable && !mix.concentrated && !mix.efficient).toArray(ExtendedPotionMix[]::new)), new PagePotionTableMix(HunterSkills.concentrated_brewing.getName(), (ExtendedPotionMix[])VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().filter(mix -> mix.concentrated && !mix.durable && !mix.efficient).toArray(ExtendedPotionMix[]::new)), new PagePotionTableMix((Component)HunterSkills.durable_brewing.getName().m_6881_().m_130946_("\n").m_7220_(HunterSkills.efficient_brewing.getName()), (ExtendedPotionMix[])VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().filter(mix -> mix.durable && !mix.concentrated && mix.efficient).toArray(ExtendedPotionMix[]::new)), new PagePotionTableMix((Component)HunterSkills.concentrated_brewing.getName().m_6881_().m_130946_("\n").m_7220_(HunterSkills.efficient_brewing.getName()), (ExtendedPotionMix[])VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().filter(mix -> mix.concentrated && !mix.durable && mix.efficient).toArray(ExtendedPotionMix[]::new)), new PagePotionTableMix(HunterSkills.master_brewer.getName(), (ExtendedPotionMix[])VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().filter(mix -> mix.master && !mix.durable && !mix.concentrated && !mix.efficient).toArray(ExtendedPotionMix[]::new)), new PagePotionTableMix((Component)HunterSkills.master_brewer.getName().m_6881_().m_130946_("\n").m_7220_(HunterSkills.efficient_brewing.getName()), (ExtendedPotionMix[])VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().filter(mix -> mix.master && !mix.durable && !mix.concentrated && mix.efficient).toArray(ExtendedPotionMix[]::new))};
        return pages;
    }

    public static MutableComponent translateComponent(String key, Object ... format) {
        String result = UtilLib.translate(key, format);
        return new TextComponent(result.replaceAll("\\\\n", Matcher.quoteReplacement("\n")));
    }

    public static String translate(String key, Object ... format) {
        String result = UtilLib.translate(key, format);
        return result.replaceAll("\\\\n", Matcher.quoteReplacement("\n"));
    }

    @Nullable
    public Book buildBook() {
        BookBinder binder = new BookBinder(new ResourceLocation("vampirism", "guidebook"));
        binder.setGuideTitleKey("guide.vampirism.title");
        binder.setItemNameKey("guide.vampirism");
        binder.setHeaderKey("guide.vampirism.welcome");
        binder.setAuthor((Component)new TextComponent("Maxanier"));
        binder.setColor(Color.WHITE.getRGB());
        binder.setOutlineTexture(new ResourceLocation("vampirismguide", "textures/gui/book_violet_border.png"));
        binder.setSpawnWithBook();
        binder.setContentProvider(GuideBook::buildCategories);
        guideBook = binder.build();
        return guideBook;
    }

    @Nullable
    public ResourceLocation getModel() {
        return new ResourceLocation("vampirism", "guidebook");
    }
}

