/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.items.IBloodChargeable;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.items.VampirismItemWeapon;
import de.teamlapen.vampirism.particle.FlyingBloodParticleData;
import de.teamlapen.vampirism.particle.GenericParticleData;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class VampirismVampireSword
extends VampirismItemWeapon
implements IBloodChargeable,
IFactionExclusiveItem,
IFactionLevelItem<IVampirePlayer> {
    public static final String DO_NOT_NAME_STRING = "DO_NOT_NAME";
    private static final float minStrength = 0.2f;
    private final float trainedAttackSpeed;
    private final float untrainedAttackSpeed;

    public VampirismVampireSword(String regName, Tiers material, int attackDamage, float untrainedAttackSpeed, float trainedAttackSpeed, Item.Properties prop) {
        super(regName, (Tier)material, attackDamage, untrainedAttackSpeed, prop);
        this.trainedAttackSpeed = trainedAttackSpeed;
        this.untrainedAttackSpeed = untrainedAttackSpeed;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        this.addFactionLevelToolTip(stack, worldIn, tooltip, flagIn, VampirismMod.proxy.getClientPlayer());
        float charged = this.getCharged(stack);
        float trained = this.getTrained(stack, (LivingEntity)VampirismMod.proxy.getClientPlayer());
        tooltip.add((Component)new TranslatableComponent("text.vampirism.sword_charged").m_7220_((Component)new TextComponent(" " + (int)Math.ceil(charged * 100.0f) + "%")).m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add((Component)new TranslatableComponent("text.vampirism.sword_trained").m_7220_((Component)new TextComponent(" " + (int)Math.ceil(trained * 100.0f) + "%")).m_130940_(ChatFormatting.DARK_AQUA));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44981_ || this instanceof IItemWithTier && ((IItemWithTier)((Object)this)).getVampirismTier() == IItemWithTier.TIER.ULTIMATE) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public boolean canBeCharged(ItemStack stack) {
        return this.getCharged(stack) < 1.0f;
    }

    @Override
    public int charge(ItemStack stack, int amount) {
        float factor = this.getChargingFactor(stack);
        float charge = this.getCharged(stack);
        float actual = Math.min(factor * (float)amount, 1.0f - charge);
        this.setCharged(stack, charge + actual);
        return (int)(actual / factor);
    }

    public void doNotName(ItemStack stack) {
        stack.m_41700_("dont_name", (Tag)ByteTag.m_128266_((byte)127));
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@Nonnull ItemStack stack) {
        return VReference.VAMPIRE_FACTION;
    }

    @Override
    public int getMinLevel(@Nonnull ItemStack stack) {
        return 0;
    }

    @Override
    @Nullable
    public ISkill<IVampirePlayer> getRequiredSkill(@Nonnull ItemStack stack) {
        return null;
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return 40;
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level worldIn, @Nonnull LivingEntity entityLiving) {
        if (!(entityLiving instanceof Player)) {
            return stack;
        }
        VReference.VAMPIRE_FACTION.getPlayerCapability((Player)entityLiving).ifPresent(vampire -> {
            int amount;
            int n = amount = vampire.getSkillHandler().isRefinementEquipped(ModRefinements.blood_charge_speed) ? (Integer)VampirismConfig.BALANCE.vrBloodChargeSpeedMod.get() : 2;
            if (((Player)entityLiving).m_7500_() || vampire.useBlood(amount, false)) {
                this.charge(stack, amount * 100);
            }
        });
        if (this.getCharged(stack) == 1.0f) {
            this.tryName(stack, (Player)entityLiving);
        }
        return stack;
    }

    public boolean m_7579_(@Nonnull ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity attacker) {
        double relTh;
        if (attacker instanceof Player && !Helper.isVampire((Entity)target) && (relTh = (Double)VampirismConfig.BALANCE.vsSwordFinisherMaxHealth.get() * VampirePlayer.getOpt((Player)attacker).map(VampirePlayer::getSkillHandler).map(h -> h.isSkillEnabled(VampireSkills.sword_finisher) ? (h.isRefinementEquipped(ModRefinements.sword_finisher) ? (Double)VampirismConfig.BALANCE.vrSwordFinisherThresholdMod.get() : 1.0) : 0.0).orElse(0.0)) > 0.0 && (double)target.m_21223_() <= (double)target.m_21233_() * relTh) {
            DamageSource dmg = DamageSource.m_19344_((Player)((Player)attacker)).m_19380_();
            target.m_6469_(dmg, 10000.0f);
            Vec3 center = Vec3.m_82528_((Vec3i)target.m_142538_());
            center.m_82520_(0.0, (double)target.m_20206_() / 2.0, 0.0);
            ModParticles.spawnParticlesServer(target.f_19853_, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "effect_4"), 12, 0xE02020), center.f_82479_, center.f_82480_, center.f_82481_, 15, 0.5, 0.5, 0.5, 0.0);
        }
        if (target.m_21223_() <= 0.0f && Helper.isVampire((Entity)attacker)) {
            float trained = this.getTrained(stack, attacker);
            int exp = target instanceof Player ? 10 : (attacker instanceof Player ? Helper.getExperiencePoints(target, (Player)attacker) : 5);
            float newTrained = (float)exp / 5.0f * (1.0f - trained) / 15.0f;
            if (attacker instanceof Player && VampirePlayer.getOpt((Player)attacker).map(VampirePlayer::getSkillHandler).map(handler -> handler.isRefinementEquipped(ModRefinements.sword_trained_amount)).orElse(false).booleanValue()) {
                newTrained = (float)((double)newTrained * (Double)VampirismConfig.BALANCE.vrSwordTrainingSpeedMod.get());
            }
            this.setTrained(stack, attacker, trained += newTrained);
        }
        float charged = this.getCharged(stack);
        this.setCharged(stack, charged -= this.getChargeUsage());
        attacker.m_21008_(InteractionHand.MAIN_HAND, stack);
        return super.m_7579_(stack, target, attacker);
    }

    public boolean isFullyCharged(ItemStack stack) {
        return this.getCharged(stack) == 1.0f;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return !Helper.isVampire((Entity)entity);
    }

    public void m_6883_(@Nonnull ItemStack stack, Level worldIn, @Nonnull Entity entityIn, int itemSlot, boolean isSelected) {
        float charged;
        if (worldIn.f_46443_ && (isSelected || itemSlot == 0) && (charged = this.getCharged(stack)) > 0.0f && entityIn.f_19797_ % (int)(20.0f + 100.0f * (1.0f - charged)) == 0 && entityIn instanceof LivingEntity) {
            boolean secondHand;
            boolean bl = secondHand = !isSelected && ((LivingEntity)entityIn).m_21120_(InteractionHand.OFF_HAND).equals(stack);
            if (isSelected || secondHand) {
                this.spawnChargedParticle((LivingEntity)entityIn, isSelected);
            }
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player.m_20193_().f_46443_ && count % 3 == 0) {
            this.spawnChargingParticle(player, player.m_21205_().equals(stack));
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return !Helper.isVampire(player);
    }

    public void setCharged(@Nonnull ItemStack stack, float value) {
        stack.m_41700_("charged", (Tag)FloatTag.m_128566_((float)Mth.m_14036_((float)value, (float)0.0f, (float)1.0f)));
    }

    public void setTrained(@Nonnull ItemStack stack, @Nonnull LivingEntity player, float value) {
        CompoundTag nbt = stack.m_41698_("trained");
        nbt.m_128350_(player.m_142081_().toString(), Mth.m_14036_((float)value, (float)0.0f, (float)1.0f));
    }

    public void tryName(ItemStack stack, Player player) {
        if (!(stack.m_41788_() || !player.f_19853_.m_5776_() || stack.m_41782_() && stack.m_41783_().m_128471_("dont_name"))) {
            VampirismMod.proxy.displayNameSwordScreen(stack);
            player.f_19853_.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    public boolean updateTrainedCached(@Nonnull ItemStack stack, @Nonnull LivingEntity player) {
        float trained;
        float cached = this.getTrained(stack);
        if (cached != (trained = this.getTrained(stack, player))) {
            stack.m_41700_("trained-cache", (Tag)FloatTag.m_128566_((float)trained));
            return true;
        }
        return false;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        return VampirePlayer.getOpt(playerIn).map(vampire -> {
            if (vampire.getLevel() == 0) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            if (this.canBeCharged(stack) && playerIn.m_6144_() && vampire.getSkillHandler().isSkillEnabled(VampireSkills.blood_charge) && (playerIn.m_7500_() || vampire.getBloodLevel() >= (vampire.getSkillHandler().isRefinementEquipped(ModRefinements.blood_charge_speed) ? (Integer)VampirismConfig.BALANCE.vrBloodChargeSpeedMod.get() : 2))) {
                playerIn.m_6672_(handIn);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }).orElse(new InteractionResultHolder(InteractionResult.PASS, (Object)stack));
    }

    @Override
    protected final float getAttackDamage(ItemStack stack) {
        return super.getAttackDamage(stack) * this.getAttackDamageModifier(stack);
    }

    protected float getAttackDamageModifier(ItemStack stack) {
        return this.getCharged(stack) > 0.0f ? 1.0f : 0.2f;
    }

    @Override
    protected final float getAttackSpeed(ItemStack stack) {
        return this.untrainedAttackSpeed + (this.trainedAttackSpeed - this.untrainedAttackSpeed) * this.getTrained(stack);
    }

    protected abstract float getChargeUsage();

    protected float getCharged(@Nonnull ItemStack stack) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128457_("charged");
        }
        return 0.0f;
    }

    protected abstract float getChargingFactor(ItemStack var1);

    protected float getTrained(@Nonnull ItemStack stack) {
        CompoundTag nbt;
        if (stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_("trained-cache")) {
            return nbt.m_128457_("trained-cache");
        }
        return 0.0f;
    }

    protected float getTrained(@Nonnull ItemStack stack, @Nullable LivingEntity player) {
        if (player == null) {
            return this.getTrained(stack);
        }
        UUID id = player.m_142081_();
        CompoundTag nbt = stack.m_41737_("trained");
        if (nbt != null && nbt.m_128441_(id.toString())) {
            return nbt.m_128457_(id.toString());
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnChargedParticle(LivingEntity player, boolean mainHand) {
        Vec3 mainPos = UtilLib.getItemPosition(player, mainHand);
        for (int j = 0; j < 3; ++j) {
            Vec3 pos = mainPos.m_82520_((double)((player.m_21187_().nextFloat() - 0.5f) * 0.1f), (double)((player.m_21187_().nextFloat() - 0.3f) * 0.9f), (double)((player.m_21187_().nextFloat() - 0.5f) * 0.1f));
            ModParticles.spawnParticleClient(player.m_20193_(), new FlyingBloodParticleData(ModParticles.flying_blood, (int)(4.0f / (player.m_21187_().nextFloat() * 0.9f + 0.1f)), true, pos.f_82479_ + ((double)player.m_21187_().nextFloat() - 0.5) * 0.1, pos.f_82480_ + ((double)player.m_21187_().nextFloat() - 0.5) * 0.1, pos.f_82481_ + ((double)player.m_21187_().nextFloat() - 0.5) * 0.1, new ResourceLocation("minecraft", "glitter_1")), pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnChargingParticle(LivingEntity player, boolean mainHand) {
        Vec3 pos = UtilLib.getItemPosition(player, mainHand);
        if (player.m_21324_(1.0f) > 0.0f) {
            return;
        }
        pos = pos.m_82520_((double)((player.m_21187_().nextFloat() - 0.5f) * 0.1f), (double)((player.m_21187_().nextFloat() - 0.3f) * 0.9f), (double)((player.m_21187_().nextFloat() - 0.5f) * 0.1f));
        Vec3 playerPos = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_() - (double)0.2f, player.m_20189_());
        ModParticles.spawnParticleClient(player.m_20193_(), new FlyingBloodParticleData(ModParticles.flying_blood, (int)(4.0f / (player.m_21187_().nextFloat() * 0.6f + 0.1f)), true, pos.f_82479_, pos.f_82480_, pos.f_82481_), playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_);
    }
}

