/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.client.model.armor.ClothingBootsModel;
import de.teamlapen.vampirism.client.model.armor.ClothingCrownModel;
import de.teamlapen.vampirism.client.model.armor.ClothingPantsModel;
import de.teamlapen.vampirism.client.model.armor.DummyClothingModel;
import de.teamlapen.vampirism.client.model.armor.VampireHatModel;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.NotNull;

public class VampireClothingItem
extends ArmorItem
implements IFactionExclusiveItem {
    private final String regName;

    public VampireClothingItem(EquipmentSlot slotType, String regName) {
        super((ArmorMaterial)ArmorMaterials.LEATHER, slotType, new Item.Properties().m_41499_(ArmorMaterials.IRON.m_7366_(slotType)).m_41491_(VampirismMod.creativeTab));
        this.regName = regName;
        this.setRegistryName("vampirism", regName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        Player playerEntity = VampirismMod.proxy.getClientPlayer();
        this.addFactionPoisonousToolTip(stack, worldIn, tooltip, flagIn, playerEntity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            @NotNull
            public Model getBaseArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                return switch (VampireClothingItem.this.regName) {
                    case "vampire_clothing_crown" -> ClothingCrownModel.getAdjustedInstance(_default);
                    case "vampire_clothing_legs" -> ClothingPantsModel.getAdjustedInstance(_default);
                    case "vampire_clothing_boots" -> ClothingBootsModel.getAdjustedInstance(_default);
                    case "vampire_clothing_hat" -> VampireHatModel.getAdjustedInstance(_default);
                    default -> DummyClothingModel.getAdjustedInstance(_default);
                };
            }
        });
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return String.format("vampirism:textures/models/armor/%s.png", this.regName);
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@Nonnull ItemStack stack) {
        return VReference.VAMPIRE_FACTION;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        if (player.f_19797_ % 16 == 8 && !Helper.isVampire(player)) {
            player.m_7292_(new MobEffectInstance(ModEffects.poison, 20, 1));
        }
        if (stack.m_41720_() == ModItems.vampire_clothing_crown && stack.m_41788_() && "10000000".equals(stack.m_41786_().getString())) {
            UtilLib.spawnParticlesAroundEntity((LivingEntity)player, (ParticleOptions)ParticleTypes.f_123815_, 0.5, 4);
            if (player.f_19797_ % 16 == 4) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 30, 0));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100, 2));
            }
        }
    }
}

