/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.items.VampirismItem;
import de.teamlapen.vampirism.network.OpenVampireBookPacket;
import de.teamlapen.vampirism.util.VampireBookManager;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VampireBookItem
extends VampirismItem {
    private static final String regName = "vampire_book";

    public static boolean validBookTagContents(CompoundTag nbt) {
        if (!WritableBookItem.m_43452_((CompoundTag)nbt)) {
            return false;
        }
        if (!nbt.m_128441_("title")) {
            return false;
        }
        String s = nbt.m_128461_("title");
        return s.length() <= 32 && nbt.m_128441_("author");
    }

    public VampireBookItem() {
        super(regName, new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41487_(1).m_41491_(VampirismMod.creativeTab));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            CompoundTag compoundnbt = stack.m_41783_();
            String s = compoundnbt.m_128461_("author");
            if (!StringUtil.m_14408_((String)s)) {
                tooltip.add((Component)new TranslatableComponent("book.byAuthor", new Object[]{s}).m_130940_(ChatFormatting.GRAY));
            }
            tooltip.add((Component)new TextComponent("Vampirism knowledge").m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)VampireBookManager.getInstance().getRandomBook(new Random()));
        }
    }

    @Nonnull
    public Component m_7626_(ItemStack stack) {
        CompoundTag nbttagcompound;
        String s;
        if (stack.m_41782_() && !StringUtil.m_14408_((String)(s = (nbttagcompound = stack.m_41783_()).m_128461_("title")))) {
            return new TextComponent(s);
        }
        return super.m_7626_(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(@Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!worldIn.f_46443_ && playerIn instanceof ServerPlayer) {
            this.resolveContents(stack, playerIn);
            VampirismMod.dispatcher.sendTo(new OpenVampireBookPacket(stack), (ServerPlayer)playerIn);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void resolveContents(ItemStack stack, Player player) {
        CompoundTag nbttagcompound;
        if (!stack.m_41619_() && stack.m_41783_() != null && !(nbttagcompound = stack.m_41783_()).m_128471_("resolved")) {
            nbttagcompound.m_128379_("resolved", true);
            if (VampireBookItem.validBookTagContents(nbttagcompound)) {
                ListTag nbttaglist = nbttagcompound.m_128437_("pages", 8);
                for (int slot = 0; slot < nbttaglist.size(); ++slot) {
                    TextComponent lvt_7_1_;
                    String s = nbttaglist.m_128778_(slot);
                    try {
                        MutableComponent var11 = Component.Serializer.m_130714_((String)s);
                        lvt_7_1_ = ComponentUtils.m_130731_(null, (Component)var11, (Entity)player, (int)0);
                    }
                    catch (Exception var9) {
                        lvt_7_1_ = new TextComponent(s);
                    }
                    nbttaglist.set(slot, (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)lvt_7_1_)));
                }
                nbttagcompound.m_128365_("pages", (Tag)nbttaglist);
            }
        }
    }
}

