/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.SimpleCrossbowItem;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class TechCrossbowItem
extends SimpleCrossbowItem {
    public static final int MAX_ARROW_COUNT = 12;

    private static int getArrowsLeft(@Nonnull ItemStack bowStack) {
        CompoundTag nbt = bowStack.m_41783_();
        if (nbt == null || !nbt.m_128441_("arrows")) {
            return 0;
        }
        return nbt.m_128451_("arrows");
    }

    private static ItemStack setArrowsLeft(@Nonnull ItemStack bowStack, int arrows) {
        int i = Math.max(-1, Math.min(12, arrows));
        CompoundTag nbt = bowStack.m_41782_() ? bowStack.m_41783_() : new CompoundTag();
        nbt.m_128405_("arrows", i);
        bowStack.m_41751_(nbt);
        return bowStack;
    }

    private static boolean reduceArrowCount(@Nonnull ItemStack bowStack, Random rnd) {
        CompoundTag nbt = bowStack.m_41783_();
        if (nbt == null || !nbt.m_128441_("arrows")) {
            return false;
        }
        int count = nbt.m_128451_("arrows");
        if (count == -1) {
            return true;
        }
        if (count == 0) {
            return false;
        }
        int frugal = TechCrossbowItem.isCrossbowFrugal(bowStack);
        if (frugal > 0 && rnd.nextInt(Math.max(2, 4 - frugal)) == 0) {
            return true;
        }
        nbt.m_128405_("arrows", count - 1);
        bowStack.m_41751_(nbt);
        return true;
    }

    public static ItemStack getLoadedItemStack(TechCrossbowItem crossbow) {
        return TechCrossbowItem.setArrowsLeft(new ItemStack((ItemLike)crossbow, 1), 12);
    }

    public static ItemStack getUnLoadedItemStack(TechCrossbowItem crossbow) {
        return TechCrossbowItem.setArrowsLeft(new ItemStack((ItemLike)crossbow, 1), 0);
    }

    public TechCrossbowItem(String regName, float speed, int cooldown, int maxDamage) {
        super(regName, speed, cooldown, maxDamage);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        int arrows = TechCrossbowItem.getArrowsLeft(stack);
        if (arrows == -1) {
            tooltip.add((Component)new TranslatableComponent(Enchantments.f_44952_.m_44704_()).m_130940_(ChatFormatting.DARK_GRAY));
        } else if (arrows == 0) {
            tooltip.add((Component)new TranslatableComponent("text.vampirism.crossbow.not_loaded").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            tooltip.add((Component)new TranslatableComponent("text.vampirism.crossbow.loaded_arrow_count", new Object[]{arrows}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)TechCrossbowItem.setArrowsLeft(new ItemStack((ItemLike)this), 0));
            items.add((Object)TechCrossbowItem.setArrowsLeft(new ItemStack((ItemLike)this), 12));
        }
    }

    @Override
    public boolean m_6832_(@Nonnull ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(Tags.Items.INGOTS_IRON);
    }

    @Override
    @Nullable
    public ISkill<IHunterPlayer> getRequiredSkill(@Nonnull ItemStack stack) {
        return HunterSkills.tech_weapons;
    }

    @Override
    @Nonnull
    protected ItemStack findAmmo(Player player, ItemStack bowStack) {
        boolean arrow = TechCrossbowItem.reduceArrowCount(bowStack, player.m_21187_());
        if (!arrow) {
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack itemstack = player.m_150109_().m_8020_(i);
                if (itemstack.m_41619_() || !this.isArrowPackage(itemstack)) continue;
                TechCrossbowItem.setArrowsLeft(bowStack, 12);
                if (!player.m_150110_().f_35937_) {
                    player.m_150109_().m_7407_(i, 1);
                }
                player.m_36335_().m_41524_(bowStack.m_41720_(), this.getReloadCooldown(player, bowStack));
            }
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)ModItems.crossbow_arrow_normal);
    }

    @Override
    protected float getArrowVelocity() {
        return 1.7f;
    }

    @Override
    protected int getCooldown(Player player, ItemStack stack) {
        return 8;
    }

    @Override
    protected boolean isCrossbowInfinite(ItemStack stack, Player player) {
        return false;
    }

    @Override
    protected boolean shouldConsumeArrow(Random rnd, ItemStack arrowStack, boolean playerCreative, boolean bowInfinite, int frugal) {
        return false;
    }

    private int getReloadCooldown(Player player, ItemStack bowStack) {
        return 100;
    }

    private boolean isArrowPackage(@Nonnull ItemStack stack) {
        return ((Object)((Object)ModItems.tech_crossbow_ammo_package)).equals(stack.m_41720_());
    }
}

