/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismHunterArmor;
import de.teamlapen.vampirism.util.VampirismArmorMaterials;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ObsidianArmorItem
extends VampirismHunterArmor
implements IItemWithTier {
    private static final String baseRegName = "obsidian_armor";
    private final IItemWithTier.TIER tier;
    private static final int[] DAMAGE_REDUCTION_ULTIMATE = new int[]{5, 8, 10, 5};
    private static final int[] DAMAGE_REDUCTION_ENHANCED = new int[]{4, 7, 9, 4};
    private static final int[] DAMAGE_REDUCTION_NORMAL = new int[]{3, 6, 8, 3};
    private static final float[] SPEED_REDUCTION = new float[]{-0.025f, -0.1f, -0.05f, -0.025f};

    public static boolean isFullyEquipped(Player player) {
        for (ItemStack stack : player.m_150109_().f_35975_) {
            if (!stack.m_41619_() && stack.m_41720_() instanceof ObsidianArmorItem) continue;
            return false;
        }
        return true;
    }

    private static Map<Attribute, Tuple<Double, AttributeModifier.Operation>> getModifiers(EquipmentSlot slot, IItemWithTier.TIER tier) {
        HashMap<Attribute, Tuple<Double, AttributeModifier.Operation>> map = new HashMap<Attribute, Tuple<Double, AttributeModifier.Operation>>();
        int slot1 = slot.m_20749_();
        int damageReduction = switch (tier) {
            case IItemWithTier.TIER.ULTIMATE -> DAMAGE_REDUCTION_ULTIMATE[slot1];
            case IItemWithTier.TIER.ENHANCED -> DAMAGE_REDUCTION_ENHANCED[slot1];
            default -> DAMAGE_REDUCTION_NORMAL[slot1];
        };
        float speedReduction = SPEED_REDUCTION[slot.m_20749_()];
        map.put(Attributes.f_22284_, new Tuple((Object)damageReduction, (Object)AttributeModifier.Operation.ADDITION));
        map.put(Attributes.f_22279_, new Tuple((Object)speedReduction, (Object)AttributeModifier.Operation.MULTIPLY_TOTAL));
        return map;
    }

    public ObsidianArmorItem(EquipmentSlot equipmentSlotIn, IItemWithTier.TIER tier) {
        super(baseRegName, tier.getName(), VampirismArmorMaterials.OBSIDIAN, equipmentSlotIn, new Item.Properties().m_41491_(VampirismMod.creativeTab).m_41486_(), ObsidianArmorItem.getModifiers(equipmentSlotIn, tier));
        this.tier = tier;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(tooltip);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return switch (this.getVampirismTier()) {
            case IItemWithTier.TIER.ENHANCED -> this.getTextureLocation("obsidian_armor_of_hell_enhanced", slot, type);
            case IItemWithTier.TIER.ULTIMATE -> this.getTextureLocation("obsidian_armor_of_hell_ultimate", slot, type);
            default -> this.getTextureLocation("obsidian_armor_of_hell", slot, type);
        };
    }

    @Override
    public String getBaseRegName() {
        return baseRegName;
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }
}

