/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.items.VampirismItem;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class OblivionItem
extends VampirismItem {
    public static void applyEffect(IFactionPlayer<?> factionPlayer) {
        Player player = factionPlayer.getRepresentingPlayer();
        FactionPlayerHandler.getOpt(player).ifPresent(fph -> {
            ISkillHandler skillHandler = factionPlayer.getSkillHandler();
            if (((SkillHandler)skillHandler).getRootNode().getChildren().stream().flatMap(a -> Arrays.stream(a.getElements())).noneMatch(skillHandler::isSkillEnabled)) {
                return;
            }
            boolean test = VampirismMod.inDev || VampirismMod.instance.getVersionInfo().getCurrentVersion().isTestVersion();
            player.m_7292_(new MobEffectInstance(ModEffects.oblivion, Integer.MAX_VALUE, test ? 100 : 4));
            if (factionPlayer instanceof ISyncable.ISyncableEntityCapabilityInst) {
                HelperLib.sync((ISyncable.ISyncableEntityCapabilityInst)((Object)factionPlayer), (Entity)factionPlayer.getRepresentingPlayer(), false);
            }
        });
    }

    public OblivionItem(String regName, Item.Properties properties) {
        super(regName, properties.m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("text.vampirism.oblivion_potion.resets_skills").m_130940_(ChatFormatting.GRAY));
    }

    @Nonnull
    public ItemStack m_5922_(ItemStack stack, @Nonnull Level worldIn, @Nonnull LivingEntity entityLiving) {
        stack.m_41774_(1);
        if (entityLiving instanceof Player) {
            FactionPlayerHandler.getOpt((Player)entityLiving).map(FactionPlayerHandler::getCurrentFactionPlayer).orElseGet(Optional::empty).ifPresent(OblivionItem::applyEffect);
        }
        if (entityLiving instanceof MinionEntity) {
            ((MinionEntity)entityLiving).getMinionData().ifPresent(d -> d.upgradeStat(-1, (MinionEntity)entityLiving));
        }
        return stack;
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return 32;
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.DRINK;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level worldIn, @Nonnull Player playerIn, @Nonnull InteractionHand handIn) {
        return ItemUtils.m_150959_((Level)worldIn, (Player)playerIn, (InteractionHand)handIn);
    }
}

