/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class HolyWaterBottleItem
extends VampirismItem
implements IItemWithTier,
IFactionExclusiveItem {
    public static final String regName = "holy_water_bottle";
    private final IItemWithTier.TIER tier;

    public HolyWaterBottleItem(IItemWithTier.TIER tier) {
        this("holy_water_bottle_" + tier.getName(), tier, new Item.Properties().m_41491_(VampirismMod.creativeTab));
        this.setTranslation_key(regName);
    }

    protected HolyWaterBottleItem(String regName, IItemWithTier.TIER tier, Item.Properties props) {
        super(regName, props);
        this.tier = tier;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(tooltip);
    }

    @Override
    public String getBaseRegName() {
        return regName;
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@Nonnull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    public EnumStrength getStrength(IItemWithTier.TIER tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case IItemWithTier.TIER.NORMAL -> EnumStrength.WEAK;
            case IItemWithTier.TIER.ENHANCED -> EnumStrength.MEDIUM;
            case IItemWithTier.TIER.ULTIMATE -> EnumStrength.STRONG;
        };
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }
}

