/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HeartSeekerItem
extends VampirismVampireSword
implements IItemWithTier {
    public static final String regName = "heart_seeker";
    private static final int[] DAMAGE_TIER = new int[]{7, 8, 9};
    private static final float[] UNTRAINED_SPEED_TIER = new float[]{-3.6f, -3.5f, -3.4f};
    private static final float[] TRAINED_SPEED_TIER = new float[]{-2.2f, -2.1f, -2.0f};
    private final IItemWithTier.TIER tier;

    public HeartSeekerItem(IItemWithTier.TIER tier) {
        super("heart_seeker_" + tier.getName(), Tiers.IRON, DAMAGE_TIER[tier.ordinal()], UNTRAINED_SPEED_TIER[tier.ordinal()], TRAINED_SPEED_TIER[tier.ordinal()], new Item.Properties().m_41491_(VampirismMod.creativeTab).m_41503_(2500));
        this.tier = tier;
        this.setTranslation_key(regName);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        this.addTierInformation(tooltip);
    }

    @Override
    public String getBaseRegName() {
        return regName;
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, ItemStack repair) {
        return ((Object)((Object)(this.getVampirismTier() == IItemWithTier.TIER.NORMAL ? ModItems.blood_infused_iron_ingot : ModItems.blood_infused_enhanced_iron_ingot))).equals(repair.m_41720_()) || super.m_6832_(toRepair, repair);
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    public float getXpRepairRatio(ItemStack stack) {
        return this.getVampirismTier() == IItemWithTier.TIER.ULTIMATE ? super.getXpRepairRatio(stack) / 2.0f : super.getXpRepairRatio(stack);
    }

    @Override
    protected float getChargeUsage() {
        return (float)((Double)VampirismConfig.BALANCE.vampireSwordBloodUsageFactor.get() / 100.0 * (double)(this.getVampirismTier().ordinal() + 2) / 2.0);
    }

    @Override
    protected float getChargingFactor(ItemStack stack) {
        return (float)((Double)VampirismConfig.BALANCE.vampireSwordChargingFactor.get() * 2.0 / (double)((float)this.getVampirismTier().ordinal() + 2.0f));
    }
}

