/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blocks.BloodContainerBlock;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.items.VampirismItem;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import javax.annotation.Nonnull;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class FeedingAdapterItem
extends VampirismItem {
    private static final String regName = "feeding_adapter";

    public FeedingAdapterItem() {
        super(regName, new Item.Properties().m_41487_(1).m_41491_(VampirismMod.creativeTab));
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return 15;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (!(player instanceof Player) || !player.m_6084_()) {
            player.m_21253_();
            return;
        }
        ItemStack bloodContainer = BloodHelper.getBloodContainerInInventory(((Player)player).m_150109_(), true, false);
        FluidStack fluidStack = BloodContainerBlock.getFluidFromItemStack(bloodContainer);
        int blood = fluidStack.isEmpty() || fluidStack.getFluid() != ModFluids.blood ? 0 : fluidStack.getAmount();
        VampirePlayer vampire = VampirePlayer.get((Player)player);
        if (vampire.getLevel() == 0 || blood == 0 || !vampire.getBloodStats().needsBlood()) {
            player.m_21253_();
            return;
        }
        if (blood > 0 && count == 1) {
            int drink = Math.min(blood, 300);
            BloodContainerBlock.writeFluidToItemStack(bloodContainer, new FluidStack(ModFluids.blood, blood - drink));
            vampire.drinkBlood(Math.round((float)drink / 100.0f), 0.3f, false);
            if ((blood -= drink) > 0) {
                player.m_6672_(player.m_7655_());
            }
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        return VampirePlayer.getOpt(playerIn).map(vampire -> {
            if (vampire.getLevel() == 0) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            if (vampire.getBloodStats().needsBlood() && !BloodHelper.getBloodContainerInInventory(playerIn.m_150109_(), true, false).m_41619_()) {
                playerIn.m_6672_(handIn);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }).orElse(new InteractionResultHolder(InteractionResult.PASS, (Object)stack));
    }
}

