/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.items.VampirismItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CrossbowArrowItem
extends VampirismItem
implements IVampirismCrossbowArrow<CrossbowArrowEntity> {
    private static final String regName = "crossbow_arrow";
    private final EnumArrowType type;

    public CrossbowArrowItem(EnumArrowType type) {
        super("crossbow_arrow_" + type.getName(), new Item.Properties().m_41491_(VampirismMod.creativeTab));
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack itemStack, @Nullable Level world, @Nonnull List<Component> textComponents, @Nonnull TooltipFlag tooltipFlag) {
        if (this.type != EnumArrowType.NORMAL) {
            textComponents.add((Component)new TranslatableComponent(this.type == EnumArrowType.VAMPIRE_KILLER ? "item.vampirism.crossbow_arrow_vampire_killer.tooltip" : "item.vampirism.crossbow_arrow_spitfire.tooltip").m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public CrossbowArrowEntity createEntity(ItemStack stack, Level world, Player player, double heightOffset, double centerOffset, boolean rightHand) {
        CrossbowArrowEntity entity = CrossbowArrowEntity.createWithShooter(world, (LivingEntity)player, heightOffset, centerOffset, rightHand, stack);
        entity.m_36781_(this.type.baseDamage * (Double)VampirismConfig.BALANCE.crossbowDamageMult.get());
        if (this.type == EnumArrowType.SPITFIRE) {
            entity.m_20254_(100);
        }
        return entity;
    }

    public EnumArrowType getType() {
        return this.type;
    }

    @Override
    public boolean isCanBeInfinite() {
        return this.type != EnumArrowType.VAMPIRE_KILLER && this.type != EnumArrowType.SPITFIRE || (Boolean)VampirismConfig.BALANCE.allowInfiniteSpecialArrows.get() != false;
    }

    @Override
    public void onHitBlock(ItemStack arrow, BlockPos blockPos, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        CrossbowArrowEntity entity = (CrossbowArrowEntity)arrowEntity;
        if (this.type == EnumArrowType.SPITFIRE) {
            for (int dx = -1; dx < 2; ++dx) {
                for (int dy = -2; dy < 2; ++dy) {
                    for (int dz = -1; dz < 2; ++dz) {
                        BlockPos pos = blockPos.m_142082_(dx, dy, dz);
                        BlockState blockState = entity.m_20193_().m_8055_(pos);
                        if (!blockState.m_60767_().m_76336_() || !entity.m_20193_().m_8055_(pos.m_7495_()).m_60783_((BlockGetter)entity.m_20193_(), pos.m_7495_(), Direction.UP) || entity.getRNG().nextInt(4) == 0) continue;
                        entity.m_20193_().m_46597_(pos, ModBlocks.alchemical_fire.m_49966_());
                    }
                }
            }
        }
    }

    @Override
    public void onHitEntity(ItemStack arrow, LivingEntity entity, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
        float max;
        if (this.type == EnumArrowType.VAMPIRE_KILLER && entity instanceof IVampireMob && (max = entity.m_21233_()) < (float)((Integer)VampirismConfig.BALANCE.arrowVampireKillerMaxHealth.get()).intValue()) {
            entity.m_6469_(DamageSource.m_19346_((AbstractArrow)((AbstractArrow)arrowEntity), (Entity)shootingEntity), max);
        }
    }

    public static enum EnumArrowType implements StringRepresentable
    {
        NORMAL("normal", 2.0, 0xFFFFFF),
        VAMPIRE_KILLER("vampire_killer", 0.5, 7995507),
        SPITFIRE("spitfire", 0.5, 0xFF2211);

        public final int color;
        final String name;
        final double baseDamage;

        private EnumArrowType(String name, double baseDamage, int color) {
            this.name = name;
            this.baseDamage = baseDamage;
            this.color = color;
        }

        public String getName() {
            return this.m_7912_();
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }
    }
}

