/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.client.model.armor.CloakModel;
import de.teamlapen.vampirism.items.VampireClothingItem;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.NotNull;

public class ColoredVampireClothingItem
extends VampireClothingItem {
    private final String baseName;
    private final EnumClothingColor color;
    private final EnumModel model;

    public ColoredVampireClothingItem(EquipmentSlot slotType, EnumModel model, String baseRegName, EnumClothingColor color) {
        super(slotType, baseRegName + "_" + color.getName());
        this.baseName = baseRegName;
        this.color = color;
        this.model = model;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            @NotNull
            public Model getBaseArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                return switch (ColoredVampireClothingItem.this.model) {
                    case EnumModel.CLOAK -> CloakModel.getAdjustedCloak(_default);
                    default -> CloakModel.getAdjustedCloak(_default);
                };
            }
        });
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return String.format("vampirism:textures/models/armor/%s/%s_%s.png", this.baseName, this.baseName, this.color.getName());
    }

    public static enum EnumClothingColor implements StringRepresentable
    {
        REDBLACK("red_black"),
        BLACKRED("black_red"),
        BLACKWHITE("black_white"),
        WHITEBLACK("white_black"),
        BLACKBLUE("black_blue");

        private final String name;

        private EnumClothingColor(String nameIn) {
            this.name = nameIn;
        }

        public String getName() {
            return this.m_7912_();
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }
    }

    public static enum EnumModel {
        CLOAK;

    }
}

